/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedSingleRelativeRanking;

public abstract class CDFRandomGenerator {
    final double[] rankings;
    final long[] values;
    final Random random;

    CDFRandomGenerator(LoggedDiscreteCDF cdf) {
        this(cdf, new Random());
    }

    CDFRandomGenerator(LoggedDiscreteCDF cdf, long seed) {
        this(cdf, new Random(seed));
    }

    private CDFRandomGenerator(LoggedDiscreteCDF cdf, Random random) {
        this.random = random;
        this.rankings = new double[cdf.getRankings().size() + 2];
        this.values = new long[cdf.getRankings().size() + 2];
        this.initializeTables(cdf);
    }

    protected final void initializeTables(LoggedDiscreteCDF cdf) {
        this.rankings[0] = 0.0;
        this.values[0] = cdf.getMinimum();
        this.rankings[this.rankings.length - 1] = 1.0;
        this.values[this.rankings.length - 1] = cdf.getMaximum();
        List subjects = cdf.getRankings();
        for (int i = 0; i < subjects.size(); ++i) {
            this.rankings[i + 1] = ((LoggedSingleRelativeRanking)subjects.get(i)).getRelativeRanking();
            this.values[i + 1] = ((LoggedSingleRelativeRanking)subjects.get(i)).getDatum();
        }
    }

    protected int floorIndex(double probe) {
        int result = Arrays.binarySearch(this.rankings, probe);
        return Math.abs(result + 1) - 1;
    }

    protected double getRankingAt(int index) {
        return this.rankings[index];
    }

    protected long getDatumAt(int index) {
        return this.values[index];
    }

    public long randomValue() {
        return this.valueAt(this.random.nextDouble());
    }

    public abstract long valueAt(double var1);
}

