/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.oncrpc.security.VerifierNone;

public class SysSecurityHandler
extends SecurityHandler {
    private final IdUserGroup iug;
    private final CredentialsSys mCredentialsSys;

    public SysSecurityHandler(CredentialsSys credentialsSys, IdUserGroup iug) {
        this.mCredentialsSys = credentialsSys;
        this.iug = iug;
    }

    @Override
    public String getUser() {
        return this.iug.getUserName(this.mCredentialsSys.getUID(), "nobody");
    }

    @Override
    public boolean shouldSilentlyDrop(RpcCall request) {
        return false;
    }

    @Override
    public VerifierNone getVerifer(RpcCall request) {
        return new VerifierNone();
    }

    @Override
    public int getUid() {
        return this.mCredentialsSys.getUID();
    }

    @Override
    public int getGid() {
        return this.mCredentialsSys.getGID();
    }

    @Override
    public int[] getAuxGids() {
        return this.mCredentialsSys.getAuxGIDs();
    }
}

