/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIR3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class READDIR3Response
extends NFS3Response {
    private final Nfs3FileAttributes postOpDirAttr;
    private final long cookieVerf;
    private final DirList3 dirList;

    public READDIR3Response(int status) {
        this(status, new Nfs3FileAttributes());
    }

    public READDIR3Response(int status, Nfs3FileAttributes postOpAttr) {
        this(status, postOpAttr, 0L, null);
    }

    public READDIR3Response(int status, Nfs3FileAttributes postOpAttr, long cookieVerf, DirList3 dirList) {
        super(status);
        this.postOpDirAttr = postOpAttr;
        this.cookieVerf = cookieVerf;
        this.dirList = dirList;
    }

    public Nfs3FileAttributes getPostOpAttr() {
        return this.postOpDirAttr;
    }

    public long getCookieVerf() {
        return this.cookieVerf;
    }

    public DirList3 getDirList() {
        return this.dirList;
    }

    public XDR writeHeaderAndResponse(XDR xdr, int xid, Verifier verifier) {
        super.writeHeaderAndResponse(xdr, xid, verifier);
        xdr.writeBoolean(true);
        this.postOpDirAttr.serialize(xdr);
        if (this.getStatus() == 0) {
            xdr.writeLongAsHyper(this.cookieVerf);
            for (Entry3 e : this.dirList.entries) {
                xdr.writeBoolean(true);
                xdr.writeLongAsHyper(e.getFileId());
                xdr.writeString(e.getName());
                xdr.writeLongAsHyper(e.getCookie());
            }
            xdr.writeBoolean(false);
            xdr.writeBoolean(this.dirList.eof);
        }
        return xdr;
    }
}

