/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;

public class SimpleUdpClient {
    protected final String host;
    protected final int port;
    protected final XDR request;
    protected final boolean oneShot;

    public SimpleUdpClient(String host, int port, XDR request) {
        this(host, port, request, true);
    }

    public SimpleUdpClient(String host, int port, XDR request, Boolean oneShot) {
        this.host = host;
        this.port = port;
        this.request = request;
        this.oneShot = oneShot;
    }

    public void run() throws IOException {
        DatagramSocket clientSocket = new DatagramSocket();
        InetAddress IPAddress = InetAddress.getByName(this.host);
        byte[] sendData = this.request.getBytes();
        byte[] receiveData = new byte[65535];
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, IPAddress, this.port);
        clientSocket.send(sendPacket);
        DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
        clientSocket.receive(receivePacket);
        XDR xdr = new XDR(Arrays.copyOfRange(receiveData, 0, receivePacket.getLength()));
        RpcReply reply = RpcReply.read(xdr);
        if (reply.getState() != RpcReply.ReplyState.MSG_ACCEPTED) {
            throw new IOException("Request failed: " + (Object)((Object)reply.getState()));
        }
        clientSocket.close();
    }
}

