/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.junit.Assert;
import org.junit.Test;

public class TestIdUserGroup {
    @Test
    public void testDuplicates() throws IOException {
        String GET_ALL_USERS_CMD = "echo \"root:x:0:0:root:/root:/bin/bash\nhdfs:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\nhdfs:x:11502:10788:Grid Distributed File System:/home/hdfs:/bin/bash\nhdfs1:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\nhdfs2:x:11502:10787:Grid Distributed File System:/home/hdfs:/bin/bash\nbin:x:2:2:bin:/bin:/bin/sh\nbin:x:1:1:bin:/bin:/sbin/nologin\ndaemon:x:1:1:daemon:/usr/sbin:/bin/sh\ndaemon:x:2:2:daemon:/sbin:/sbin/nologin\" | cut -d: -f1,3";
        String GET_ALL_GROUPS_CMD = "echo \"hdfs:*:11501:hrt_hdfs\nmapred:x:497\nmapred2:x:497\nmapred:x:498\nmapred3:x:498\" | cut -d: -f1,3";
        HashBiMap uMap = HashBiMap.create();
        HashBiMap gMap = HashBiMap.create();
        IdUserGroup.updateMapInternal((BiMap)uMap, (String)"user", (String)GET_ALL_USERS_CMD, (String)":");
        Assert.assertTrue((uMap.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)uMap.get((Object)0), (Object)"root");
        Assert.assertEquals((Object)uMap.get((Object)11501), (Object)"hdfs");
        Assert.assertEquals((Object)uMap.get((Object)11502), (Object)"hdfs2");
        Assert.assertEquals((Object)uMap.get((Object)2), (Object)"bin");
        Assert.assertEquals((Object)uMap.get((Object)1), (Object)"daemon");
        IdUserGroup.updateMapInternal((BiMap)gMap, (String)"group", (String)GET_ALL_GROUPS_CMD, (String)":");
        Assert.assertTrue((gMap.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gMap.get((Object)11501), (Object)"hdfs");
        Assert.assertEquals((Object)gMap.get((Object)497), (Object)"mapred");
        Assert.assertEquals((Object)gMap.get((Object)498), (Object)"mapred3");
    }

    @Test
    public void testIdOutOfIntegerRange() throws IOException {
        String GET_ALL_USERS_CMD = "echo \"nfsnobody:x:4294967294:4294967294:Anonymous NFS User:/var/lib/nfs:/sbin/nologin\nnfsnobody1:x:4294967295:4294967295:Anonymous NFS User:/var/lib/nfs1:/sbin/nologin\nmaxint:x:2147483647:2147483647:Grid Distributed File System:/home/maxint:/bin/bash\nminint:x:2147483648:2147483648:Grid Distributed File System:/home/minint:/bin/bash\narchivebackup:*:1031:4294967294:Archive Backup:/home/users/archivebackup:/bin/sh\nhdfs:x:11501:10787:Grid Distributed File System:/home/hdfs:/bin/bash\ndaemon:x:2:2:daemon:/sbin:/sbin/nologin\" | cut -d: -f1,3";
        String GET_ALL_GROUPS_CMD = "echo \"hdfs:*:11501:hrt_hdfs\nrpcuser:*:29:\nnfsnobody:*:4294967294:\nnfsnobody1:*:4294967295:\nmaxint:*:2147483647:\nminint:*:2147483648:\nmapred3:x:498\" | cut -d: -f1,3";
        HashBiMap uMap = HashBiMap.create();
        HashBiMap gMap = HashBiMap.create();
        IdUserGroup.updateMapInternal((BiMap)uMap, (String)"user", (String)GET_ALL_USERS_CMD, (String)":");
        Assert.assertTrue((uMap.size() == 7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nfsnobody", (Object)uMap.get((Object)-2));
        Assert.assertEquals((Object)"nfsnobody1", (Object)uMap.get((Object)-1));
        Assert.assertEquals((Object)"maxint", (Object)uMap.get((Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)"minint", (Object)uMap.get((Object)Integer.MIN_VALUE));
        Assert.assertEquals((Object)"archivebackup", (Object)uMap.get((Object)1031));
        Assert.assertEquals((Object)"hdfs", (Object)uMap.get((Object)11501));
        Assert.assertEquals((Object)"daemon", (Object)uMap.get((Object)2));
        IdUserGroup.updateMapInternal((BiMap)gMap, (String)"group", (String)GET_ALL_GROUPS_CMD, (String)":");
        Assert.assertTrue((gMap.size() == 7 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"hdfs", (Object)gMap.get((Object)11501));
        Assert.assertEquals((Object)"rpcuser", (Object)gMap.get((Object)29));
        Assert.assertEquals((Object)"nfsnobody", (Object)gMap.get((Object)-2));
        Assert.assertEquals((Object)"nfsnobody1", (Object)gMap.get((Object)-1));
        Assert.assertEquals((Object)"maxint", (Object)gMap.get((Object)Integer.MAX_VALUE));
        Assert.assertEquals((Object)"minint", (Object)gMap.get((Object)Integer.MIN_VALUE));
        Assert.assertEquals((Object)"mapred3", (Object)gMap.get((Object)498));
    }

    @Test
    public void testUserUpdateSetting() throws IOException {
        IdUserGroup iug = new IdUserGroup();
        Assert.assertEquals((long)iug.getTimeout(), (long)900000L);
        Configuration conf = new Configuration();
        conf.setLong("hadoop.nfs.userupdate.milly", 0L);
        iug = new IdUserGroup(conf);
        Assert.assertEquals((long)iug.getTimeout(), (long)60000L);
        conf.setLong("hadoop.nfs.userupdate.milly", 1800000L);
        iug = new IdUserGroup(conf);
        Assert.assertEquals((long)iug.getTimeout(), (long)1800000L);
    }
}

