/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleTcpClient;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.TestFrameDecoder;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.jboss.netty.buffer.ByteBufferBackedChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFrameDecoder {
    private static int resultSize;

    static void testRequest(XDR request, int serverPort) {
        SimpleTcpClient tcpClient = new SimpleTcpClient("localhost", serverPort, request, Boolean.valueOf(true));
        tcpClient.run();
    }

    @Test
    public void testSingleFrame() {
        RpcUtil.RpcFrameDecoder decoder = new RpcUtil.RpcFrameDecoder();
        ByteBuffer buffer = ByteBuffer.allocate(1);
        ByteBufferBackedChannelBuffer buf = new ByteBufferBackedChannelBuffer(buffer);
        ChannelBuffer channelBuffer = (ChannelBuffer)decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Channel)Mockito.mock(Channel.class), (ChannelBuffer)buf);
        Assert.assertTrue((channelBuffer == null ? 1 : 0) != 0);
        byte[] fragment = new byte[13];
        fragment[0] = -128;
        fragment[1] = 0;
        fragment[2] = 0;
        fragment[3] = 10;
        Assert.assertTrue((boolean)XDR.isLastFragment((byte[])fragment));
        Assert.assertTrue((XDR.fragmentSize((byte[])fragment) == 10 ? 1 : 0) != 0);
        buffer = ByteBuffer.allocate(13);
        buffer.put(fragment);
        buffer.flip();
        buf = new ByteBufferBackedChannelBuffer(buffer);
        channelBuffer = (ChannelBuffer)decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Channel)Mockito.mock(Channel.class), (ChannelBuffer)buf);
        Assert.assertTrue((channelBuffer == null ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleFrames() {
        RpcUtil.RpcFrameDecoder decoder = new RpcUtil.RpcFrameDecoder();
        byte[] fragment1 = new byte[14];
        fragment1[0] = 0;
        fragment1[1] = 0;
        fragment1[2] = 0;
        fragment1[3] = 10;
        Assert.assertFalse((boolean)XDR.isLastFragment((byte[])fragment1));
        Assert.assertTrue((XDR.fragmentSize((byte[])fragment1) == 10 ? 1 : 0) != 0);
        ByteBuffer buffer = ByteBuffer.allocate(14);
        buffer.put(fragment1);
        buffer.flip();
        ByteBufferBackedChannelBuffer buf = new ByteBufferBackedChannelBuffer(buffer);
        ChannelBuffer channelBuffer = (ChannelBuffer)decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Channel)Mockito.mock(Channel.class), (ChannelBuffer)buf);
        Assert.assertTrue((channelBuffer == null ? 1 : 0) != 0);
        byte[] fragment2 = new byte[14];
        fragment2[0] = -128;
        fragment2[1] = 0;
        fragment2[2] = 0;
        fragment2[3] = 10;
        Assert.assertTrue((boolean)XDR.isLastFragment((byte[])fragment2));
        Assert.assertTrue((XDR.fragmentSize((byte[])fragment2) == 10 ? 1 : 0) != 0);
        buffer = ByteBuffer.allocate(14);
        buffer.put(fragment2);
        buffer.flip();
        buf = new ByteBufferBackedChannelBuffer(buffer);
        channelBuffer = (ChannelBuffer)decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Channel)Mockito.mock(Channel.class), (ChannelBuffer)buf);
        Assert.assertTrue((channelBuffer != null ? 1 : 0) != 0);
        Assert.assertEquals((long)20L, (long)channelBuffer.readableBytes());
    }

    @Test
    public void testFrames() {
        Random rand = new Random();
        int serverPort = 30000 + rand.nextInt(10000);
        int retries = 10;
        while (true) {
            try {
                TestRpcProgram program = new TestRpcProgram("TestRpcProgram", "localhost", serverPort, 100000, 1, 2);
                SimpleTcpServer tcpServer = new SimpleTcpServer(serverPort, (RpcProgram)program, 1);
                tcpServer.run();
            }
            catch (ChannelException ce) {
                if (retries-- > 0) {
                    serverPort += rand.nextInt(20);
                    continue;
                }
                throw ce;
            }
            break;
        }
        XDR xdrOut = TestFrameDecoder.createGetportMount();
        int headerSize = xdrOut.size();
        int bufsize = 0x200000;
        byte[] buffer = new byte[bufsize];
        xdrOut.writeFixedOpaque(buffer);
        int requestSize = xdrOut.size() - headerSize;
        TestFrameDecoder.testRequest((XDR)xdrOut, (int)serverPort);
        Assert.assertEquals((long)requestSize, (long)resultSize);
    }

    static void createPortmapXDRheader(XDR xdr_out, int procedure) {
        RpcCall.getInstance((int)0, (int)100000, (int)2, (int)procedure, (Credentials)new CredentialsNone(), (Verifier)new VerifierNone()).write(xdr_out);
    }

    static XDR createGetportMount() {
        XDR xdr_out = new XDR();
        TestFrameDecoder.createPortmapXDRheader((XDR)xdr_out, (int)3);
        return xdr_out;
    }

    static /* synthetic */ int access$002(int x0) {
        resultSize = x0;
        return resultSize;
    }
}

