/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;

public class SimpleUdpServer {
    public static final Log LOG = LogFactory.getLog(SimpleUdpServer.class);
    private final int SEND_BUFFER_SIZE = 65536;
    private final int RECEIVE_BUFFER_SIZE = 65536;
    protected final int port;
    protected final SimpleChannelUpstreamHandler rpcProgram;
    protected final int workerCount;
    protected int boundPort = -1;

    public SimpleUdpServer(int port, SimpleChannelUpstreamHandler program, int workerCount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workerCount;
    }

    public void run() {
        NioDatagramChannelFactory f = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool(), this.workerCount);
        ConnectionlessBootstrap b = new ConnectionlessBootstrap((ChannelFactory)f);
        b.setPipeline(Channels.pipeline((ChannelHandler[])new ChannelHandler[]{RpcUtil.STAGE_RPC_MESSAGE_PARSER, this.rpcProgram, RpcUtil.STAGE_RPC_UDP_RESPONSE}));
        b.setOption("broadcast", (Object)"false");
        b.setOption("sendBufferSize", (Object)65536);
        b.setOption("receiveBufferSize", (Object)65536);
        Channel ch = b.bind((SocketAddress)new InetSocketAddress(this.port));
        InetSocketAddress socketAddr = (InetSocketAddress)ch.getLocalAddress();
        this.boundPort = socketAddr.getPort();
        LOG.info((Object)("Started listening to UDP requests at port " + this.boundPort + " for " + this.rpcProgram + " with workerCount " + this.workerCount));
    }

    public int getBoundPort() {
        return this.boundPort;
    }
}

