/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import org.apache.hadoop.examples.pi.math.Modular;
import org.apache.hadoop.examples.pi.math.Montgomery;

class Montgomery {
    protected final Product product = new Product(this);
    protected long N;
    protected long N_I;
    protected long R;
    protected long R_1;
    protected int s;

    Montgomery() {
    }

    Montgomery set(long n) {
        if (n % 2L != 1L) {
            throw new IllegalArgumentException("n % 2 != 1, n=" + n);
        }
        this.N = n;
        this.R = Long.highestOneBit(n) << 1;
        this.N_I = this.R - Modular.modInverse((long)this.N, (long)this.R);
        this.R_1 = this.R - 1L;
        this.s = Long.numberOfTrailingZeros(this.R);
        return this;
    }

    long mod(long y) {
        long p = this.R - this.N;
        long x = p << 1;
        if (x >= this.N) {
            x -= this.N;
        }
        for (long mask = Long.highestOneBit(y); mask > 0L; mask >>>= 1) {
            p = this.product.m(p, p);
            if ((mask & y) == 0L) continue;
            p = this.product.m(p, x);
        }
        return this.product.m(p, 1L);
    }
}

