/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.blocklocality;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Progressable;

public class LocalityOutputFormat
extends TextOutputFormat<Text, Text> {
    static final String FINAL_SYNC_ATTRIBUTE = "blocklocality.final.sync";

    public static void setFinalSync(JobConf conf, boolean newValue) {
        conf.setBoolean(FINAL_SYNC_ATTRIBUTE, newValue);
    }

    public static boolean getFinalSync(JobConf conf) {
        return conf.getBoolean(FINAL_SYNC_ATTRIBUTE, false);
    }

    public RecordWriter<Text, Text> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path dir = LocalityOutputFormat.getWorkOutputPath((JobConf)job);
        FileSystem fs = dir.getFileSystem((Configuration)job);
        FSDataOutputStream fileOut = fs.create(new Path(dir, name), progress);
        return new LocalityRecordWriter((DataOutputStream)fileOut, job);
    }

    static class LocalityRecordWriter
    extends TextOutputFormat.LineRecordWriter<Text, Text> {
        private static final byte[] newLine = "\r\n".getBytes();
        private boolean finalSync = false;

        public LocalityRecordWriter(DataOutputStream out, JobConf conf) {
            super(out);
            this.finalSync = LocalityOutputFormat.getFinalSync(conf);
        }

        public synchronized void write(Text key, Text value) throws IOException {
            this.out.write(key.getBytes(), 0, key.getLength());
            this.out.write(value.getBytes(), 0, value.getLength());
            this.out.write(newLine, 0, newLine.length);
        }

        public void close() throws IOException {
            if (this.finalSync) {
                ((FSDataOutputStream)this.out).sync();
            }
            super.close(null);
        }
    }
}

