/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormat;
import org.apache.hadoop.examples.terasort.TeraOutputFormat;
import org.apache.hadoop.examples.terasort.TeraSort;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class TeraSort
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TeraSort.class);
    static String SIMPLE_PARTITIONER = "mapreduce.terasort.simplepartitioner";
    static String OUTPUT_REPLICATION = "mapreduce.terasort.output.replication";

    public static boolean getUseSimplePartitioner(JobContext job) {
        return job.getConfiguration().getBoolean(SIMPLE_PARTITIONER, false);
    }

    public static void setUseSimplePartitioner(Job job, boolean value) {
        job.getConfiguration().setBoolean(SIMPLE_PARTITIONER, value);
    }

    public static int getOutputReplication(JobContext job) {
        return job.getConfiguration().getInt(OUTPUT_REPLICATION, 1);
    }

    public static void setOutputReplication(Job job, int value) {
        job.getConfiguration().setInt(OUTPUT_REPLICATION, value);
    }

    public int run(String[] args) throws Exception {
        LOG.info((Object)"starting");
        Job job = Job.getInstance((Configuration)this.getConf());
        Path inputDir = new Path(args[0]);
        Path outputDir = new Path(args[1]);
        if (outputDir.getFileSystem(this.getConf()).exists(outputDir)) {
            throw new IOException("Output directory " + outputDir + " already exists.");
        }
        boolean useSimplePartitioner = TeraSort.getUseSimplePartitioner((JobContext)job);
        TeraInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setJobName("TeraSort");
        job.setJarByClass(TeraSort.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(TeraInputFormat.class);
        job.setOutputFormatClass(TeraOutputFormat.class);
        if (useSimplePartitioner) {
            job.setPartitionerClass(SimplePartitioner.class);
        } else {
            long start = System.currentTimeMillis();
            Path partitionFile = new Path(outputDir, "_partition.lst");
            URI partitionUri = new URI(partitionFile.toString() + "#" + "_partition.lst");
            try {
                TeraInputFormat.writePartitionFile((JobContext)job, (Path)partitionFile);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getMessage());
                return -1;
            }
            job.addCacheFile(partitionUri);
            long end = System.currentTimeMillis();
            System.out.println("Spent " + (end - start) + "ms computing partitions.");
            job.setPartitionerClass(TotalOrderPartitioner.class);
        }
        job.getConfiguration().setInt("dfs.replication", TeraSort.getOutputReplication((JobContext)job));
        TeraOutputFormat.setFinalSync((JobContext)job, (boolean)true);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        LOG.info((Object)"done");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TeraSort(), (String[])args);
        System.exit(res);
    }
}

