/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraGenWithCRC;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraValidateWithCRC
extends Configured
implements Tool {
    private static final Text error = new Text("error");
    static Log LOG = LogFactory.getLog(TeraGenWithCRC.class);

    public int run(String[] args) throws Exception {
        JobConf job = (JobConf)this.getConf();
        TeraInputFormatWithCRC.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        job.setJobName("TeraValidateWithCRC");
        job.setJarByClass(TeraValidateWithCRC.class);
        job.setMapperClass(ValidateMapper.class);
        job.setReducerClass(ValidateReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.setLong("mapred.min.split.size", Long.MAX_VALUE);
        job.setInputFormat(TeraInputFormatWithCRC.class);
        JobClient.runJob((JobConf)job);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraValidateWithCRC(), (String[])args);
        System.exit(res);
    }

    static class ValidateReducer
    extends MapReduceBase
    implements Reducer<Text, Text, Text, Text> {
        private boolean firstKey = true;
        private Text lastKey = new Text();
        private Text lastValue = new Text();

        ValidateReducer() {
        }

        public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            if (error.equals((Object)key)) {
                while (values.hasNext()) {
                    output.collect((Object)key, (Object)values.next());
                }
            } else {
                Text value = values.next();
                if (this.firstKey) {
                    this.firstKey = false;
                } else if (value.compareTo((BinaryComparable)this.lastValue) < 0) {
                    output.collect((Object)error, (Object)new Text("misordered keys last: " + this.lastKey + " '" + this.lastValue + "' current: " + key + " '" + value + "'"));
                }
                this.lastKey.set(key);
                this.lastValue.set(value);
            }
        }
    }

    static class ValidateMapper
    extends MapReduceBase
    implements Mapper<Text, Text, Text, Text> {
        private Text lastKey;
        private OutputCollector<Text, Text> output;
        private String filename;
        private final int filler_len = 58;
        private final int crc_len = 8;
        private final int rowid_len = 10;

        ValidateMapper() {
        }

        private String getFilename(FileSplit split) {
            return split.getPath().getName();
        }

        public void map(Text key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            if (this.lastKey == null) {
                this.filename = this.getFilename((FileSplit)reporter.getInputSplit());
                output.collect((Object)new Text(this.filename + ":begin"), (Object)key);
                this.lastKey = new Text();
                this.output = output;
            } else if (key.compareTo((BinaryComparable)this.lastKey) < 0) {
                output.collect((Object)error, (Object)new Text("misorder in " + this.filename + " last: '" + this.lastKey + "' current: '" + key + "'"));
            }
            this.lastKey.set(key);
        }

        public void close() throws IOException {
            if (this.lastKey != null) {
                this.output.collect((Object)new Text(this.filename + ":end"), (Object)this.lastKey);
            }
        }
    }
}

