/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.lib.partition.KeyFieldHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestKeyFieldHelper
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestKeyFieldHelper.class);

    public void testparseOption() throws Exception {
        String keySpecs;
        KeyFieldHelper helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        String eKeySpecs = keySpecs = "-k1.2,3.4";
        helper.parseOption(keySpecs);
        String actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k 1.2";
        eKeySpecs = "-k1.2,0.0";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-nr -k1.2,3.4";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-nr -k1.2,3.4n";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-nr -k1.2,3.4r";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-nr -k1.2,3.4 -k5.6,7.8n -k9.10,11.12r -k13.14,15.16nr";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8n";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k9.10,11.12r";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(2)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k13.14,15.16nr";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(3)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2n,3.4";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2r,3.4";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2nr,3.4";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2,3.4n";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2,3.4r";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2,3.4nr";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-nr -k1.2,3.4 -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8nr";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-n -k1.2,3.4 -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8n";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-r -k1.2,3.4 -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8r";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2,3.4n -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2,3.4r -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-k1.2,3.4nr -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        eKeySpecs = "-k5.6,7.8";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-n";
        eKeySpecs = "-k1.1,0.0n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-r";
        eKeySpecs = "-k1.1,0.0r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
        keySpecs = "-nr";
        eKeySpecs = "-k1.1,0.0nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        TestKeyFieldHelper.assertEquals((String)"KeyFieldHelper's parsing is garbled", (String)eKeySpecs, (String)actKeySpecs);
    }

    public void testGetWordLengths() throws Exception {
        KeyFieldHelper helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        String input = "hi";
        int[] result = helper.getWordLengths(input.getBytes(), 0, 2);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{1}));
        helper.setKeyFieldSpec(1, 2);
        input = "hi\thello there";
        result = helper.getWordLengths(input.getBytes(), 0, input.length());
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{2, 2, 11}));
        helper.setKeyFieldSeparator(" ");
        input = "hi hello\tthere you";
        result = helper.getWordLengths(input.getBytes(), 0, input.length());
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{3, 2, 11, 3}));
        input = "hi hello there you where me there";
        result = helper.getWordLengths(input.getBytes(), 10, 33);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{5, 4, 3, 5, 2, 3}));
        input = "hi hello there you where me ";
        result = helper.getWordLengths(input.getBytes(), 10, input.length());
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{5, 4, 3, 5, 2, 0}));
        input = "";
        result = helper.getWordLengths(input.getBytes(), 0, 0);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{1, 0}));
        input = "  abc";
        result = helper.getWordLengths(input.getBytes(), 0, 5);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{3, 0, 0, 3}));
        input = "  abc";
        result = helper.getWordLengths(input.getBytes(), 0, 2);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{3, 0, 0, 0}));
        input = " abc ";
        result = helper.getWordLengths(input.getBytes(), 0, 2);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{2, 0, 1}));
        helper.setKeyFieldSeparator("abcd");
        input = "abc";
        result = helper.getWordLengths(input.getBytes(), 0, 3);
        TestKeyFieldHelper.assertTrue((boolean)this.equals(result, new int[]{1, 3}));
    }

    public void testgetStartEndOffset() throws Exception {
        String input;
        KeyFieldHelper helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.setKeyFieldSpec(1, 2);
        String expectedOutput = input = "hi\thello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.0,0");
        this.testKeySpecs(input, null, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1,0");
        expectedOutput = input;
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.2,0");
        expectedOutput = "i\thello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.1,2.3");
        expectedOutput = "hi\thel";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.2,2.3");
        expectedOutput = "i\thel";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.2,3.0");
        expectedOutput = "i\thello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2,2");
        expectedOutput = "hello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k3.1,4.0");
        this.testKeySpecs(input, null, helper);
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\thow";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1");
        expectedOutput = "hello\thow";
        this.testKeySpecs(input, expectedOutput, helper, 15, input.length());
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\t\thow\tare";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1,3");
        expectedOutput = "hello\t";
        this.testKeySpecs(input, expectedOutput, helper, 17, input.length());
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\thow\tare";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1");
        expectedOutput = "hello\thow\t";
        this.testKeySpecs(input, expectedOutput, helper, 17, 28);
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\thow";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1,3");
        expectedOutput = "hello";
        this.testKeySpecs(input, expectedOutput, helper, 15, 23);
    }

    private void testKeySpecs(String input, String expectedOutput, KeyFieldHelper helper) {
        this.testKeySpecs(input, expectedOutput, helper, 0, -1);
    }

    private void testKeySpecs(String input, String expectedOutput, KeyFieldHelper helper, int s1, int e1) {
        LOG.info((Object)("input : " + input));
        String keySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        LOG.info((Object)("keyspecs : " + keySpecs));
        byte[] inputBytes = input.getBytes();
        if (e1 == -1) {
            e1 = inputBytes.length;
        }
        LOG.info((Object)("length : " + e1));
        int[] indices = helper.getWordLengths(inputBytes, s1, e1);
        int start = helper.getStartOffset(inputBytes, s1, e1, indices, (KeyFieldHelper.KeyDescription)helper.keySpecs().get(0));
        LOG.info((Object)("start : " + start));
        if (expectedOutput == null) {
            TestKeyFieldHelper.assertEquals((String)"Expected -1 when the start index is invalid", (int)-1, (int)start);
            return;
        }
        int end = helper.getEndOffset(inputBytes, s1, e1, indices, (KeyFieldHelper.KeyDescription)helper.keySpecs().get(0));
        LOG.info((Object)("end : " + end));
        end = end >= inputBytes.length ? inputBytes.length - 1 : end;
        int length = end + 1 - start;
        LOG.info((Object)("length : " + length));
        byte[] outputBytes = new byte[length];
        System.arraycopy(inputBytes, start, outputBytes, 0, length);
        String output = new String(outputBytes);
        LOG.info((Object)("output : " + output));
        LOG.info((Object)("expected-output : " + expectedOutput));
        TestKeyFieldHelper.assertEquals((String)(keySpecs + " failed on input '" + input + "'"), (String)expectedOutput, (String)output);
    }

    private boolean equals(int[] test, int[] expected) {
        if (test[0] != expected[0]) {
            return false;
        }
        for (int i = 0; i < test[0] && i < expected[0]; ++i) {
            if (test[i] == expected[i]) continue;
            return false;
        }
        return true;
    }
}

