/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TestMRCJCFileOutputCommitter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRCJCFileOutputCommitter
extends TestCase {
    private static Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), "output");
    private static String attempt = "attempt_200707121733_0001_m_000000_0";
    private static TaskAttemptID taskID = TaskAttemptID.forName((String)attempt);
    private Text key1 = new Text("key1");
    private Text key2 = new Text("key2");
    private Text val1 = new Text("val1");
    private Text val2 = new Text("val2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(RecordWriter theRecordWriter, Reporter reporter) throws IOException {
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)this.key1, (Object)this.val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)this.val1);
            theRecordWriter.write((Object)nullWritable, (Object)this.val2);
            theRecordWriter.write((Object)this.key2, (Object)nullWritable);
            theRecordWriter.write((Object)this.key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)this.key2, (Object)this.val2);
        }
        finally {
            theRecordWriter.close(reporter);
        }
    }

    private void setConfForFileOutputCommitter(JobConf job) {
        job.set("mapreduce.task.attempt.id", attempt);
        job.setOutputCommitter(FileOutputCommitter.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
    }

    public void testCommitter() throws Exception {
        JobConf job = new JobConf();
        this.setConfForFileOutputCommitter(job);
        JobContextImpl jContext = new JobContextImpl(job, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)committer.getTaskAttemptPath((TaskAttemptContext)tContext));
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((FileSystem)localFs, job, file, (Progressable)reporter);
        this.writeOutput(theRecordWriter, reporter);
        committer.commitTask((TaskAttemptContext)tContext);
        committer.commitJob((org.apache.hadoop.mapred.JobContext)jContext);
        File expectedFile = new File(new Path(outDir, file).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(this.key1).append('\t').append(this.val1).append("\n");
        expectedOutput.append(this.val1).append("\n");
        expectedOutput.append(this.val2).append("\n");
        expectedOutput.append(this.key2).append("\n");
        expectedOutput.append(this.key1).append("\n");
        expectedOutput.append(this.key2).append('\t').append(this.val2).append("\n");
        String output = UtilsForTests.slurp((File)expectedFile);
        TestMRCJCFileOutputCommitter.assertEquals((String)output, (String)expectedOutput.toString());
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    public void testAbort() throws IOException {
        JobConf job = new JobConf();
        this.setConfForFileOutputCommitter(job);
        JobContextImpl jContext = new JobContextImpl(job, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)committer.getTaskAttemptPath((TaskAttemptContext)tContext));
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((FileSystem)localFs, job, file, (Progressable)reporter);
        this.writeOutput(theRecordWriter, reporter);
        committer.abortTask((TaskAttemptContext)tContext);
        File expectedFile = new File(new Path(committer.getTaskAttemptPath((TaskAttemptContext)tContext), file).toString());
        TestMRCJCFileOutputCommitter.assertFalse((String)"task temp dir still exists", (boolean)expectedFile.exists());
        committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        expectedFile = new File(new Path(outDir, "_temporary").toString());
        TestMRCJCFileOutputCommitter.assertFalse((String)("job temp dir " + expectedFile + " still exists"), (boolean)expectedFile.exists());
        TestMRCJCFileOutputCommitter.assertEquals((String)"Output directory not empty", (int)0, (int)new File(outDir.toString()).listFiles().length);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    public void testFailAbort() throws IOException {
        JobConf job = new JobConf();
        job.set("fs.defaultFS", "faildel:///");
        job.setClass("fs.faildel.impl", FakeFileSystem.class, FileSystem.class);
        this.setConfForFileOutputCommitter(job);
        JobContextImpl jContext = new JobContextImpl(job, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)committer.getTaskAttemptPath((TaskAttemptContext)tContext));
        committer.setupJob((org.apache.hadoop.mapred.JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        String file = "test.txt";
        File jobTmpDir = new File(committer.getJobAttemptPath((org.apache.hadoop.mapred.JobContext)jContext).toUri().getPath());
        File taskTmpDir = new File(committer.getTaskAttemptPath((TaskAttemptContext)tContext).toUri().getPath());
        File expectedFile = new File(taskTmpDir, file);
        Reporter reporter = Reporter.NULL;
        FakeFileSystem localFs = new FakeFileSystem();
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((FileSystem)localFs, job, expectedFile.getAbsolutePath(), (Progressable)reporter);
        this.writeOutput(theRecordWriter, reporter);
        IOException th = null;
        try {
            committer.abortTask((TaskAttemptContext)tContext);
        }
        catch (IOException ie) {
            th = ie;
        }
        TestMRCJCFileOutputCommitter.assertNotNull((Object)th);
        TestMRCJCFileOutputCommitter.assertTrue((boolean)(th instanceof IOException));
        TestMRCJCFileOutputCommitter.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        TestMRCJCFileOutputCommitter.assertTrue((String)(expectedFile + " does not exists"), (boolean)expectedFile.exists());
        th = null;
        try {
            committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        }
        catch (IOException ie) {
            th = ie;
        }
        TestMRCJCFileOutputCommitter.assertNotNull((Object)th);
        TestMRCJCFileOutputCommitter.assertTrue((boolean)(th instanceof IOException));
        TestMRCJCFileOutputCommitter.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        TestMRCJCFileOutputCommitter.assertTrue((String)"job temp dir does not exists", (boolean)jobTmpDir.exists());
    }
}

