/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class IOMapperBase<T>
extends Configured
implements Mapper<Text, LongWritable, Text, Text> {
    protected byte[] buffer;
    protected int bufferSize;
    protected FileSystem fs;
    protected String hostName;
    protected Closeable stream;

    public void configure(JobConf conf) {
        this.setConf((Configuration)conf);
        try {
            this.fs = FileSystem.get((Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create file system.", e);
        }
        this.bufferSize = conf.getInt("test.io.file.buffer.size", 4096);
        this.buffer = new byte[this.bufferSize];
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.hostName = "localhost";
        }
    }

    public void close() throws IOException {
    }

    abstract T doIO(Reporter var1, String var2, long var3) throws IOException;

    public Closeable getIOStream(String name) throws IOException {
        return null;
    }

    abstract void collectStats(OutputCollector<Text, Text> var1, String var2, long var3, T var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(Text key, LongWritable value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String name = key.toString();
        long longValue = value.get();
        reporter.setStatus("starting " + name + " ::host = " + this.hostName);
        this.stream = this.getIOStream(name);
        Object statValue = null;
        long tStart = System.currentTimeMillis();
        try {
            statValue = this.doIO(reporter, name, longValue);
        }
        finally {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        long tEnd = System.currentTimeMillis();
        long execTime = tEnd - tStart;
        this.collectStats(output, name, execTime, statValue);
        reporter.setStatus("finished " + name + " ::host = " + this.hostName);
    }
}

