/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;

public class MiniMRYarnCluster
extends MiniYARNCluster {
    public static final String APPJAR = JarFinder.getJar(LocalContainerLauncher.class);
    private static final Log LOG = LogFactory.getLog(MiniMRYarnCluster.class);
    private JobHistoryServer historyServer;
    private JobHistoryServerWrapper historyServerWrapper = new JobHistoryServerWrapper(this);

    public MiniMRYarnCluster(String testName) {
        this(testName, 1);
    }

    public MiniMRYarnCluster(String testName, int noOfNMs) {
        super(testName, noOfNMs, 4, 4);
        this.addService((Service)this.historyServerWrapper);
    }

    public static String getResolvedMRHistoryWebAppURLWithoutScheme(Configuration conf, boolean isSSLEnabled) {
        InetSocketAddress address = null;
        address = isSSLEnabled ? conf.getSocketAddr("mapreduce.jobhistory.webapp.https.address", "0.0.0.0:19890", 19890) : conf.getSocketAddr("mapreduce.jobhistory.webapp.address", "0.0.0.0:19888", 19888);
        address = NetUtils.getConnectAddress((InetSocketAddress)address);
        StringBuffer sb = new StringBuffer();
        InetAddress resolved = address.getAddress();
        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
            String lh = address.getHostName();
            try {
                lh = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            sb.append(lh);
        } else {
            sb.append(address.getHostName());
        }
        sb.append(":").append(address.getPort());
        return sb.toString();
    }

    public void serviceInit(Configuration conf) throws Exception {
        conf.set("mapreduce.framework.name", "yarn");
        if (conf.get("yarn.app.mapreduce.am.staging-dir") == null) {
            conf.set("yarn.app.mapreduce.am.staging-dir", new File(this.getTestWorkDir(), "apps_staging_dir/").getAbsolutePath());
        }
        if (!conf.getBoolean("mapreduce.minicluster.control-resource-monitoring", false)) {
            conf.setBoolean("yarn.nodemanager.pmem-check-enabled", false);
            conf.setBoolean("yarn.nodemanager.vmem-check-enabled", false);
        }
        conf.set("fs.permissions.umask-mode", "000");
        try {
            FileContext fc;
            Path stagingPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(conf.get("yarn.app.mapreduce.am.staging-dir")));
            if (Path.WINDOWS && LocalFileSystem.class.isInstance(stagingPath.getFileSystem(conf))) {
                conf.set("yarn.app.mapreduce.am.staging-dir", new File(conf.get("yarn.app.mapreduce.am.staging-dir")).getAbsolutePath());
            }
            if ((fc = FileContext.getFileContext((URI)stagingPath.toUri(), (Configuration)conf)).util().exists(stagingPath)) {
                LOG.info((Object)(stagingPath + " exists! deleting..."));
                fc.delete(stagingPath, true);
            }
            LOG.info((Object)("mkdir: " + stagingPath));
            fc.mkdir(stagingPath, null, true);
            String doneDir = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
            Path doneDirPath = fc.makeQualified(new Path(doneDir));
            fc.mkdir(doneDirPath, null, true);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Could not create staging directory. ", (Throwable)e);
        }
        conf.set("mapreduce.jobtracker.address", "test");
        conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce_shuffle"});
        conf.setClass(String.format("yarn.nodemanager.aux-services.%s.class", "mapreduce_shuffle"), ShuffleHandler.class, Service.class);
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        super.serviceInit(conf);
    }

    public JobHistoryServer getHistoryServer() {
        return this.historyServer;
    }

    static /* synthetic */ JobHistoryServer access$002(MiniMRYarnCluster x0, JobHistoryServer x1) {
        x0.historyServer = x1;
        return x0.historyServer;
    }

    static /* synthetic */ JobHistoryServer access$000(MiniMRYarnCluster x0) {
        return x0.historyServer;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

