/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRKeyValueTextInputFormat {
    private static final Log LOG = LogFactory.getLog((String)TestMRKeyValueTextInputFormat.class.getName());
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() throws Exception {
        Job job = Job.getInstance((Configuration)new Configuration(defaultConf));
        Path file = new Path(workDir, "test.txt");
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        int MAX_LENGTH = 10000;
        for (int length = 0; length < 10000; length += random.nextInt(1000) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
            try {
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(500) + 1;
                LOG.debug((Object)("splitting: requesting = " + numSplits));
                List splits = format.getSplits((JobContext)job);
                LOG.debug((Object)("splitting: got =        " + splits.size()));
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.size(); ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits.get(j)));
                    TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)job.getConfiguration());
                    RecordReader reader = format.createRecordReader((InputSplit)splits.get(j), context);
                    Class<?> clazz = reader.getClass();
                    Assert.assertEquals((String)"reader class is KeyValueLineRecordReader.", KeyValueLineRecordReader.class, clazz);
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)splits.get(j));
                    reader.initialize((InputSplit)splits.get(j), (TaskAttemptContext)mcontext);
                    Text key = null;
                    Text value = null;
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            key = (Text)reader.getCurrentKey();
                            clazz = key.getClass();
                            Assert.assertEquals((String)"Key class is Text.", Text.class, clazz);
                            value = (Text)reader.getCurrentValue();
                            clazz = value.getClass();
                            Assert.assertEquals((String)"Value class is Text.", Text.class, clazz);
                            int k = Integer.parseInt(key.toString());
                            int v = Integer.parseInt(value.toString());
                            Assert.assertEquals((String)"Bad key", (int)0, (int)(k % 2));
                            Assert.assertEquals((String)"Mismatched key/value", (int)(k / 2), (int)v);
                            LOG.debug((Object)("read " + v));
                            Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits.get(j) + " count=" + count));
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                Assert.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitableCodecs() throws Exception {
        Job job = Job.getInstance((Configuration)defaultConf);
        Configuration conf = job.getConfiguration();
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName("org.apache.hadoop.io.compress.BZip2Codec"), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        Path file = new Path(workDir, "test" + codec.getDefaultExtension());
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        int MAX_LENGTH = 500000;
        FileInputFormat.setMaxInputSplitSize((Job)job, (long)25000L);
        for (int length = 0; length < 500000; length += random.nextInt(125000) + 1) {
            LOG.info((Object)("creating; entries = " + length));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)localFs.create(file)));
            try {
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            Assert.assertTrue((String)"KVTIF claims not splittable", (boolean)format.isSplitable((JobContext)job, file));
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(250) + 1;
                LOG.info((Object)("splitting: requesting = " + numSplits));
                List splits = format.getSplits((JobContext)job);
                LOG.info((Object)("splitting: got =        " + splits.size()));
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.size(); ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits.get(j)));
                    TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)job.getConfiguration());
                    RecordReader reader = format.createRecordReader((InputSplit)splits.get(j), context);
                    Class<?> clazz = reader.getClass();
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)splits.get(j));
                    reader.initialize((InputSplit)splits.get(j), (TaskAttemptContext)mcontext);
                    Text key = null;
                    Text value = null;
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            key = (Text)reader.getCurrentKey();
                            value = (Text)reader.getCurrentValue();
                            int k = Integer.parseInt(key.toString());
                            int v = Integer.parseInt(value.toString());
                            Assert.assertEquals((String)"Bad key", (int)0, (int)(k % 2));
                            Assert.assertEquals((String)"Mismatched key/value", (int)(k / 2), (int)v);
                            LOG.debug((Object)("read " + k + "," + v));
                            Assert.assertFalse((String)(k + "," + v + " in multiple partitions."), (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        if (count > 0) {
                            LOG.info((Object)("splits[" + j + "]=" + splits.get(j) + " count=" + count));
                            continue;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits.get(j) + " count=" + count));
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                Assert.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), defaultConf);
    }

    @Test
    public void testUTF8() throws Exception {
        LineReader in = this.makeStream("abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        Assert.assertEquals((String)"readLine changed utf8 characters", (String)"abcd\u20acbdcd\u20ac", (String)line.toString());
        in = this.makeStream("abc\u200axyz");
        in.readLine(line);
        Assert.assertEquals((String)"split on fake newline", (String)"abc\u200axyz", (String)line.toString());
    }

    @Test
    public void testNewLines() throws Exception {
        LineReader in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
        Text out = new Text();
        in.readLine(out);
        Assert.assertEquals((String)"line1 length", (int)1, (int)out.getLength());
        in.readLine(out);
        Assert.assertEquals((String)"line2 length", (int)2, (int)out.getLength());
        in.readLine(out);
        Assert.assertEquals((String)"line3 length", (int)0, (int)out.getLength());
        in.readLine(out);
        Assert.assertEquals((String)"line4 length", (int)3, (int)out.getLength());
        in.readLine(out);
        Assert.assertEquals((String)"line5 length", (int)4, (int)out.getLength());
        in.readLine(out);
        Assert.assertEquals((String)"line5 length", (int)5, (int)out.getLength());
        Assert.assertEquals((String)"end of file", (int)0, (int)in.readLine(out));
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, Job job) throws IOException, InterruptedException {
        ArrayList<Text> result = new ArrayList<Text>();
        Configuration conf = job.getConfiguration();
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)conf);
        RecordReader reader = format.createRecordReader(split, MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)conf));
        MapContextImpl mcontext = new MapContextImpl(conf, context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
        reader.initialize(split, (TaskAttemptContext)mcontext);
        while (reader.nextKeyValue()) {
            result.add(new Text((Text)reader.getCurrentValue()));
        }
        reader.close();
        return result;
    }

    @Test
    public void testGzip() throws IOException, InterruptedException {
        Configuration conf = new Configuration(defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)conf);
        localFs.delete(workDir, true);
        TestMRKeyValueTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, (String)"line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestMRKeyValueTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, (String)"line-1\tthis is a test\nline-1\tof gzip\n");
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        List splits = format.getSplits((JobContext)job);
        Assert.assertEquals((String)"compressed splits == 2", (int)2, (int)splits.size());
        FileSplit tmp = (FileSplit)splits.get(0);
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits.set(0, splits.get(1));
            splits.set(1, tmp);
        }
        List results = TestMRKeyValueTextInputFormat.readSplit((KeyValueTextInputFormat)format, (InputSplit)((InputSplit)splits.get(0)), (Job)job);
        Assert.assertEquals((String)"splits[0] length", (int)6, (int)results.size());
        Assert.assertEquals((String)"splits[0][0]", (String)"the quick", (String)((Text)results.get(0)).toString());
        Assert.assertEquals((String)"splits[0][1]", (String)"brown", (String)((Text)results.get(1)).toString());
        Assert.assertEquals((String)"splits[0][2]", (String)"fox jumped", (String)((Text)results.get(2)).toString());
        Assert.assertEquals((String)"splits[0][3]", (String)"over", (String)((Text)results.get(3)).toString());
        Assert.assertEquals((String)"splits[0][4]", (String)" the lazy", (String)((Text)results.get(4)).toString());
        Assert.assertEquals((String)"splits[0][5]", (String)" dog", (String)((Text)results.get(5)).toString());
        results = TestMRKeyValueTextInputFormat.readSplit((KeyValueTextInputFormat)format, (InputSplit)((InputSplit)splits.get(1)), (Job)job);
        Assert.assertEquals((String)"splits[1] length", (int)2, (int)results.size());
        Assert.assertEquals((String)"splits[1][0]", (String)"this is a test", (String)((Text)results.get(0)).toString());
        Assert.assertEquals((String)"splits[1][1]", (String)"of gzip", (String)((Text)results.get(1)).toString());
    }

    public static void main(String[] args) throws Exception {
        new TestMRKeyValueTextInputFormat().testFormat();
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
    }
}

