/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TestNoJobSetupCleanup;
import org.junit.Ignore;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestNoJobSetupCleanup
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path inDir = new Path(TEST_ROOT_DIR, "./wc/input");
    private final Path outDir = new Path(TEST_ROOT_DIR, "./wc/output");

    public TestNoJobSetupCleanup() throws IOException {
        super(2, 4, 2, 2);
    }

    private Job submitAndValidateJob(Configuration conf, int numMaps, int numReds) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = MapReduceTestUtil.createJob((Configuration)conf, (Path)this.inDir, (Path)this.outDir, (int)numMaps, (int)numReds);
        job.setJobSetupCleanupNeeded(false);
        job.setOutputFormatClass(MyOutputFormat.class);
        job.waitForCompletion(true);
        TestNoJobSetupCleanup.assertTrue((boolean)job.isSuccessful());
        TestNoJobSetupCleanup.assertTrue((job.getTaskReports(TaskType.JOB_SETUP).length == 0 ? 1 : 0) != 0);
        TestNoJobSetupCleanup.assertTrue((job.getTaskReports(TaskType.JOB_CLEANUP).length == 0 ? 1 : 0) != 0);
        TestNoJobSetupCleanup.assertTrue((job.getTaskReports(TaskType.MAP).length == numMaps ? 1 : 0) != 0);
        TestNoJobSetupCleanup.assertTrue((job.getTaskReports(TaskType.REDUCE).length == numReds ? 1 : 0) != 0);
        FileSystem fs = FileSystem.get((Configuration)conf);
        TestNoJobSetupCleanup.assertTrue((String)"Job output directory doesn't exit!", (boolean)fs.exists(this.outDir));
        String tempWorkingPathStr = this.outDir + "/" + "_temporary" + "/" + "0";
        Path tempWorkingPath = new Path(tempWorkingPathStr);
        FileStatus[] list = fs.listStatus(tempWorkingPath, (PathFilter)new OutputFilter(null));
        int numPartFiles = numReds == 0 ? numMaps : numReds;
        TestNoJobSetupCleanup.assertTrue((String)("Number of part-files is " + list.length + " and not " + numPartFiles), (list.length == numPartFiles ? 1 : 0) != 0);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoJobSetupCleanup() throws Exception {
        try {
            JobConf conf = this.createJobConf();
            this.submitAndValidateJob((Configuration)conf, 1, 1);
            this.submitAndValidateJob((Configuration)conf, 1, 0);
            this.submitAndValidateJob((Configuration)conf, 0, 0);
            this.submitAndValidateJob((Configuration)conf, 0, 1);
        }
        finally {
            this.tearDown();
        }
    }
}

