/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.NNBench;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class NNBench {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.NNBench");
    protected static String CONTROL_DIR_NAME = "control";
    protected static String OUTPUT_DIR_NAME = "output";
    protected static String DATA_DIR_NAME = "data";
    protected static final String DEFAULT_RES_FILE_NAME = "NNBench_results.log";
    protected static final String NNBENCH_VERSION = "NameNode Benchmark 0.4";
    public static String operation = "none";
    public static long numberOfMaps = 1L;
    public static long numberOfReduces = 1L;
    public static long startTime = System.currentTimeMillis() + 120000L;
    public static long blockSize = 1L;
    public static int bytesToWrite = 0;
    public static long bytesPerChecksum = 1L;
    public static long numberOfFiles = 1L;
    public static short replicationFactorPerFile = 1;
    public static String baseDir = "/benchmarks/NNBench";
    public static boolean readFileAfterOpen = false;
    private static final String OP_CREATE_WRITE = "create_write";
    private static final String OP_OPEN_READ = "open_read";
    private static final String OP_RENAME = "rename";
    private static final String OP_DELETE = "delete";
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss','S");
    private static Configuration config = new Configuration();

    private static void cleanupBeforeTestrun() throws IOException {
        FileSystem tempFS = FileSystem.get((Configuration)config);
        if (operation.equals("create_write")) {
            LOG.info((Object)"Deleting data directory");
            tempFS.delete(new Path(baseDir, DATA_DIR_NAME), true);
        }
        tempFS.delete(new Path(baseDir, CONTROL_DIR_NAME), true);
        tempFS.delete(new Path(baseDir, OUTPUT_DIR_NAME), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createControlFiles() throws IOException {
        FileSystem tempFS = FileSystem.get((Configuration)config);
        LOG.info((Object)("Creating " + numberOfMaps + " control files"));
        int i = 0;
        while ((long)i < numberOfMaps) {
            String strFileName = "NNBench_Controlfile_" + i;
            Path filePath = new Path(new Path(baseDir, CONTROL_DIR_NAME), strFileName);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)tempFS, (Configuration)config, (Path)filePath, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(strFileName), (Writable)new LongWritable(0L));
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            ++i;
        }
    }

    private static void displayVersion() {
        System.out.println("NameNode Benchmark 0.4");
    }

    private static void displayUsage() {
        String usage = "Usage: nnbench <options>\nOptions:\n\t-operation <Available operations are create_write open_read rename delete. This option is mandatory>\n\t * NOTE: The open_read, rename and delete operations assume that the files they operate on, are already available. The create_write operation must be run before running the other operations.\n\t-maps <number of maps. default is 1. This is not mandatory>\n\t-reduces <number of reduces. default is 1. This is not mandatory>\n\t-startTime <time to start, given in seconds from the epoch. Make sure this is far enough into the future, so all maps (operations) will start at the same time>. default is launch time + 2 mins. This is not mandatory \n\t-blockSize <Block size in bytes. default is 1. This is not mandatory>\n\t-bytesToWrite <Bytes to write. default is 0. This is not mandatory>\n\t-bytesPerChecksum <Bytes per checksum for the files. default is 1. This is not mandatory>\n\t-numberOfFiles <number of files to create. default is 1. This is not mandatory>\n\t-replicationFactorPerFile <Replication factor for the files. default is 1. This is not mandatory>\n\t-baseDir <base DFS path. default is /becnhmarks/NNBench. This is not mandatory>\n\t-readFileAfterOpen <true or false. if true, it reads the file and reports the average time to read. This is valid with the open_read operation. default is false. This is not mandatory>\n\t-help: Display the help statement\n";
        System.out.println(usage);
    }

    public static void checkArgs(int index, int length) {
        if (index == length) {
            NNBench.displayUsage();
            System.exit(-1);
        }
    }

    public static void parseInputs(String[] args) {
        if (args.length == 0) {
            NNBench.displayUsage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-operation")) {
                operation = args[++i];
                continue;
            }
            if (args[i].equals("-maps")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                numberOfMaps = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-reduces")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                numberOfReduces = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-startTime")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                startTime = Long.parseLong(args[++i]) * 1000L;
                continue;
            }
            if (args[i].equals("-blockSize")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                blockSize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesToWrite")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                bytesToWrite = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesPerChecksum")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                bytesPerChecksum = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-numberOfFiles")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                numberOfFiles = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-replicationFactorPerFile")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                replicationFactorPerFile = Short.parseShort(args[++i]);
                continue;
            }
            if (args[i].equals("-baseDir")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                baseDir = args[++i];
                continue;
            }
            if (args[i].equals("-readFileAfterOpen")) {
                NNBench.checkArgs((int)(i + 1), (int)args.length);
                readFileAfterOpen = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (!args[i].equals("-help")) continue;
            NNBench.displayUsage();
            System.exit(-1);
        }
        LOG.info((Object)"Test Inputs: ");
        LOG.info((Object)("           Test Operation: " + operation));
        LOG.info((Object)("               Start time: " + sdf.format(new Date(startTime))));
        LOG.info((Object)("           Number of maps: " + numberOfMaps));
        LOG.info((Object)("        Number of reduces: " + numberOfReduces));
        LOG.info((Object)("               Block Size: " + blockSize));
        LOG.info((Object)("           Bytes to write: " + bytesToWrite));
        LOG.info((Object)("       Bytes per checksum: " + bytesPerChecksum));
        LOG.info((Object)("          Number of files: " + numberOfFiles));
        LOG.info((Object)("       Replication factor: " + replicationFactorPerFile));
        LOG.info((Object)("                 Base dir: " + baseDir));
        LOG.info((Object)("     Read file after open: " + readFileAfterOpen));
        config.set("test.nnbench.operation", operation);
        config.setLong("test.nnbench.maps", numberOfMaps);
        config.setLong("test.nnbench.reduces", numberOfReduces);
        config.setLong("test.nnbench.starttime", startTime);
        config.setLong("test.nnbench.blocksize", blockSize);
        config.setInt("test.nnbench.bytestowrite", bytesToWrite);
        config.setLong("test.nnbench.bytesperchecksum", bytesPerChecksum);
        config.setLong("test.nnbench.numberoffiles", numberOfFiles);
        config.setInt("test.nnbench.replicationfactor", (int)replicationFactorPerFile);
        config.set("test.nnbench.basedir", baseDir);
        config.setBoolean("test.nnbench.readFileAfterOpen", readFileAfterOpen);
        config.set("test.nnbench.datadir.name", DATA_DIR_NAME);
        config.set("test.nnbench.outputdir.name", OUTPUT_DIR_NAME);
        config.set("test.nnbench.controldir.name", CONTROL_DIR_NAME);
    }

    private static void analyzeResults() throws IOException {
        double AverageExecutionTime;
        String line;
        FileSystem fs = FileSystem.get((Configuration)config);
        Path reduceFile = new Path(new Path(baseDir, OUTPUT_DIR_NAME), "part-00000");
        DataInputStream in = new DataInputStream((InputStream)fs.open(reduceFile));
        BufferedReader lines = new BufferedReader(new InputStreamReader(in));
        long totalTimeAL1 = 0L;
        long totalTimeAL2 = 0L;
        long totalTimeTPmS = 0L;
        long lateMaps = 0L;
        long numOfExceptions = 0L;
        long successfulFileOps = 0L;
        long mapStartTimeTPmS = 0L;
        long mapEndTimeTPmS = 0L;
        String resultTPSLine1 = null;
        String resultTPSLine2 = null;
        String resultALLine1 = null;
        String resultALLine2 = null;
        while ((line = lines.readLine()) != null) {
            StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%;");
            String attr = tokens.nextToken();
            if (attr.endsWith(":totalTimeAL1")) {
                totalTimeAL1 = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":totalTimeAL2")) {
                totalTimeAL2 = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":totalTimeTPmS")) {
                totalTimeTPmS = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":latemaps")) {
                lateMaps = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":numOfExceptions")) {
                numOfExceptions = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":successfulFileOps")) {
                successfulFileOps = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":mapStartTimeTPmS")) {
                mapStartTimeTPmS = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (!attr.endsWith(":mapEndTimeTPmS")) continue;
            mapEndTimeTPmS = Long.parseLong(tokens.nextToken());
        }
        double avgLatency1 = (double)totalTimeAL1 / (double)successfulFileOps;
        double avgLatency2 = (double)totalTimeAL2 / (double)successfulFileOps;
        double longestMapTimeTPmS = mapEndTimeTPmS - mapStartTimeTPmS;
        double totalTimeTPS = longestMapTimeTPmS == 0.0 ? (double)(1000L * successfulFileOps) : (double)(1000L * successfulFileOps) / longestMapTimeTPmS;
        double d = AverageExecutionTime = totalTimeTPmS == 0L ? (double)successfulFileOps : (double)totalTimeTPmS / (double)successfulFileOps;
        if (operation.equals("create_write")) {
            resultTPSLine1 = "               TPS: Create/Write/Close: " + (int)(totalTimeTPS * 2.0);
            resultTPSLine2 = "Avg exec time (ms): Create/Write/Close: " + AverageExecutionTime;
            resultALLine1 = "            Avg Lat (ms): Create/Write: " + avgLatency1;
            resultALLine2 = "                   Avg Lat (ms): Close: " + avgLatency2;
        } else if (operation.equals("open_read")) {
            resultTPSLine1 = "                        TPS: Open/Read: " + (int)totalTimeTPS;
            resultTPSLine2 = "         Avg Exec time (ms): Open/Read: " + AverageExecutionTime;
            resultALLine1 = "                    Avg Lat (ms): Open: " + avgLatency1;
            if (readFileAfterOpen) {
                resultALLine2 = "                  Avg Lat (ms): Read: " + avgLatency2;
            }
        } else if (operation.equals("rename")) {
            resultTPSLine1 = "                           TPS: Rename: " + (int)totalTimeTPS;
            resultTPSLine2 = "            Avg Exec time (ms): Rename: " + AverageExecutionTime;
            resultALLine1 = "                  Avg Lat (ms): Rename: " + avgLatency1;
        } else if (operation.equals("delete")) {
            resultTPSLine1 = "                           TPS: Delete: " + (int)totalTimeTPS;
            resultTPSLine2 = "            Avg Exec time (ms): Delete: " + AverageExecutionTime;
            resultALLine1 = "                  Avg Lat (ms): Delete: " + avgLatency1;
        }
        String[] resultLines = new String[]{"-------------- NNBench -------------- : ", "                               Version: NameNode Benchmark 0.4", "                           Date & time: " + sdf.format(new Date(System.currentTimeMillis())), "", "                        Test Operation: " + operation, "                            Start time: " + sdf.format(new Date(startTime)), "                           Maps to run: " + numberOfMaps, "                        Reduces to run: " + numberOfReduces, "                    Block Size (bytes): " + blockSize, "                        Bytes to write: " + bytesToWrite, "                    Bytes per checksum: " + bytesPerChecksum, "                       Number of files: " + numberOfFiles, "                    Replication factor: " + replicationFactorPerFile, "            Successful file operations: " + successfulFileOps, "", "        # maps that missed the barrier: " + lateMaps, "                          # exceptions: " + numOfExceptions, "", resultTPSLine1, resultTPSLine2, resultALLine1, resultALLine2, "", "                 RAW DATA: AL Total #1: " + totalTimeAL1, "                 RAW DATA: AL Total #2: " + totalTimeAL2, "              RAW DATA: TPS Total (ms): " + totalTimeTPmS, "       RAW DATA: Longest Map Time (ms): " + longestMapTimeTPmS, "                   RAW DATA: Late maps: " + lateMaps, "             RAW DATA: # of exceptions: " + numOfExceptions, ""};
        PrintStream res = new PrintStream(new FileOutputStream(new File("NNBench_results.log"), true));
        for (int i = 0; i < resultLines.length; ++i) {
            LOG.info((Object)resultLines[i]);
            res.println(resultLines[i]);
        }
    }

    public static void runTests() throws IOException {
        config.setLong("io.bytes.per.checksum", bytesPerChecksum);
        JobConf job = new JobConf(config, NNBench.class);
        job.setJobName("NNBench-" + operation);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(baseDir, CONTROL_DIR_NAME)});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMaxMapAttempts(1);
        job.setSpeculativeExecution(false);
        job.setMapperClass(NNBenchMapper.class);
        job.setReducerClass(NNBenchReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(baseDir, OUTPUT_DIR_NAME));
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks((int)numberOfReduces);
        JobClient.runJob((JobConf)job);
    }

    public static void validateInputs() {
        if (!(operation.equals("create_write") || operation.equals("open_read") || operation.equals("rename") || operation.equals("delete"))) {
            System.err.println("Error: Unknown operation: " + operation);
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (numberOfMaps < 0L) {
            System.err.println("Error: Number of maps must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (numberOfReduces <= 0L) {
            System.err.println("Error: Number of reduces must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (blockSize <= 0L) {
            System.err.println("Error: Block size must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (bytesToWrite < 0) {
            System.err.println("Error: Bytes to write must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (bytesPerChecksum < 0L) {
            System.err.println("Error: Bytes per checksum must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (numberOfFiles < 0L) {
            System.err.println("Error: Number of files must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (replicationFactorPerFile < 0) {
            System.err.println("Error: Replication factor must be a positive number");
            NNBench.displayUsage();
            System.exit(-1);
        }
        if (blockSize % bytesPerChecksum != 0L) {
            System.err.println("Error: Block Size in bytes must be a multiple of bytes per checksum: ");
            NNBench.displayUsage();
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws IOException {
        NNBench.displayVersion();
        NNBench.parseInputs((String[])args);
        NNBench.validateInputs();
        NNBench.cleanupBeforeTestrun();
        NNBench.createControlFiles();
        NNBench.runTests();
        NNBench.analyzeResults();
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

