/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestTaskContext
extends HadoopTestCase {
    private static final Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
    private static final Path testRootTempDir = new Path(rootTempDir, "TestTaskContext");
    private static FileSystem fs = null;
    static String myStatus = "my status";
    private static final String INPUT = "Hi\nHi\nHi\nHi\n";
    private static final int INPUT_LINES = "Hi\nHi\nHi\nHi\n".split("\n").length;

    @BeforeClass
    public static void setup() throws Exception {
        fs = FileSystem.getLocal((Configuration)new Configuration());
        fs.delete(testRootTempDir, true);
        fs.mkdirs(testRootTempDir);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        fs.delete(testRootTempDir, true);
    }

    public TestTaskContext() throws IOException {
        super(2, 4, 1, 1);
    }

    @Test
    @Ignore
    public void testContextStatus() throws IOException, InterruptedException, ClassNotFoundException {
        Path test = new Path(testRootTempDir, "testContextStatus");
        int numMaps = 1;
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numMaps, 0);
        job.setMapperClass(MyMapper.class);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        TaskReport[] reports = job.getTaskReports(TaskType.MAP);
        TestTaskContext.assertEquals((int)numMaps, (int)reports.length);
        TestTaskContext.assertEquals((String)myStatus, (String)reports[0].getState());
        int numReduces = 1;
        job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numMaps, numReduces);
        job.setMapperClass(MapReduceTestUtil.DataCopyMapper.class);
        job.setReducerClass(MapReduceTestUtil.DataCopyReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(0);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    public void testMapContextProgress() throws IOException, InterruptedException, ClassNotFoundException {
        int numMaps = 1;
        Path test = new Path(testRootTempDir, "testMapContextProgress");
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numMaps, 0, INPUT);
        job.setMapperClass(ProgressCheckerMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMaxMapAttempts(1);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    @Test
    public void testReduceContextProgress() throws IOException, InterruptedException, ClassNotFoundException {
        int numTasks = 1;
        Path test = new Path(testRootTempDir, "testReduceContextProgress");
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numTasks, numTasks, INPUT);
        job.setMapperClass(ProgressCheckerMapper.class);
        job.setReducerClass(ProgressCheckerReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(1);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    static class ProgressCheckerReducer
    extends Reducer<Text, Text, Text, Text> {
        private int recordCount = 0;
        private final float REDUCE_PROGRESS_RANGE = 0.33333334f;
        private final float SHUFFLE_PROGRESS_RANGE = 0.6666666f;

        ProgressCheckerReducer() {
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            float reducePhaseProgress = (float)(++this.recordCount) / (float)INPUT_LINES;
            float weightedReducePhaseProgress = 0.33333334f * reducePhaseProgress;
            Assert.assertEquals((String)"Invalid progress in reduce setup", (float)(0.6666666f + weightedReducePhaseProgress), (float)context.getProgress(), (float)0.01f);
        }

        public void reduce(Text key, Iterator<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            float reducePhaseProgress = (float)(++this.recordCount) / (float)INPUT_LINES;
            float weightedReducePhaseProgress = 0.33333334f * reducePhaseProgress;
            Assert.assertEquals((String)"Invalid progress in reduce", (float)(0.6666666f + weightedReducePhaseProgress), (float)context.getProgress(), (float)0.01f);
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Assert.assertEquals((String)"Invalid progress in reduce cleanup", (float)1.0f, (float)context.getProgress(), (float)0.0f);
        }
    }

    static class ProgressCheckerMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        private int recordCount = 0;
        private float progressRange = 0.0f;

        ProgressCheckerMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException {
            Assert.assertEquals((String)"Invalid progress in map setup", (float)0.0f, (float)context.getProgress(), (float)0.0f);
            this.progressRange = context.getNumReduceTasks() == 0 ? 1.0f : 0.667f;
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            float mapPhaseProgress = (float)(++this.recordCount) / (float)INPUT_LINES;
            float weightedMapProgress = this.progressRange * mapPhaseProgress;
            Assert.assertEquals((String)"Invalid progress in map", (float)weightedMapProgress, (float)context.getProgress(), (float)0.0f);
            context.write((Object)new Text(value.toString() + this.recordCount), (Object)value);
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            Assert.assertEquals((String)"Invalid progress in map cleanup", (float)this.progressRange, (float)context.getProgress(), (float)0.0f);
        }
    }

    static class MyMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        MyMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException {
            context.setStatus(myStatus);
            Assert.assertEquals((String)myStatus, (String)context.getStatus());
        }
    }
}

