/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.LocalDistributedCacheManager;
import org.apache.hadoop.mapred.LocalJobRunnerMetrics;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalJobRunner
implements ClientProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static final String LOCAL_MAX_MAPS = "mapreduce.local.map.tasks.maximum";
    public static final String LOCAL_MAX_REDUCES = "mapreduce.local.reduce.tasks.maximum";
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private AtomicInteger map_tasks = new AtomicInteger(0);
    private AtomicInteger reduce_tasks = new AtomicInteger(0);
    final Random rand = new Random();
    private LocalJobRunnerMetrics myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;
    private int randid;
    static final String TASK_CLEANUP_SUFFIX = ".cleanup";
    static final String JOBCACHE = "jobcache";

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 37L;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    public LocalJobRunner(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal((Configuration)conf);
        this.conf = conf;
        this.myMetrics = new LocalJobRunnerMetrics(new JobConf((Configuration)conf));
    }

    public synchronized org.apache.hadoop.mapreduce.JobID getNewJobID() {
        return new org.apache.hadoop.mapreduce.JobID("local" + this.randid, ++jobid);
    }

    public JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)jobid), jobSubmitDir);
        job.job.setCredentials(credentials);
        return job.status;
    }

    public void killJob(org.apache.hadoop.mapreduce.JobID id) {
        this.jobs.get((Object)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).killed = true;
        this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).interrupt();
    }

    public void setJobPriority(org.apache.hadoop.mapreduce.JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    public TaskReport[] getTaskReports(org.apache.hadoop.mapreduce.JobID id, TaskType type) {
        return new TaskReport[0];
    }

    public JobStatus getJobStatus(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
        if (job != null) {
            return job.status;
        }
        return null;
    }

    public Counters getJobCounters(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
        return new Counters((AbstractCounters)job.getCurrentCounters());
    }

    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    public ClusterMetrics getClusterMetrics() {
        int numMapTasks = this.map_tasks.get();
        int numReduceTasks = this.reduce_tasks.get();
        return new ClusterMetrics(numMapTasks, numReduceTasks, numMapTasks, numReduceTasks, 0, 0, 1, 1, this.jobs.size(), 1, 0, 0);
    }

    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    public org.apache.hadoop.mapreduce.TaskCompletionEvent[] getTaskCompletionEvents(org.apache.hadoop.mapreduce.JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return org.apache.hadoop.mapreduce.TaskCompletionEvent.EMPTY_ARRAY;
    }

    public JobStatus[] getAllJobs() {
        return null;
    }

    public List<NodeToLabelsList> getClusterNodeLabels() throws IOException, InterruptedException {
        return null;
    }

    public boolean refreshClusterNodeLabels() throws IOException, InterruptedException {
        return false;
    }

    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.randid = this.rand.nextInt(Integer.MAX_VALUE);
        String user = ugi != null ? ugi.getShortUserName() + this.randid : "dummy" + this.randid;
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    public String getJobHistoryDir() {
        return null;
    }

    public QueueInfo[] getChildQueues(String queueName) throws IOException {
        return null;
    }

    public QueueInfo[] getRootQueues() throws IOException {
        return null;
    }

    public QueueInfo[] getQueues() throws IOException {
        return null;
    }

    public QueueInfo getQueue(String queue) throws IOException {
        return null;
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    public static void setLocalMaxRunningMaps(JobContext job, int maxMaps) {
        job.getConfiguration().setInt(LOCAL_MAX_MAPS, maxMaps);
    }

    public static int getLocalMaxRunningMaps(JobContext job) {
        return job.getConfiguration().getInt(LOCAL_MAX_MAPS, 1);
    }

    public static void setLocalMaxRunningReduces(JobContext job, int maxReduces) {
        job.getConfiguration().setInt(LOCAL_MAX_REDUCES, maxReduces);
    }

    public static int getLocalMaxRunningReduces(JobContext job) {
        return job.getConfiguration().getInt(LOCAL_MAX_REDUCES, 1);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    public LogParams getLogFileParams(org.apache.hadoop.mapreduce.JobID jobID, TaskAttemptID taskAttemptID) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Not supported");
    }

    static void setupChildMapredLocalDirs(Task t, JobConf conf) {
        String[] localDirs = conf.getTrimmedStrings("mapreduce.cluster.local.dir");
        String jobId = t.getJobID().toString();
        String taskId = t.getTaskID().toString();
        boolean isCleanup = t.isTaskCleanupTask();
        String user = t.getUser();
        StringBuffer childMapredLocalDir = new StringBuffer(localDirs[0] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        for (int i = 1; i < localDirs.length; ++i) {
            childMapredLocalDir.append("," + localDirs[i] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        }
        LOG.debug((Object)("mapreduce.cluster.local.dir for child : " + childMapredLocalDir));
        conf.set("mapreduce.cluster.local.dir", childMapredLocalDir.toString());
    }

    static String getLocalTaskDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = "localRunner//" + user + "/" + JOBCACHE + "/" + jobid + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + TASK_CLEANUP_SUFFIX;
        }
        return taskDir;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path systemJobDir;
        private Path systemJobFile;
        private Path localJobDir;
        private Path localJobFile;
        private JobID id;
        private JobConf job;
        private int numMapTasks;
        private int numReduceTasks;
        private float[] partialMapProgress;
        private float[] partialReduceProgress;
        private org.apache.hadoop.mapred.Counters[] mapCounters;
        private org.apache.hadoop.mapred.Counters[] reduceCounters;
        private org.apache.hadoop.mapred.JobStatus status;
        private List<org.apache.hadoop.mapred.TaskAttemptID> mapIds = Collections.synchronizedList(new ArrayList());
        private JobProfile profile;
        private FileSystem localFs;
        boolean killed = false;
        private LocalDistributedCacheManager localDistributedCacheManager;

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job(JobID jobid, String jobSubmitDir) throws IOException {
            this.systemJobDir = new Path(jobSubmitDir);
            this.systemJobFile = new Path(this.systemJobDir, "job.xml");
            this.id = jobid;
            JobConf conf = new JobConf(this.systemJobFile);
            this.localFs = FileSystem.getLocal((Configuration)conf);
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            this.localJobDir = this.localFs.makeQualified(new Path(new Path(conf.getLocalPath(LocalJobRunner.jobDir), user), jobid.toString()));
            this.localJobFile = new Path(this.localJobDir, this.id + ".xml");
            this.localDistributedCacheManager = new LocalDistributedCacheManager();
            this.localDistributedCacheManager.setup(conf);
            FSDataOutputStream out = this.localFs.create(this.localJobFile);
            try {
                conf.writeXml((OutputStream)out);
            }
            finally {
                out.close();
            }
            this.job = new JobConf(this.localJobFile);
            if (this.localDistributedCacheManager.hasLocalClasspaths()) {
                this.setContextClassLoader(this.localDistributedCacheManager.makeClassLoader(this.getContextClassLoader()));
            }
            this.profile = new JobProfile(this.job.getUser(), (org.apache.hadoop.mapreduce.JobID)this.id, this.systemJobFile.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new org.apache.hadoop.mapred.JobStatus(this.id, 0.0f, 0.0f, org.apache.hadoop.mapred.JobStatus.RUNNING, this.profile.getUser(), this.profile.getJobName(), this.profile.getJobFile(), this.profile.getURL().toString());
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        protected List<RunnableWithThrowable> getMapTaskRunnables(JobSplit.TaskSplitMetaInfo[] taskInfo, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
            int numTasks = 0;
            ArrayList<RunnableWithThrowable> list = new ArrayList<RunnableWithThrowable>();
            for (JobSplit.TaskSplitMetaInfo task : taskInfo) {
                list.add(new MapTaskRunnable(task, numTasks++, jobId, mapOutputFiles));
            }
            return list;
        }

        protected List<RunnableWithThrowable> getReduceTaskRunnables(JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
            int taskId = 0;
            ArrayList<RunnableWithThrowable> list = new ArrayList<RunnableWithThrowable>();
            for (int i = 0; i < this.numReduceTasks; ++i) {
                list.add(new ReduceTaskRunnable(taskId++, jobId, mapOutputFiles));
            }
            return list;
        }

        private synchronized void initCounters(int numMaps, int numReduces) {
            int i;
            this.partialMapProgress = new float[numMaps];
            this.mapCounters = new org.apache.hadoop.mapred.Counters[numMaps];
            for (i = 0; i < numMaps; ++i) {
                this.mapCounters[i] = new org.apache.hadoop.mapred.Counters();
            }
            this.partialReduceProgress = new float[numReduces];
            this.reduceCounters = new org.apache.hadoop.mapred.Counters[numReduces];
            for (i = 0; i < numReduces; ++i) {
                this.reduceCounters[i] = new org.apache.hadoop.mapred.Counters();
            }
            this.numMapTasks = numMaps;
            this.numReduceTasks = numReduces;
        }

        protected synchronized ExecutorService createMapExecutor() {
            int maxMapThreads = this.job.getInt(LocalJobRunner.LOCAL_MAX_MAPS, 1);
            if (maxMapThreads < 1) {
                throw new IllegalArgumentException("Configured mapreduce.local.map.tasks.maximum must be >= 1");
            }
            maxMapThreads = Math.min(maxMapThreads, this.numMapTasks);
            maxMapThreads = Math.max(maxMapThreads, 1);
            LOG.debug((Object)"Starting mapper thread pool executor.");
            LOG.debug((Object)("Max local threads: " + maxMapThreads));
            LOG.debug((Object)("Map tasks to process: " + this.numMapTasks));
            ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("LocalJobRunner Map Task Executor #%d").build();
            ExecutorService executor = Executors.newFixedThreadPool(maxMapThreads, tf);
            return executor;
        }

        protected synchronized ExecutorService createReduceExecutor() {
            int maxReduceThreads = this.job.getInt(LocalJobRunner.LOCAL_MAX_REDUCES, 1);
            if (maxReduceThreads < 1) {
                throw new IllegalArgumentException("Configured mapreduce.local.reduce.tasks.maximum must be >= 1");
            }
            maxReduceThreads = Math.min(maxReduceThreads, this.numReduceTasks);
            maxReduceThreads = Math.max(maxReduceThreads, 1);
            LOG.debug((Object)"Starting reduce thread pool executor.");
            LOG.debug((Object)("Max local threads: " + maxReduceThreads));
            LOG.debug((Object)("Reduce tasks to process: " + this.numReduceTasks));
            ExecutorService executor = Executors.newFixedThreadPool(maxReduceThreads);
            return executor;
        }

        private void runTasks(List<RunnableWithThrowable> runnables, ExecutorService service, String taskType) throws Exception {
            for (Runnable runnable : runnables) {
                service.submit(runnable);
            }
            try {
                service.shutdown();
                LOG.info((Object)("Waiting for " + taskType + " tasks"));
                service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException ie) {
                service.shutdownNow();
                throw ie;
            }
            LOG.info((Object)(taskType + " task executor complete."));
            for (RunnableWithThrowable runnableWithThrowable : runnables) {
                if (runnableWithThrowable.storedException == null) continue;
                throw new Exception(runnableWithThrowable.storedException);
            }
        }

        private OutputCommitter createOutputCommitter(boolean newApiCommitter, JobID jobId, Configuration conf) throws Exception {
            OutputCommitter committer = null;
            LOG.info((Object)("OutputCommitter set in config " + conf.get("mapred.output.committer.class")));
            if (newApiCommitter) {
                org.apache.hadoop.mapreduce.TaskID taskId = new org.apache.hadoop.mapreduce.TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
                TaskAttemptID taskAttemptID = new TaskAttemptID(taskId, 0);
                TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(conf, taskAttemptID);
                OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)conf);
                committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
            } else {
                committer = (OutputCommitter)ReflectionUtils.newInstance((Class)conf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), (Configuration)conf);
            }
            LOG.info((Object)("OutputCommitter is " + committer.getClass().getName()));
            return committer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContextImpl jContext = new JobContextImpl(this.job, (org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = null;
            try {
                outputCommitter = this.createOutputCommitter(LocalJobRunner.this.conf.getUseNewMapper(), jobId, (Configuration)LocalJobRunner.this.conf);
            }
            catch (Exception e) {
                LOG.info((Object)"Failed to createOutputCommitter", (Throwable)e);
                return;
            }
            try {
                JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfos = SplitMetaInfoReader.readSplitMetaInfo((org.apache.hadoop.mapreduce.JobID)jobId, (FileSystem)this.localFs, (Configuration)LocalJobRunner.this.conf, (Path)this.systemJobDir);
                int numReduceTasks = this.job.getNumReduceTasks();
                outputCommitter.setupJob((JobContext)jContext);
                this.status.setSetupProgress(1.0f);
                Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles = Collections.synchronizedMap(new HashMap());
                List<RunnableWithThrowable> mapRunnables = this.getMapTaskRunnables(taskSplitMetaInfos, jobId, mapOutputFiles);
                this.initCounters(mapRunnables.size(), numReduceTasks);
                ExecutorService mapService = this.createMapExecutor();
                this.runTasks(mapRunnables, mapService, "map");
                try {
                    if (numReduceTasks > 0) {
                        List<RunnableWithThrowable> reduceRunnables = this.getReduceTaskRunnables(jobId, mapOutputFiles);
                        ExecutorService reduceService = this.createReduceExecutor();
                        this.runTasks(reduceRunnables, reduceService, "reduce");
                    }
                }
                finally {
                    for (MapOutputFile output : mapOutputFiles.values()) {
                        output.removeAll();
                    }
                }
                outputCommitter.commitJob((JobContext)jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.SUCCEEDED);
                }
                JobEndNotifier.localRunnerNotification((JobConf)this.job, (org.apache.hadoop.mapred.JobStatus)this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.abortJob((JobContext)jContext, JobStatus.State.FAILED);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Error cleaning up job:" + this.id));
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.FAILED);
                }
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification((JobConf)this.job, (org.apache.hadoop.mapred.JobStatus)this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.systemJobFile.getParent(), true);
                    this.localFs.delete(this.localJobFile, true);
                    this.localDistributedCacheManager.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        public JvmTask getTask(JvmContext context) {
            return null;
        }

        public synchronized boolean statusUpdate(org.apache.hadoop.mapred.TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            taskStatus.write((DataOutput)dos);
            dos.close();
            taskStatus = TaskStatus.createTaskStatus((boolean)taskStatus.getIsMap());
            taskStatus.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
            LOG.info((Object)taskStatus.getStateString());
            int mapTaskIndex = this.mapIds.indexOf(taskId);
            if (mapTaskIndex >= 0) {
                float numTasks = this.numMapTasks;
                this.partialMapProgress[mapTaskIndex] = taskStatus.getProgress();
                this.mapCounters[mapTaskIndex] = taskStatus.getCounters();
                float partialProgress = 0.0f;
                for (float f : this.partialMapProgress) {
                    partialProgress += f;
                }
                this.status.setMapProgress(partialProgress / numTasks);
            } else {
                int reduceTaskIndex = taskId.getTaskID().getId();
                float numTasks = this.numReduceTasks;
                this.partialReduceProgress[reduceTaskIndex] = taskStatus.getProgress();
                this.reduceCounters[reduceTaskIndex] = taskStatus.getCounters();
                float partialProgress = 0.0f;
                for (float f : this.partialReduceProgress) {
                    partialProgress += f;
                }
                this.status.setReduceProgress(partialProgress / numTasks);
            }
            return true;
        }

        public synchronized org.apache.hadoop.mapred.Counters getCurrentCounters() {
            if (null == this.mapCounters) {
                return new org.apache.hadoop.mapred.Counters();
            }
            org.apache.hadoop.mapred.Counters current = new org.apache.hadoop.mapred.Counters();
            for (org.apache.hadoop.mapred.Counters c : this.mapCounters) {
                current = org.apache.hadoop.mapred.Counters.sum((org.apache.hadoop.mapred.Counters)current, (org.apache.hadoop.mapred.Counters)c);
            }
            if (null != this.reduceCounters && this.reduceCounters.length > 0) {
                for (org.apache.hadoop.mapred.Counters c : this.reduceCounters) {
                    current = org.apache.hadoop.mapred.Counters.sum((org.apache.hadoop.mapred.Counters)current, (org.apache.hadoop.mapred.Counters)c);
                }
            }
            return current;
        }

        public void commitPending(org.apache.hadoop.mapred.TaskAttemptID taskid, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus);
        }

        public void reportDiagnosticInfo(org.apache.hadoop.mapred.TaskAttemptID taskid, String trace) {
        }

        public void reportNextRecordRange(org.apache.hadoop.mapred.TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }

        public boolean ping(org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
            return true;
        }

        public boolean canCommit(org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
            return true;
        }

        public void done(org.apache.hadoop.mapred.TaskAttemptID taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        public synchronized void fsError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        public void shuffleError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        public synchronized void fatalError(org.apache.hadoop.mapred.TaskAttemptID taskId, String msg) throws IOException {
            LOG.fatal((Object)("Fatal: " + msg + "from task: " + taskId));
        }

        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, org.apache.hadoop.mapred.TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        protected class ReduceTaskRunnable
        extends RunnableWithThrowable {
            private final int taskId;
            private final JobID jobId;
            private final JobConf localConf;
            private final Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles;

            public ReduceTaskRunnable(int taskId, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
                this.taskId = taskId;
                this.jobId = jobId;
                this.mapOutputFiles = mapOutputFiles;
                this.localConf = new JobConf((Configuration)Job.this.job);
                this.localConf.set("mapreduce.jobtracker.address", "local");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    org.apache.hadoop.mapred.TaskAttemptID reduceId = new org.apache.hadoop.mapred.TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jobId, TaskType.REDUCE, this.taskId), 0);
                    LOG.info((Object)("Starting task: " + reduceId));
                    ReduceTask reduce = new ReduceTask(Job.this.systemJobFile.toString(), reduceId, this.taskId, Job.this.mapIds.size(), 1);
                    reduce.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                    LocalJobRunner.setupChildMapredLocalDirs((Task)reduce, this.localConf);
                    reduce.setLocalMapFiles(this.mapOutputFiles);
                    if (!Job.this.isInterrupted()) {
                        reduce.setJobFile(Job.this.localJobFile.toString());
                        this.localConf.setUser(reduce.getUser());
                        reduce.localizeConfiguration(this.localConf);
                        reduce.setConf((Configuration)this.localConf);
                        try {
                            LocalJobRunner.this.reduce_tasks.getAndIncrement();
                            LocalJobRunner.this.myMetrics.launchReduce(reduce.getTaskID());
                            reduce.run(this.localConf, (TaskUmbilicalProtocol)Job.this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduce.getTaskID());
                        }
                        finally {
                            LocalJobRunner.this.reduce_tasks.getAndDecrement();
                        }
                    } else {
                        throw new InterruptedException();
                    }
                    LOG.info((Object)("Finishing task: " + reduceId));
                }
                catch (Throwable t) {
                    this.storedException = t;
                }
            }
        }

        protected class MapTaskRunnable
        extends RunnableWithThrowable {
            private final int taskId;
            private final JobSplit.TaskSplitMetaInfo info;
            private final JobID jobId;
            private final JobConf localConf;
            private final Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles;

            public MapTaskRunnable(JobSplit.TaskSplitMetaInfo info, int taskId, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
                this.info = info;
                this.taskId = taskId;
                this.mapOutputFiles = mapOutputFiles;
                this.jobId = jobId;
                this.localConf = new JobConf((Configuration)Job.this.job);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    org.apache.hadoop.mapred.TaskAttemptID mapId = new org.apache.hadoop.mapred.TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jobId, TaskType.MAP, this.taskId), 0);
                    LOG.info((Object)("Starting task: " + mapId));
                    Job.this.mapIds.add(mapId);
                    MapTask map = new MapTask(Job.this.systemJobFile.toString(), mapId, this.taskId, this.info.getSplitIndex(), 1);
                    map.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                    LocalJobRunner.setupChildMapredLocalDirs((Task)map, this.localConf);
                    MROutputFiles mapOutput = new MROutputFiles();
                    mapOutput.setConf((Configuration)this.localConf);
                    this.mapOutputFiles.put(mapId, (MapOutputFile)mapOutput);
                    map.setJobFile(Job.this.localJobFile.toString());
                    this.localConf.setUser(map.getUser());
                    map.localizeConfiguration(this.localConf);
                    map.setConf((Configuration)this.localConf);
                    try {
                        LocalJobRunner.this.map_tasks.getAndIncrement();
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map.run(this.localConf, (TaskUmbilicalProtocol)Job.this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                    }
                    finally {
                        LocalJobRunner.this.map_tasks.getAndDecrement();
                    }
                    LOG.info((Object)("Finishing task: " + mapId));
                }
                catch (Throwable e) {
                    this.storedException = e;
                }
            }
        }

        protected abstract class RunnableWithThrowable
        implements Runnable {
            public volatile Throwable storedException;

            protected RunnableWithThrowable() {
            }
        }
    }
}

