/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.util.BestEffortLongFile;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBestEffortLongFile {
    private static final File FILE = new File(MiniDFSCluster.getBaseDirectory() + File.separatorChar + "TestBestEffortLongFile");

    @Before
    public void cleanup() {
        if (FILE.exists()) {
            Assert.assertTrue((boolean)FILE.delete());
        }
        FILE.getParentFile().mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSet() throws IOException {
        BestEffortLongFile f = new BestEffortLongFile(FILE, 12345L);
        try {
            Assert.assertEquals((long)12345L, (long)f.get());
            Assert.assertTrue((boolean)FILE.exists());
            Random r = new Random();
            for (int i = 0; i < 100; ++i) {
                long newVal = r.nextLong();
                f.set(newVal);
                Assert.assertEquals((long)newVal, (long)f.get());
                BestEffortLongFile f2 = new BestEffortLongFile(FILE, 999L);
                try {
                    Assert.assertEquals((long)newVal, (long)f2.get());
                    continue;
                }
                finally {
                    IOUtils.closeStream((Closeable)f2);
                }
            }
        }
        finally {
            IOUtils.closeStream((Closeable)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncatedFileReturnsDefault() throws IOException {
        Assert.assertTrue((boolean)FILE.createNewFile());
        Assert.assertEquals((long)0L, (long)FILE.length());
        BestEffortLongFile f = new BestEffortLongFile(FILE, 12345L);
        try {
            Assert.assertEquals((long)12345L, (long)f.get());
        }
        finally {
            f.close();
        }
    }
}

