/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStartupProgress {
    private StartupProgress startupProgress;

    @Before
    public void setUp() {
        this.startupProgress = new StartupProgress();
    }

    @Test(timeout=10000L)
    public void testCounter() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 200L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 5000L);
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((long)100L, (long)view.getCount(Phase.LOADING_FSIMAGE, loadingFsImageInodes));
        Assert.assertEquals((long)200L, (long)view.getCount(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys));
        Assert.assertEquals((long)5000L, (long)view.getCount(Phase.LOADING_EDITS, loadingEditsFile));
        Assert.assertEquals((long)0L, (long)view.getCount(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)));
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 1000L);
        this.startupProgress.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        Assert.assertEquals((long)5000L, (long)view.getCount(Phase.LOADING_EDITS, loadingEditsFile));
        view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((long)6000L, (long)view.getCount(Phase.LOADING_EDITS, loadingEditsFile));
    }

    @Test(timeout=10000L)
    public void testElapsedTime() throws Exception {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Thread.sleep(50L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        Thread.sleep(50L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 10000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 5000L);
        Thread.sleep(50L);
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertTrue((view.getElapsedTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.LOADING_FSIMAGE) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.LOADING_EDITS) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.LOADING_EDITS, loadingEditsFile) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.SAVING_CHECKPOINT) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((view.getElapsedTime(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)) == 0L ? 1 : 0) != 0);
        long totalTime = view.getElapsedTime();
        long loadingFsImageTime = view.getElapsedTime(Phase.LOADING_FSIMAGE);
        long loadingFsImageInodesTime = view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        long loadingFsImageDelegationKeysTime = view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        long loadingEditsTime = view.getElapsedTime(Phase.LOADING_EDITS);
        long loadingEditsFileTime = view.getElapsedTime(Phase.LOADING_EDITS, loadingEditsFile);
        Thread.sleep(50L);
        Assert.assertTrue((totalTime < view.getElapsedTime() ? 1 : 0) != 0);
        Assert.assertEquals((long)loadingFsImageTime, (long)view.getElapsedTime(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)loadingFsImageInodesTime, (long)view.getElapsedTime(Phase.LOADING_FSIMAGE, loadingFsImageInodes));
        Assert.assertTrue((loadingEditsTime < view.getElapsedTime(Phase.LOADING_EDITS) ? 1 : 0) != 0);
        Assert.assertTrue((loadingEditsFileTime < view.getElapsedTime(Phase.LOADING_EDITS, loadingEditsFile) ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testFrozenAfterStartupCompletes() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.setFile(Phase.LOADING_FSIMAGE, "file1");
        this.startupProgress.setSize(Phase.LOADING_FSIMAGE, 1000L);
        Step step = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, step, 10000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, step, 100L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        for (Phase phase : EnumSet.allOf(Phase.class)) {
            if (this.startupProgress.getStatus(phase) == Status.COMPLETE) continue;
            this.startupProgress.beginPhase(phase);
            this.startupProgress.endPhase(phase);
        }
        StartupProgressView before = this.startupProgress.createView();
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.setFile(Phase.LOADING_FSIMAGE, "file2");
        this.startupProgress.setSize(Phase.LOADING_FSIMAGE, 2000L);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, step, 20000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, step, 100L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, step);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step newStep = new Step("file1");
        this.startupProgress.beginStep(Phase.LOADING_EDITS, newStep);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, newStep, 100L);
        this.startupProgress.endStep(Phase.LOADING_EDITS, newStep);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        StartupProgressView after = this.startupProgress.createView();
        Assert.assertEquals((long)before.getCount(Phase.LOADING_FSIMAGE), (long)after.getCount(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)before.getCount(Phase.LOADING_FSIMAGE, step), (long)after.getCount(Phase.LOADING_FSIMAGE, step));
        Assert.assertEquals((long)before.getElapsedTime(), (long)after.getElapsedTime());
        Assert.assertEquals((long)before.getElapsedTime(Phase.LOADING_FSIMAGE), (long)after.getElapsedTime(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)before.getElapsedTime(Phase.LOADING_FSIMAGE, step), (long)after.getElapsedTime(Phase.LOADING_FSIMAGE, step));
        Assert.assertEquals((Object)before.getFile(Phase.LOADING_FSIMAGE), (Object)after.getFile(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)before.getSize(Phase.LOADING_FSIMAGE), (long)after.getSize(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)before.getTotal(Phase.LOADING_FSIMAGE), (long)after.getTotal(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)before.getTotal(Phase.LOADING_FSIMAGE, step), (long)after.getTotal(Phase.LOADING_FSIMAGE, step));
        Assert.assertFalse((boolean)after.getSteps(Phase.LOADING_EDITS).iterator().hasNext());
    }

    @Test(timeout=10000L)
    public void testInitialState() {
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((long)0L, (long)view.getElapsedTime());
        Assert.assertEquals((double)0.0, (double)view.getPercentComplete(), (double)0.001f);
        ArrayList<Phase> phases = new ArrayList<Phase>();
        for (Phase phase : view.getPhases()) {
            phases.add(phase);
            Assert.assertEquals((long)0L, (long)view.getElapsedTime(phase));
            Assert.assertNull((Object)view.getFile(phase));
            Assert.assertEquals((double)0.0, (double)view.getPercentComplete(phase), (double)0.001f);
            Assert.assertEquals((long)Long.MIN_VALUE, (long)view.getSize(phase));
            Assert.assertEquals((Object)Status.PENDING, (Object)view.getStatus(phase));
            Assert.assertEquals((long)0L, (long)view.getTotal(phase));
            for (Step step : view.getSteps(phase)) {
                Assert.fail((String)String.format("unexpected step %s in phase %s at initial state", step, phase));
            }
        }
        Assert.assertArrayEquals((Object[])EnumSet.allOf(Phase.class).toArray(), (Object[])phases.toArray());
    }

    @Test(timeout=10000L)
    public void testPercentComplete() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes, 1000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageInodes, 100L);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 800L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 200L);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 10000L);
        StartupProgressTestHelper.incrementCounter(this.startupProgress, Phase.LOADING_EDITS, loadingEditsFile, 5000L);
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((double)0.167f, (double)view.getPercentComplete(), (double)0.001f);
        Assert.assertEquals((double)0.167f, (double)view.getPercentComplete(Phase.LOADING_FSIMAGE), (double)0.001f);
        Assert.assertEquals((double)0.1f, (double)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageInodes), (double)0.001f);
        Assert.assertEquals((double)0.25, (double)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys), (double)0.001f);
        Assert.assertEquals((double)0.5, (double)view.getPercentComplete(Phase.LOADING_EDITS), (double)0.001f);
        Assert.assertEquals((double)0.5, (double)view.getPercentComplete(Phase.LOADING_EDITS, loadingEditsFile), (double)0.001f);
        Assert.assertEquals((double)0.0, (double)view.getPercentComplete(Phase.SAVING_CHECKPOINT), (double)0.001f);
        Assert.assertEquals((double)0.0, (double)view.getPercentComplete(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)), (double)0.001f);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((double)0.5, (double)view.getPercentComplete(), (double)0.001f);
        Assert.assertEquals((double)1.0, (double)view.getPercentComplete(Phase.LOADING_FSIMAGE), (double)0.001f);
        Assert.assertEquals((double)1.0, (double)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageInodes), (double)0.001f);
        Assert.assertEquals((double)1.0, (double)view.getPercentComplete(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys), (double)0.001f);
        Assert.assertEquals((double)1.0, (double)view.getPercentComplete(Phase.LOADING_EDITS), (double)0.001f);
        Assert.assertEquals((double)1.0, (double)view.getPercentComplete(Phase.LOADING_EDITS, loadingEditsFile), (double)0.001f);
        Assert.assertEquals((double)0.0, (double)view.getPercentComplete(Phase.SAVING_CHECKPOINT), (double)0.001f);
        Assert.assertEquals((double)0.0, (double)view.getPercentComplete(Phase.SAVING_CHECKPOINT, new Step(StepType.INODES)), (double)0.001f);
    }

    @Test(timeout=10000L)
    public void testStatus() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((Object)Status.COMPLETE, (Object)view.getStatus(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((Object)Status.RUNNING, (Object)view.getStatus(Phase.LOADING_EDITS));
        Assert.assertEquals((Object)Status.PENDING, (Object)view.getStatus(Phase.SAVING_CHECKPOINT));
    }

    @Test(timeout=10000L)
    public void testStepSequence() {
        Object[] expectedSteps = new Step[]{new Step(StepType.INODES, "file1"), new Step(StepType.DELEGATION_KEYS, "file1"), new Step(StepType.INODES, "file2"), new Step(StepType.DELEGATION_KEYS, "file2"), new Step(StepType.INODES, "file3"), new Step(StepType.DELEGATION_KEYS, "file3")};
        ArrayList<Step> shuffledSteps = new ArrayList<Step>(Arrays.asList(expectedSteps));
        Collections.shuffle(shuffledSteps);
        this.startupProgress.beginPhase(Phase.SAVING_CHECKPOINT);
        for (Step step : shuffledSteps) {
            this.startupProgress.beginStep(Phase.SAVING_CHECKPOINT, step);
        }
        ArrayList<Step> actualSteps = new ArrayList<Step>(expectedSteps.length);
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        for (Step step : view.getSteps(Phase.SAVING_CHECKPOINT)) {
            actualSteps.add(step);
        }
        Assert.assertArrayEquals((Object[])expectedSteps, (Object[])actualSteps.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testThreadSafety() throws Exception {
        int numThreads = 100;
        Phase[] phases = new Phase[]{Phase.LOADING_FSIMAGE, Phase.LOADING_FSIMAGE, Phase.LOADING_EDITS, Phase.LOADING_EDITS};
        Step[] steps = new Step[]{new Step(StepType.INODES), new Step(StepType.DELEGATION_KEYS), new Step(StepType.INODES), new Step(StepType.DELEGATION_KEYS)};
        String[] files = new String[]{"file1", "file1", "file2", "file2"};
        long[] sizes = new long[]{1000L, 1000L, 2000L, 2000L};
        long[] totals = new long[]{10000L, 20000L, 30000L, 40000L};
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        try {
            for (int i = 0; i < numThreads; ++i) {
                final Phase phase = phases[i % phases.length];
                final Step step = steps[i % steps.length];
                final String file = files[i % files.length];
                final long size = sizes[i % sizes.length];
                final long total = totals[i % totals.length];
                exec.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        TestStartupProgress.this.startupProgress.beginPhase(phase);
                        TestStartupProgress.this.startupProgress.setFile(phase, file);
                        TestStartupProgress.this.startupProgress.setSize(phase, size);
                        TestStartupProgress.this.startupProgress.setTotal(phase, step, total);
                        StartupProgressTestHelper.incrementCounter(TestStartupProgress.this.startupProgress, phase, step, 100L);
                        TestStartupProgress.this.startupProgress.endStep(phase, step);
                        TestStartupProgress.this.startupProgress.endPhase(phase);
                        return null;
                    }
                });
            }
        }
        finally {
            exec.shutdown();
            Assert.assertTrue((boolean)exec.awaitTermination(10000L, TimeUnit.MILLISECONDS));
        }
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((Object)"file1", (Object)view.getFile(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)1000L, (long)view.getSize(Phase.LOADING_FSIMAGE));
        Assert.assertEquals((long)10000L, (long)view.getTotal(Phase.LOADING_FSIMAGE, new Step(StepType.INODES)));
        Assert.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_FSIMAGE, new Step(StepType.INODES)));
        Assert.assertEquals((long)20000L, (long)view.getTotal(Phase.LOADING_FSIMAGE, new Step(StepType.DELEGATION_KEYS)));
        Assert.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_FSIMAGE, new Step(StepType.DELEGATION_KEYS)));
        Assert.assertEquals((Object)"file2", (Object)view.getFile(Phase.LOADING_EDITS));
        Assert.assertEquals((long)2000L, (long)view.getSize(Phase.LOADING_EDITS));
        Assert.assertEquals((long)30000L, (long)view.getTotal(Phase.LOADING_EDITS, new Step(StepType.INODES)));
        Assert.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_EDITS, new Step(StepType.INODES)));
        Assert.assertEquals((long)40000L, (long)view.getTotal(Phase.LOADING_EDITS, new Step(StepType.DELEGATION_KEYS)));
        Assert.assertEquals((long)2500L, (long)view.getCount(Phase.LOADING_EDITS, new Step(StepType.DELEGATION_KEYS)));
    }

    @Test(timeout=10000L)
    public void testTotal() {
        this.startupProgress.beginPhase(Phase.LOADING_FSIMAGE);
        Step loadingFsImageInodes = new Step(StepType.INODES);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes, 1000L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageInodes);
        Step loadingFsImageDelegationKeys = new Step(StepType.DELEGATION_KEYS);
        this.startupProgress.beginStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.setTotal(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys, 800L);
        this.startupProgress.endStep(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys);
        this.startupProgress.endPhase(Phase.LOADING_FSIMAGE);
        this.startupProgress.beginPhase(Phase.LOADING_EDITS);
        Step loadingEditsFile = new Step("file", 1000L);
        this.startupProgress.beginStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.setTotal(Phase.LOADING_EDITS, loadingEditsFile, 10000L);
        this.startupProgress.endStep(Phase.LOADING_EDITS, loadingEditsFile);
        this.startupProgress.endPhase(Phase.LOADING_EDITS);
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((long)1000L, (long)view.getTotal(Phase.LOADING_FSIMAGE, loadingFsImageInodes));
        Assert.assertEquals((long)800L, (long)view.getTotal(Phase.LOADING_FSIMAGE, loadingFsImageDelegationKeys));
        Assert.assertEquals((long)10000L, (long)view.getTotal(Phase.LOADING_EDITS, loadingEditsFile));
    }
}

