/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaseManager {
    final Configuration conf = new HdfsConfiguration();

    @Test
    public void testRemoveLeaseWithPrefixPath() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        cluster.waitActive();
        LeaseManager lm = NameNodeAdapter.getLeaseManager(cluster.getNamesystem());
        lm.addLease("holder1", "/a/b");
        lm.addLease("holder2", "/a/c");
        Assert.assertNotNull((Object)lm.getLeaseByPath("/a/b"));
        Assert.assertNotNull((Object)lm.getLeaseByPath("/a/c"));
        lm.removeLeaseWithPrefixPath("/a");
        Assert.assertNull((Object)lm.getLeaseByPath("/a/b"));
        Assert.assertNull((Object)lm.getLeaseByPath("/a/c"));
        lm.addLease("holder1", "/a/b");
        lm.addLease("holder2", "/a/c");
        lm.removeLeaseWithPrefixPath("/a/");
        Assert.assertNull((Object)lm.getLeaseByPath("/a/b"));
        Assert.assertNull((Object)lm.getLeaseByPath("/a/c"));
    }
}

