/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Test;

public class TestValidateConfigurationSettings {
    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=BindException.class)
    public void testThatMatchingRPCandHttpPortsThrowException() throws IOException {
        NameNode nameNode = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
            conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
            Random rand = new Random();
            int port = 30000 + rand.nextInt(30000);
            FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://localhost:" + port));
            conf.set("dfs.namenode.http-address", "127.0.0.1:" + port);
            DFSTestUtil.formatNameNode((Configuration)conf);
            nameNode = new NameNode((Configuration)conf);
        }
        finally {
            if (nameNode != null) {
                nameNode.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatDifferentRPCandHttpPortsAreOK() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            int port1 = 30000 + rand.nextInt(10000);
            int port2 = port1 + 1 + rand.nextInt(10000);
            FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://localhost:" + port1));
            conf.set("dfs.namenode.http-address", "127.0.0.1:" + port2);
            DFSTestUtil.formatNameNode((Configuration)conf);
            NameNode nameNode = null;
            try {
                nameNode = new NameNode((Configuration)conf);
                break;
            }
            catch (BindException be) {
                continue;
            }
            finally {
                if (nameNode != null) {
                    nameNode.stop();
                }
            }
        }
    }

    @Test
    public void testGenericKeysForNameNodeFormat() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.rpc-address", "127.0.0.1:0");
        conf.set("dfs.namenode.http-address", "127.0.0.1:0");
        conf.set("dfs.nameservices", "ns1");
        File dir = new File(MiniDFSCluster.getBaseDirectory(), "testGenericKeysForNameNodeFormat");
        if (dir.exists()) {
            FileUtil.fullyDelete((File)dir);
        }
        conf.set("dfs.namenode.name.dir.ns1", dir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        GenericTestUtils.assertExists((File)dir);
        NameNode nameNode = new NameNode((Configuration)conf);
        nameNode.stop();
    }
}

