/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.OutOfV1GenerationStampsException;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.AclConfigFlag;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystemLock;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeId;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.SequentialBlockIdGenerator;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyCheckpointer;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.util.ChunkedArrayList;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Logger;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
@Metrics(context="dfs")
public class FSNamesystem
implements Namesystem,
FSClusterStats,
FSNamesystemMBean,
NameNodeMXBean {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<StringBuilder> auditBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private final boolean isPermissionEnabled;
    private final UserGroupInformation fsOwner;
    private final String fsOwnerShortUserName;
    private final String supergroup;
    private final boolean standbyShouldCheckpoint;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    final DelegationTokenSecretManager dtSecretManager;
    private final boolean alwaysUseDelegationTokensForTests;
    private static final Step STEP_AWAITING_REPORTED_BLOCKS = new Step(StepType.AWAITING_REPORTED_BLOCKS);
    private final boolean isDefaultAuditLogger;
    private final List<AuditLogger> auditLoggers;
    FSDirectory dir;
    private final BlockManager blockManager;
    private final SnapshotManager snapshotManager;
    private final CacheManager cacheManager;
    private final DatanodeStatistics datanodeStatistics;
    private RollingUpgradeInfo rollingUpgradeInfo = null;
    private volatile boolean needRollbackFsImage;
    private String blockPoolId;
    final LeaseManager leaseManager = new LeaseManager(this);
    volatile Daemon smmthread = null;
    Daemon nnrmthread = null;
    Daemon nnEditLogRoller = null;
    private final long editLogRollerThreshold;
    private final int editLogRollerInterval;
    private volatile boolean hasResourcesAvailable = false;
    private volatile boolean fsRunning = true;
    private final long startTime = Time.now();
    private final long resourceRecheckInterval;
    NameNodeResourceChecker nnResourceChecker;
    private final FsServerDefaults serverDefaults;
    private final boolean supportAppends;
    private final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    private volatile SafeModeInfo safeMode;
    private final long maxFsObjects;
    private final long minBlockSize;
    private final long maxBlocksPerFile;
    private final GenerationStamp generationStampV1 = new GenerationStamp();
    private final GenerationStamp generationStampV2 = new GenerationStamp();
    private long generationStampV1Limit = 0L;
    @VisibleForTesting
    private final SequentialBlockIdGenerator blockIdGenerator;
    private final long accessTimePrecision;
    private final FSNamesystemLock fsLock;
    private EditLogTailer editLogTailer = null;
    private StandbyCheckpointer standbyCheckpointer;
    private HAContext haContext;
    private final boolean haEnabled;
    boolean initializedReplQueues = false;
    private volatile boolean startingActiveService = false;
    private INodeId inodeId;
    private final RetryCache retryCache;
    private final AclConfigFlag aclConfigFlag;
    private ObjectName mbeanName;
    private ObjectName mxbeanName;

    @VisibleForTesting
    public boolean isAuditEnabled() {
        return !this.isDefaultAuditLogger || auditLog.isInfoEnabled();
    }

    private HdfsFileStatus getAuditFileInfo(String path, boolean resolveSymlink) throws IOException {
        return this.isAuditEnabled() && this.isExternalInvocation() ? this.dir.getFileInfo(path, resolveSymlink) : null;
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src) throws IOException {
        this.logAuditEvent(succeeded, cmd, src, null, null);
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        if (this.isAuditEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(succeeded, FSNamesystem.getRemoteUser(), FSNamesystem.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private void logAuditEvent(boolean succeeded, UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) {
        FileStatus status = null;
        if (stat != null) {
            Path symlink = stat.isSymlink() ? new Path(stat.getSymlink()) : null;
            Path path = dst != null ? new Path(dst) : new Path(src);
            status = new FileStatus(stat.getLen(), stat.isDir(), (int)stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), symlink, path);
        }
        for (AuditLogger logger : this.auditLoggers) {
            if (logger instanceof HdfsAuditLogger) {
                HdfsAuditLogger hdfsLogger = (HdfsAuditLogger)logger;
                hdfsLogger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status, ugi, this.dtSecretManager);
                continue;
            }
            logger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status);
        }
    }

    public void resetLastInodeId(long newValue) throws IOException {
        try {
            this.inodeId.skipTo(newValue);
        }
        catch (IllegalStateException ise) {
            throw new IOException(ise);
        }
    }

    void resetLastInodeIdWithoutChecking(long newValue) {
        this.inodeId.setCurrentValue(newValue);
    }

    public long getLastInodeId() {
        return this.inodeId.getCurrentValue();
    }

    public long allocateNewInodeId() {
        return this.inodeId.nextValue();
    }

    void clear() {
        this.dir.reset();
        this.dtSecretManager.reset();
        this.generationStampV1.setCurrentValue(1000L);
        this.generationStampV2.setCurrentValue(1000L);
        this.blockIdGenerator.setCurrentValue(0x40000000L);
        this.generationStampV1Limit = 0L;
        this.leaseManager.removeAllLeases();
        this.inodeId.setCurrentValue(16384L);
        this.snapshotManager.clearSnapshottableDirs();
        this.cacheManager.clear();
    }

    @VisibleForTesting
    LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    boolean isHaEnabled() {
        return this.haEnabled;
    }

    private static void checkConfiguration(Configuration conf) throws IOException {
        Collection<URI> namespaceDirs = FSNamesystem.getNamespaceDirs(conf);
        List<URI> editsDirs = FSNamesystem.getNamespaceEditsDirs(conf);
        Collection<URI> requiredEditsDirs = FSNamesystem.getRequiredNamespaceEditsDirs(conf);
        List<URI> sharedEditsDirs = FSNamesystem.getSharedEditsDirs(conf);
        for (URI u : requiredEditsDirs) {
            if (u.toString().compareTo("file:///tmp/hadoop/dfs/name") == 0 || editsDirs.contains(u) || sharedEditsDirs.contains(u)) continue;
            throw new IllegalArgumentException("Required edits directory " + u.toString() + " not present in " + "dfs.namenode.edits.dir" + ". " + "dfs.namenode.edits.dir" + "=" + editsDirs.toString() + "; " + "dfs.namenode.edits.dir.required" + "=" + requiredEditsDirs.toString() + ". " + "dfs.namenode.shared.edits.dir" + "=" + sharedEditsDirs.toString() + ".");
        }
        if (namespaceDirs.size() == 1) {
            LOG.warn((Object)"Only one image storage directory (dfs.namenode.name.dir) configured. Beware of dataloss due to lack of redundant storage directories!");
        }
        if (editsDirs.size() == 1) {
            LOG.warn((Object)"Only one namespace edits storage directory (dfs.namenode.edits.dir) configured. Beware of dataloss due to lack of redundant storage directories!");
        }
    }

    static FSNamesystem loadFromDisk(Configuration conf) throws IOException {
        FSNamesystem.checkConfiguration(conf);
        FSImage fsImage = new FSImage(conf, FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf));
        FSNamesystem namesystem = new FSNamesystem(conf, fsImage, false);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
            namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        long loadStart = Time.now();
        try {
            namesystem.loadFSImage(startOpt);
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Encountered exception loading fsimage", (Throwable)ioe);
            fsImage.close();
            throw ioe;
        }
        long timeTakenToLoadFSImage = Time.now() - loadStart;
        LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs"));
        NameNodeMetrics nnMetrics = NameNode.getNameNodeMetrics();
        if (nnMetrics != null) {
            nnMetrics.setFsImageLoadTime((int)timeTakenToLoadFSImage);
        }
        return namesystem;
    }

    FSNamesystem(Configuration conf, FSImage fsImage) throws IOException {
        this(conf, fsImage, false);
    }

    FSNamesystem(Configuration conf, FSImage fsImage, boolean ignoreRetryCache) throws IOException {
        if (conf.getBoolean("dfs.namenode.audit.log.async", false)) {
            LOG.info((Object)"Enabling async auditlog");
            FSNamesystem.enableAsyncAuditLog();
        }
        boolean fair = conf.getBoolean("dfs.namenode.fslock.fair", true);
        LOG.info((Object)("fsLock is fair:" + fair));
        this.fsLock = new FSNamesystemLock(fair);
        try {
            DataChecksum.Type checksumType;
            this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
            this.blockManager = new BlockManager(this, this, conf);
            this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
            this.blockIdGenerator = new SequentialBlockIdGenerator(this.blockManager);
            this.fsOwner = UserGroupInformation.getCurrentUser();
            this.fsOwnerShortUserName = this.fsOwner.getShortUserName();
            this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
            this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
            LOG.info((Object)("fsOwner             = " + this.fsOwner));
            LOG.info((Object)("supergroup          = " + this.supergroup));
            LOG.info((Object)("isPermissionEnabled = " + this.isPermissionEnabled));
            String nameserviceId = DFSUtil.getNamenodeNameServiceId(conf);
            this.haEnabled = HAUtil.isHAEnabled(conf, nameserviceId);
            if (nameserviceId != null) {
                LOG.info((Object)("Determined nameservice ID: " + nameserviceId));
            }
            LOG.info((Object)("HA Enabled: " + this.haEnabled));
            if (!this.haEnabled && HAUtil.usesSharedEditsDir(conf)) {
                LOG.warn((Object)("Configured NNs:\n" + DFSUtil.nnAddressesAsString(conf)));
                throw new IOException("Invalid configuration: a shared edits dir must not be specified if HA is not enabled.");
            }
            String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
            try {
                checksumType = DataChecksum.Type.valueOf((String)checksumTypeStr);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
            }
            this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x8000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), conf.getBoolean("dfs.encrypt.data.transfer", false), conf.getLong("fs.trash.interval", 0L), checksumType);
            this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
            this.minBlockSize = conf.getLong("dfs.namenode.fs-limits.min-block-size", 0x100000L);
            this.maxBlocksPerFile = conf.getLong("dfs.namenode.fs-limits.max-blocks-per-file", 0x100000L);
            this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 3600000L);
            this.supportAppends = conf.getBoolean("dfs.support.append", true);
            LOG.info((Object)("Append Enabled: " + this.supportAppends));
            this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
            this.standbyShouldCheckpoint = conf.getBoolean("dfs.ha.standby.checkpoints", true);
            this.editLogRollerThreshold = (long)(conf.getFloat("dfs.namenode.edit.log.autoroll.multiplier.threshold", 2.0f) * (float)conf.getLong("dfs.namenode.checkpoint.txns", 1000000L));
            this.editLogRollerInterval = conf.getInt("dfs.namenode.edit.log.autoroll.check.interval.ms", 300000);
            this.inodeId = new INodeId();
            this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
            this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
            this.dir = new FSDirectory(fsImage, this, conf);
            this.snapshotManager = new SnapshotManager(this.dir);
            this.cacheManager = new CacheManager(this, conf, this.blockManager);
            this.safeMode = new SafeModeInfo(conf);
            this.auditLoggers = this.initAuditLoggers(conf);
            this.isDefaultAuditLogger = this.auditLoggers.size() == 1 && this.auditLoggers.get(0) instanceof DefaultAuditLogger;
            this.retryCache = ignoreRetryCache ? null : FSNamesystem.initRetryCache(conf);
            this.aclConfigFlag = new AclConfigFlag(conf);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
        catch (RuntimeException re) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)re);
            this.close();
            throw re;
        }
    }

    @VisibleForTesting
    public RetryCache getRetryCache() {
        return this.retryCache;
    }

    void lockRetryCache() {
        if (this.retryCache != null) {
            this.retryCache.lock();
        }
    }

    void unlockRetryCache() {
        if (this.retryCache != null) {
            this.retryCache.unlock();
        }
    }

    boolean hasRetryCache() {
        return this.retryCache != null;
    }

    void addCacheEntryWithPayload(byte[] clientId, int callId, Object payload) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntryWithPayload(clientId, callId, payload);
        }
    }

    void addCacheEntry(byte[] clientId, int callId) {
        if (this.retryCache != null) {
            this.retryCache.addCacheEntry(clientId, callId);
        }
    }

    @VisibleForTesting
    static RetryCache initRetryCache(Configuration conf) {
        boolean enable = conf.getBoolean("dfs.namenode.enable.retrycache", true);
        LOG.info((Object)("Retry cache on namenode is " + (enable ? "enabled" : "disabled")));
        if (enable) {
            float heapPercent = conf.getFloat("dfs.namenode.retrycache.heap.percent", 0.03f);
            long entryExpiryMillis = conf.getLong("dfs.namenode.retrycache.expirytime.millis", 600000L);
            LOG.info((Object)("Retry cache will use " + heapPercent + " of total heap and retry cache entry expiry time is " + entryExpiryMillis + " millis"));
            long entryExpiryNanos = entryExpiryMillis * 1000L * 1000L;
            return new RetryCache("NameNodeRetryCache", (double)heapPercent, entryExpiryNanos);
        }
        return null;
    }

    private List<AuditLogger> initAuditLoggers(Configuration conf) {
        Collection alClasses = conf.getStringCollection("dfs.namenode.audit.loggers");
        ArrayList auditLoggers = Lists.newArrayList();
        if (alClasses != null && !alClasses.isEmpty()) {
            for (String className : alClasses) {
                try {
                    AuditLogger logger = "default".equals(className) ? new DefaultAuditLogger() : (AuditLogger)Class.forName(className).newInstance();
                    logger.initialize(conf);
                    auditLoggers.add(logger);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (auditLoggers.isEmpty()) {
            auditLoggers.add(new DefaultAuditLogger());
        }
        return Collections.unmodifiableList(auditLoggers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFSImage(HdfsServerConstants.StartupOption startOpt) throws IOException {
        FSImage fsImage = this.getFSImage();
        if (startOpt == HdfsServerConstants.StartupOption.FORMAT) {
            fsImage.format(this, fsImage.getStorage().determineClusterId());
            startOpt = HdfsServerConstants.StartupOption.REGULAR;
        }
        boolean success = false;
        this.writeLock();
        try {
            MetaRecoveryContext recovery = startOpt.createRecoveryContext();
            boolean staleImage = fsImage.recoverTransitionRead(startOpt, this, recovery);
            if (HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(startOpt)) {
                this.rollingUpgradeInfo = null;
            }
            boolean needToSave = staleImage && !this.haEnabled && !this.isRollingUpgrade();
            LOG.info((Object)("Need to save fs image? " + needToSave + " (staleImage=" + staleImage + ", haEnabled=" + this.haEnabled + ", isRollingUpgrade=" + this.isRollingUpgrade() + ")"));
            if (needToSave) {
                fsImage.saveNamespace(this);
            } else {
                StartupProgress prog = NameNode.getStartupProgress();
                prog.beginPhase(Phase.SAVING_CHECKPOINT);
                prog.endPhase(Phase.SAVING_CHECKPOINT);
            }
            if (!this.haEnabled || this.haEnabled && startOpt == HdfsServerConstants.StartupOption.UPGRADE) {
                fsImage.openEditLogForWrite();
            }
            success = true;
        }
        finally {
            if (!success) {
                fsImage.close();
            }
            this.writeUnlock();
        }
        this.dir.imageLoadComplete();
    }

    private void startSecretManager() {
        if (this.dtSecretManager != null) {
            try {
                this.dtSecretManager.startThreads();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean shouldRun = this.shouldUseDelegationTokens() && !this.isInSafeMode() && this.getEditLog().isOpenForWrite();
        boolean running = this.dtSecretManager.isRunning();
        if (shouldRun && !running) {
            this.startSecretManager();
        }
    }

    private void stopSecretManager() {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCommonServices(Configuration conf, HAContext haContext) throws IOException {
        this.registerMBean();
        this.writeLock();
        this.haContext = haContext;
        try {
            this.nnResourceChecker = new NameNodeResourceChecker(conf);
            this.checkAvailableResources();
            assert (this.safeMode != null && !this.isPopulatingReplQueues());
            StartupProgress prog = NameNode.getStartupProgress();
            prog.beginPhase(Phase.SAFEMODE);
            prog.setTotal(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS, this.getCompleteBlocksTotal());
            this.setBlockTotal();
            this.blockManager.activate(conf);
        }
        finally {
            this.writeUnlock();
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopCommonServices() {
        this.writeLock();
        try {
            if (this.blockManager != null) {
                this.blockManager.close();
            }
        }
        finally {
            this.writeUnlock();
        }
        RetryCache.clear((RetryCache)this.retryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startActiveServices() throws IOException {
        this.startingActiveService = true;
        LOG.info((Object)"Starting services required for active state");
        this.writeLock();
        try {
            FSEditLog editLog = this.dir.fsImage.getEditLog();
            if (!editLog.isOpenForWrite()) {
                editLog.initJournalsForWrite();
                editLog.recoverUnclosedStreams();
                LOG.info((Object)"Catching up to latest edits from old active before taking over writer role in edits logs");
                this.editLogTailer.catchupDuringFailover();
                this.blockManager.setPostponeBlocksFromFuture(false);
                this.blockManager.getDatanodeManager().markAllDatanodesStale();
                this.blockManager.clearQueues();
                this.blockManager.processAllPendingDNMessages();
                if (!this.isInSafeMode()) {
                    LOG.info((Object)"Reprocessing replication and invalidation queues");
                    this.initializeReplQueues();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NameNode metadata after re-processing replication and invalidation queues during failover:\n" + this.metaSaveAsString()));
                }
                long nextTxId = this.dir.fsImage.getLastAppliedTxId() + 1L;
                LOG.info((Object)("Will take over writing edit logs at txnid " + nextTxId));
                editLog.setNextTxId(nextTxId);
                this.dir.fsImage.editLog.openForWrite();
            }
            if (this.haEnabled) {
                this.leaseManager.renewAllLeases();
            }
            this.leaseManager.startMonitor();
            this.startSecretManagerIfNecessary();
            this.nnrmthread = new Daemon((Runnable)new NameNodeResourceMonitor());
            this.nnrmthread.start();
            this.nnEditLogRoller = new Daemon((Runnable)new NameNodeEditLogRoller(this.editLogRollerThreshold, this.editLogRollerInterval));
            this.nnEditLogRoller.start();
            this.cacheManager.startMonitorThread();
            this.blockManager.getDatanodeManager().setShouldSendCachingCommands(true);
        }
        finally {
            this.writeUnlock();
            this.startingActiveService = false;
        }
    }

    private void initializeReplQueues() {
        LOG.info((Object)"initializing replication queues");
        this.blockManager.processMisReplicatedBlocks();
        this.initializedReplQueues = true;
    }

    private boolean inActiveState() {
        return this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE;
    }

    public boolean inTransitionToActive() {
        return this.haEnabled && this.inActiveState() && this.startingActiveService;
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopActiveServices() {
        LOG.info((Object)"Stopping services started for active state");
        this.writeLock();
        try {
            this.stopSecretManager();
            if (this.leaseManager != null) {
                this.leaseManager.stopMonitor();
            }
            if (this.nnrmthread != null) {
                ((NameNodeResourceMonitor)this.nnrmthread.getRunnable()).stopMonitor();
                this.nnrmthread.interrupt();
            }
            if (this.nnEditLogRoller != null) {
                ((NameNodeEditLogRoller)this.nnEditLogRoller.getRunnable()).stop();
                this.nnEditLogRoller.interrupt();
            }
            if (this.dir != null && this.dir.fsImage != null) {
                if (this.dir.fsImage.editLog != null) {
                    this.dir.fsImage.editLog.close();
                }
                this.dir.fsImage.updateLastAppliedTxIdFromWritten();
            }
            this.cacheManager.stopMonitorThread();
            this.cacheManager.clearDirectiveStats();
            this.blockManager.getDatanodeManager().clearPendingCachingCommands();
            this.blockManager.getDatanodeManager().setShouldSendCachingCommands(false);
            this.blockManager.clearQueues();
            this.initializedReplQueues = false;
        }
        finally {
            this.writeUnlock();
        }
    }

    void startStandbyServices(Configuration conf) throws IOException {
        LOG.info((Object)"Starting services required for standby state");
        if (!this.dir.fsImage.editLog.isOpenForRead()) {
            this.dir.fsImage.editLog.initSharedJournalsForRead();
        }
        this.blockManager.setPostponeBlocksFromFuture(true);
        this.editLogTailer = new EditLogTailer(this, conf);
        this.editLogTailer.start();
        if (this.standbyShouldCheckpoint) {
            this.standbyCheckpointer = new StandbyCheckpointer(conf, this);
            this.standbyCheckpointer.start();
        }
    }

    void triggerRollbackCheckpoint() {
        this.setNeedRollbackFsImage(true);
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.triggerRollbackCheckpoint();
        }
    }

    void prepareToStopStandbyServices() throws ServiceFailedException {
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.cancelAndPreventCheckpoints("About to leave standby state");
        }
    }

    void stopStandbyServices() throws IOException {
        LOG.info((Object)"Stopping services started for standby state");
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.stop();
        }
        if (this.editLogTailer != null) {
            this.editLogTailer.stop();
        }
        if (this.dir != null && this.dir.fsImage != null && this.dir.fsImage.editLog != null) {
            this.dir.fsImage.editLog.close();
        }
    }

    @Override
    public void checkOperation(NameNode.OperationCategory op) throws StandbyException {
        if (this.haContext != null) {
            this.haContext.checkOperation(op);
        }
    }

    private void checkNameNodeSafeMode(String errorMsg) throws RetriableException, SafeModeException {
        if (this.isInSafeMode()) {
            SafeModeException se = new SafeModeException(errorMsg, this.safeMode);
            if (this.haEnabled && this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE && this.shouldRetrySafeMode(this.safeMode)) {
                throw new RetriableException((Exception)se);
            }
            throw se;
        }
    }

    private boolean shouldRetrySafeMode(SafeModeInfo safeMode) {
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow();
    }

    public static Collection<URI> getNamespaceDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.name.dir");
    }

    public static Collection<URI> getRequiredNamespaceEditsDirs(Configuration conf) {
        HashSet<URI> ret = new HashSet<URI>();
        ret.addAll(FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir.required"));
        ret.addAll(FSNamesystem.getSharedEditsDirs(conf));
        return ret;
    }

    private static Collection<URI> getStorageDirs(Configuration conf, String propertyName) {
        List<String> dirNames = conf.getTrimmedStringCollection(propertyName);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.IMPORT) {
            HdfsConfiguration cE = new HdfsConfiguration(false);
            cE.addResource("core-default.xml");
            cE.addResource("core-site.xml");
            cE.addResource("hdfs-default.xml");
            Collection dirNames2 = cE.getTrimmedStringCollection(propertyName);
            dirNames.removeAll(dirNames2);
            if (dirNames.isEmpty()) {
                LOG.warn((Object)("!!! WARNING !!!\n\tThe NameNode currently runs without persistent storage.\n\tAny changes to the file system meta-data may be lost.\n\tRecommended actions:\n\t\t- shutdown and restart NameNode with configured \"" + propertyName + "\" in hdfs-site.xml;" + "\n\t\t- use Backup Node as a persistent and up-to-date storage " + "of the file system meta-data."));
            }
        } else if (dirNames.isEmpty()) {
            dirNames = Collections.singletonList("file:///tmp/hadoop/dfs/name");
        }
        return Util.stringCollectionAsURIs((Collection<String>)dirNames);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf) throws IOException {
        return FSNamesystem.getNamespaceEditsDirs(conf, true);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf, boolean includeShared) throws IOException {
        LinkedHashSet<URI> editsDirs = new LinkedHashSet<URI>();
        if (includeShared) {
            List<URI> sharedDirs = FSNamesystem.getSharedEditsDirs(conf);
            if (sharedDirs.size() > 1) {
                throw new IOException("Multiple shared edits directories are not yet supported");
            }
            for (URI dir : sharedDirs) {
                if (editsDirs.add(dir)) continue;
                LOG.warn((Object)("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + ". Ignoring duplicates."));
            }
        }
        for (URI dir : FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir")) {
            if (editsDirs.add(dir)) continue;
            LOG.warn((Object)("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + " and " + "dfs.namenode.edits.dir" + ". Ignoring duplicates."));
        }
        if (editsDirs.isEmpty()) {
            return Lists.newArrayList(FSNamesystem.getNamespaceDirs(conf));
        }
        return Lists.newArrayList(editsDirs);
    }

    public static List<URI> getSharedEditsDirs(Configuration conf) {
        Collection dirNames = conf.getTrimmedStringCollection("dfs.namenode.shared.edits.dir");
        return Util.stringCollectionAsURIs(dirNames);
    }

    @Override
    public void readLock() {
        this.fsLock.readLock().lock();
    }

    @Override
    public void longReadLockInterruptibly() throws InterruptedException {
        this.fsLock.longReadLock().lockInterruptibly();
        try {
            this.fsLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            this.fsLock.longReadLock().unlock();
            throw ie;
        }
    }

    @Override
    public void longReadUnlock() {
        this.fsLock.readLock().unlock();
        this.fsLock.longReadLock().unlock();
    }

    @Override
    public void readUnlock() {
        this.fsLock.readLock().unlock();
    }

    @Override
    public void writeLock() {
        this.fsLock.longReadLock().lock();
        this.fsLock.writeLock().lock();
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException {
        this.fsLock.longReadLock().lockInterruptibly();
        try {
            this.fsLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            this.fsLock.longReadLock().unlock();
            throw ie;
        }
    }

    @Override
    public void writeUnlock() {
        this.fsLock.writeLock().unlock();
        this.fsLock.longReadLock().unlock();
    }

    @Override
    public boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean hasReadLock() {
        return this.fsLock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    public int getReadHoldCount() {
        return this.fsLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.fsLock.getWriteHoldCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = this.unprotectedGetNamespaceInfo();
            return namespaceInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    NamespaceInfo unprotectedGetNamespaceInfo() {
        return new NamespaceInfo(this.dir.fsImage.getStorage().getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), this.dir.fsImage.getStorage().getCTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        block8: {
            this.fsRunning = false;
            try {
                this.stopCommonServices();
                if (this.smmthread == null) break block8;
                this.smmthread.interrupt();
            }
            catch (Throwable throwable) {
                try {
                    this.stopActiveServices();
                    this.stopStandbyServices();
                    if (this.dir != null) {
                        this.dir.close();
                    }
                }
                catch (IOException ie) {
                    LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
                }
                throw throwable;
            }
        }
        try {
            this.stopActiveServices();
            this.stopStandbyServices();
            if (this.dir != null) {
                this.dir.close();
            }
        }
        catch (IOException ie) {
            LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
        }
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    @Override
    public boolean isInStandbyState() {
        if (this.haContext == null || this.haContext.getState() == null) {
            return this.haEnabled;
        }
        return HAServiceProtocol.HAServiceState.STANDBY == this.haContext.getState().getServiceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            File file = new File(System.getProperty("hadoop.log.dir"), filename);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8)));
            this.metaSave(out);
            out.flush();
            out.close();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void metaSave(PrintWriter out) {
        assert (this.hasWriteLock());
        long totalInodes = this.dir.totalInodes();
        long totalBlocks = this.getBlocksTotal();
        out.println(totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total");
        this.blockManager.metaSave(out);
    }

    private String metaSaveAsString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.metaSave(pw);
        pw.flush();
        return sw.toString();
    }

    long getDefaultBlockSize() {
        return this.serverDefaults.getBlockSize();
    }

    FsServerDefaults getServerDefaults() throws StandbyException {
        this.checkOperation(NameNode.OperationCategory.READ);
        return this.serverDefaults;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            this.setPermissionInt(src, permission);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setPermission", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPermissionInt(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set permission for " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            this.dir.setPermission(src, permission);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setPermission", src, null, resultingStat);
    }

    void setOwner(String src, String username, String group) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            this.setOwnerInt(src, username, group);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setOwner", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOwnerInt(String src, String username, String group) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set owner for " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            if (!pc.isSuperUser()) {
                if (username != null && !pc.getUser().equals(username)) {
                    throw new AccessControlException("Non-super user cannot change owner");
                }
                if (group != null && !pc.containsGroup(group)) {
                    throw new AccessControlException("User does not belong to " + group);
                }
            }
            this.dir.setOwner(src, username, group);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setOwner", src, null, resultingStat);
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        LocatedBlocks blocks = this.getBlockLocations(src, offset, length, true, true, true);
        if (blocks != null) {
            this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blocks.getLocatedBlocks());
            LocatedBlock lastBlock = blocks.getLastLocatedBlock();
            if (lastBlock != null) {
                ArrayList<LocatedBlock> lastBlockList = new ArrayList<LocatedBlock>();
                lastBlockList.add(lastBlock);
                this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, lastBlockList);
            }
        }
        return blocks;
    }

    LocatedBlocks getBlockLocations(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws FileNotFoundException, UnresolvedLinkException, IOException {
        try {
            return this.getBlockLocationsInt(src, offset, length, doAccessTime, needBlockToken, checkSafeMode);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "open", src);
            throw e;
        }
    }

    private LocatedBlocks getBlockLocationsInt(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws FileNotFoundException, UnresolvedLinkException, IOException {
        if (offset < 0L) {
            throw new HadoopIllegalArgumentException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new HadoopIllegalArgumentException("Negative length is not supported. File: " + src);
        }
        LocatedBlocks ret = this.getBlockLocationsUpdateTimes(src, offset, length, doAccessTime, needBlockToken);
        this.logAuditEvent(true, "open", src);
        if (checkSafeMode && this.isInSafeMode()) {
            for (LocatedBlock b : ret.getLocatedBlocks()) {
                if (b.getLocations() != null && b.getLocations().length != 0) continue;
                SafeModeException se = new SafeModeException("Zero blocklocations for " + src, this.safeMode);
                if (this.haEnabled && this.haContext != null && this.haContext.getState().getServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
                    throw new RetriableException((Exception)se);
                }
                throw se;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlocks getBlockLocationsUpdateTimes(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws FileNotFoundException, UnresolvedLinkException, IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        for (int attempt = 0; attempt < 2; ++attempt) {
            boolean isReadOp;
            boolean bl = isReadOp = attempt == 0;
            if (isReadOp) {
                this.checkOperation(NameNode.OperationCategory.READ);
                this.readLock();
            } else {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.writeLock();
            }
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            try {
                long now;
                if (isReadOp) {
                    this.checkOperation(NameNode.OperationCategory.READ);
                } else {
                    this.checkOperation(NameNode.OperationCategory.WRITE);
                }
                if (this.isPermissionEnabled) {
                    this.checkPathAccess(pc, src, FsAction.READ);
                }
                if (this.isInSafeMode()) {
                    doAccessTime = false;
                }
                INodesInPath iip = this.dir.getLastINodeInPath(src);
                INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
                if (!iip.isSnapshot() && doAccessTime && this.isAccessTimeSupported() && (now = Time.now()) > inode.getAccessTime() + this.getAccessTimePrecision()) {
                    if (isReadOp) continue;
                    this.dir.setTimes(src, inode, -1L, now, false, iip.getLatestSnapshotId());
                }
                long fileSize = iip.isSnapshot() ? inode.computeFileSize(iip.getPathSnapshotId()) : inode.computeFileSizeNotIncludingLastUcBlock();
                boolean isUc = inode.isUnderConstruction();
                if (iip.isSnapshot()) {
                    length = Math.min(length, fileSize - offset);
                    isUc = false;
                }
                LocatedBlocks blocks = this.blockManager.createLocatedBlocks(inode.getBlocks(), fileSize, isUc, offset, length, needBlockToken, iip.isSnapshot());
                for (LocatedBlock lb : blocks.getLocatedBlocks()) {
                    this.cacheManager.setCachedLocations(lb);
                }
                LocatedBlocks locatedBlocks = blocks;
                return locatedBlocks;
            }
            finally {
                if (isReadOp) {
                    this.readUnlock();
                } else {
                    this.writeUnlock();
                }
            }
        }
        return null;
    }

    void concat(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + Arrays.toString(srcs) + " to " + target));
        }
        boolean success = false;
        try {
            this.concatInt(target, srcs, cacheEntry != null);
            success = true;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "concat", Arrays.toString(srcs), target, null);
            throw e;
        }
        finally {
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatInt(String target, String[] srcs, boolean logRetryCache) throws IOException, UnresolvedLinkException {
        if (target.isEmpty()) {
            throw new IllegalArgumentException("Target file name is empty");
        }
        if (srcs == null || srcs.length == 0) {
            throw new IllegalArgumentException("No sources given");
        }
        String trgParent = target.substring(0, target.lastIndexOf(47));
        for (String s : srcs) {
            String srcParent = s.substring(0, s.lastIndexOf(47));
            if (srcParent.equals(trgParent)) continue;
            throw new IllegalArgumentException("Sources and target are not in the same directory");
        }
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot concat " + target);
            this.concatInternal(pc, target, srcs, logRetryCache);
            resultingStat = this.getAuditFileInfo(target, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "concat", Arrays.toString(srcs), target, resultingStat);
    }

    private void concatInternal(FSPermissionChecker pc, String target, String[] srcs, boolean logRetryCache) throws IOException, UnresolvedLinkException {
        BlockInfo last;
        assert (this.hasWriteLock());
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, target, FsAction.WRITE);
            for (String aSrc : srcs) {
                this.checkPathAccess(pc, aSrc, FsAction.READ);
                this.checkParentAccess(pc, aSrc, FsAction.WRITE);
            }
        }
        HashSet<INodeFile> si = new HashSet<INodeFile>();
        INodeFile trgInode = INodeFile.valueOf(this.dir.getINode4Write(target), target);
        if (trgInode.isUnderConstruction()) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is under construction");
        }
        if (trgInode.numBlocks() == 0) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is empty");
        }
        if (trgInode.isWithSnapshot()) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is in a snapshot");
        }
        long blockSize = trgInode.getPreferredBlockSize();
        if (blockSize != (last = trgInode.getLastBlock()).getNumBytes()) {
            throw new HadoopIllegalArgumentException("The last block in " + target + " is not full; last block size = " + last.getNumBytes() + " but file block size = " + blockSize);
        }
        si.add(trgInode);
        short repl = trgInode.getFileReplication();
        boolean endSrc = false;
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            if (i == srcs.length - 1) {
                endSrc = true;
            }
            INodeFile srcInode = INodeFile.valueOf(this.dir.getINode4Write(src), src);
            if (src.isEmpty() || srcInode.isUnderConstruction() || srcInode.numBlocks() == 0) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " is invalid or empty or underConstruction");
            }
            if (repl != srcInode.getBlockReplication()) {
                throw new HadoopIllegalArgumentException("concat: the soruce file " + src + " and the target file " + target + " should have the same replication: source replication is " + srcInode.getBlockReplication() + " but target replication is " + repl);
            }
            BlockInfo[] srcBlocks = srcInode.getBlocks();
            int idx = srcBlocks.length - 1;
            if (endSrc) {
                idx = srcBlocks.length - 2;
            }
            if (idx >= 0 && srcBlocks[idx].getNumBytes() != blockSize) {
                throw new HadoopIllegalArgumentException("concat: the soruce file " + src + " and the target file " + target + " should have the same blocks sizes: target block size is " + blockSize + " but the size of source block " + idx + " is " + srcBlocks[idx].getNumBytes());
            }
            si.add(srcInode);
        }
        if (si.size() < srcs.length + 1) {
            throw new HadoopIllegalArgumentException("concat: at least two of the source files are the same");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target));
        }
        this.dir.concat(target, srcs, logRetryCache);
    }

    void setTimes(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        if (!this.isAccessTimeSupported() && atime != -1L) {
            throw new IOException("Access time for hdfs is not configured.  Please set dfs.namenode.accesstime.precision configuration parameter.");
        }
        try {
            this.setTimesInt(src, mtime, atime);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setTimes", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimesInt(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat;
        block5: {
            resultingStat = null;
            FSPermissionChecker pc = this.getPermissionChecker();
            this.checkOperation(NameNode.OperationCategory.WRITE);
            byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
            this.writeLock();
            try {
                INodesInPath iip;
                INode inode;
                this.checkOperation(NameNode.OperationCategory.WRITE);
                this.checkNameNodeSafeMode("Cannot set times " + src);
                src = FSDirectory.resolvePath(src, pathComponents, this.dir);
                if (this.isPermissionEnabled) {
                    this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                if ((inode = (iip = this.dir.getINodesInPath4Write(src)).getLastINode()) != null) {
                    this.dir.setTimes(src, inode, mtime, atime, true, iip.getLatestSnapshotId());
                    resultingStat = this.getAuditFileInfo(src, false);
                    break block5;
                }
                throw new FileNotFoundException("File/Directory " + src + " does not exist.");
            }
            finally {
                this.writeUnlock();
            }
        }
        this.logAuditEvent(true, "setTimes", src, null, resultingStat);
    }

    void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        if (!DFSUtil.isValidName(link)) {
            throw new InvalidPathException("Invalid link name: " + link);
        }
        if (FSDirectory.isReservedName(target)) {
            throw new InvalidPathException("Invalid target name: " + target);
        }
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.createSymlinkInt(target, link, dirPerms, createParent, cacheEntry != null);
            success = true;
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createSymlink", link, target, null);
            throw e;
        }
        finally {
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSymlinkInt(String target, String link, PermissionStatus dirPerms, boolean createParent, boolean logRetryCache) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.createSymlink: target=" + target + " link=" + link));
        }
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(link);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create symlink " + link);
            link = FSDirectory.resolvePath(link, pathComponents, this.dir);
            if (!createParent) {
                this.verifyParentDir(link);
            }
            if (!this.dir.isValidToCreate(link)) {
                throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
            }
            if (this.isPermissionEnabled) {
                this.checkAncestorAccess(pc, link, FsAction.WRITE);
            }
            this.checkFsObjectLimit();
            this.dir.addSymlink(link, target, dirPerms, createParent, logRetryCache);
            resultingStat = this.getAuditFileInfo(link, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "createSymlink", link, target, resultingStat);
    }

    boolean setReplication(String src, short replication) throws IOException {
        try {
            return this.setReplicationInt(src, replication);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setReplication", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setReplicationInt(String src, short replication) throws IOException {
        boolean isFile;
        this.blockManager.verifyReplication(src, replication, null);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            short[] blockRepls;
            Block[] blocks;
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set replication for " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            boolean bl = isFile = (blocks = this.dir.setReplication(src, replication, blockRepls = new short[2])) != null;
            if (isFile) {
                this.blockManager.setReplication(blockRepls[0], blockRepls[1], src, blocks);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (isFile) {
            this.logAuditEvent(true, "setReplication", src);
        }
        return isFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(filename);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            filename = FSDirectory.resolvePath(filename, pathComponents, this.dir);
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, filename);
            }
            long l = this.dir.getPreferredBlockSize(filename);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    private void verifyParentDir(String src) throws FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException {
        assert (this.hasReadLock());
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode parentNode = this.dir.getINode(parent.toString());
            if (parentNode == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent);
            }
            if (!parentNode.isDirectory() && !parentNode.isSymlink()) {
                throw new ParentNotDirectoryException("Parent path is not a directory: " + parent);
            }
        }
    }

    HdfsFileStatus startFile(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        HdfsFileStatus status = null;
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (HdfsFileStatus)cacheEntry.getPayload();
        }
        try {
            status = this.startFileInt(src, permissions, holder, clientMachine, flag, createParent, replication, blockSize, cacheEntry != null);
            RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (status != null ? 1 : 0) != 0, (Object)status);
        }
        catch (AccessControlException e) {
            try {
                this.logAuditEvent(false, "create", src);
                throw e;
            }
            catch (Throwable throwable) {
                RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (status != null ? 1 : 0) != 0, status);
                throw throwable;
            }
        }
        return status;
    }

    private HdfsFileStatus startFileInt(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, boolean logRetryCache) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", createFlag=" + flag.toString()));
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        this.blockManager.verifyReplication(src, replication, clientMachine);
        boolean skipSync = false;
        HdfsFileStatus stat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        if (blockSize < this.minBlockSize) {
            throw new IOException("Specified block size is less than configured minimum value (dfs.namenode.fs-limits.min-block-size): " + blockSize + " < " + this.minBlockSize);
        }
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        boolean create = flag.contains(CreateFlag.CREATE);
        boolean overwrite = flag.contains(CreateFlag.OVERWRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create file" + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.startFileInternal(pc, src, permissions, holder, clientMachine, create, overwrite, createParent, replication, blockSize, logRetryCache);
            stat = this.dir.getFileInfo(src, false);
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock();
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
        this.logAuditEvent(true, "create", src, null, stat);
        return stat;
    }

    private void startFileInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, String holder, String clientMachine, boolean create, boolean overwrite, boolean createParent, short replication, long blockSize, boolean logRetryEntry) throws FileAlreadyExistsException, AccessControlException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.dir.getINodesInPath4Write(src);
        INode inode = iip.getLastINode();
        if (inode != null && inode.isDirectory()) {
            throw new FileAlreadyExistsException(src + " already exists as a directory");
        }
        INodeFile myFile = INodeFile.valueOf(inode, src, true);
        if (this.isPermissionEnabled) {
            if (overwrite && myFile != null) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            } else {
                this.checkAncestorAccess(pc, src, FsAction.WRITE);
            }
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        try {
            if (myFile == null) {
                if (!create) {
                    throw new FileNotFoundException("Can't overwrite non-existent " + src + " for client " + clientMachine);
                }
            } else if (overwrite) {
                try {
                    this.deleteInt(src, true, false);
                }
                catch (AccessControlException e) {
                    this.logAuditEvent(false, "delete", src);
                    throw e;
                }
            } else {
                this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
                throw new FileAlreadyExistsException(src + " for client " + clientMachine + " already exists");
            }
            this.checkFsObjectLimit();
            DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            INodeFile newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode);
            if (newNode == null) {
                throw new IOException("Unable to add " + src + " to namespace");
            }
            this.leaseManager.addLease(newNode.getFileUnderConstructionFeature().getClientName(), src);
            this.getEditLog().logOpenFile(src, newNode, logRetryEntry);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: added " + src + " inode " + newNode.getId() + " " + holder));
            }
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + src + " " + ie.getMessage()));
            throw ie;
        }
    }

    private LocatedBlock appendFileInternal(FSPermissionChecker pc, String src, String holder, String clientMachine, boolean logRetryCache) throws AccessControlException, UnresolvedLinkException, FileNotFoundException, IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.dir.getINodesInPath4Write(src);
        INode inode = iip.getLastINode();
        if (inode != null && inode.isDirectory()) {
            throw new FileAlreadyExistsException("Cannot append to directory " + src + "; already exists as a directory.");
        }
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.WRITE);
        }
        try {
            if (inode == null) {
                throw new FileNotFoundException("failed to append to non-existent file " + src + " for client " + clientMachine);
            }
            INodeFile myFile = INodeFile.valueOf(inode, src, true);
            this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
            myFile = INodeFile.valueOf(this.dir.getINode(src), src, true);
            BlockInfo lastBlock = myFile.getLastBlock();
            if (lastBlock != null && lastBlock.isComplete() && !this.getBlockManager().isSufficientlyReplicated(lastBlock)) {
                throw new IOException("append: lastBlock=" + lastBlock + " of src=" + src + " is not sufficiently replicated yet.");
            }
            DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            return this.prepareFileForWrite(src, myFile, holder, clientMachine, clientNode, true, iip.getLatestSnapshotId(), logRetryCache);
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.append: " + ie.getMessage()));
            throw ie;
        }
    }

    LocatedBlock prepareFileForWrite(String src, INodeFile file, String leaseHolder, String clientMachine, DatanodeDescriptor clientNode, boolean writeToEditLog, int latestSnapshot, boolean logRetryCache) throws IOException {
        file = file.recordModification(latestSnapshot);
        INodeFile cons = file.toUnderConstruction(leaseHolder, clientMachine, clientNode);
        this.leaseManager.addLease(cons.getFileUnderConstructionFeature().getClientName(), src);
        LocatedBlock ret = this.blockManager.convertLastBlockToUnderConstruction(cons);
        if (writeToEditLog) {
            this.getEditLog().logOpenFile(src, cons, logRetryCache);
        }
        return ret;
    }

    boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        if (!DFSUtil.isValidName(src)) {
            throw new IOException("Invalid file name: " + src);
        }
        boolean skipSync = false;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot recover the lease of " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            INodeFile inode = INodeFile.valueOf(this.dir.getINode(src), src);
            if (!inode.isUnderConstruction()) {
                boolean bl = true;
                return bl;
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            this.recoverLeaseInternal(inode, src, holder, clientMachine, true);
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock();
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
        return false;
    }

    private void recoverLeaseInternal(INodeFile fileInode, String src, String holder, String clientMachine, boolean force) throws IOException {
        assert (this.hasWriteLock());
        if (fileInode != null && fileInode.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && ((leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease) || lease.getHolder().equals(holder))) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " for client " + clientMachine + " because current leaseholder is trying to recreate file.");
            }
            FileUnderConstructionFeature uc = fileInode.getFileUnderConstructionFeature();
            String clientName = uc.getClientName();
            lease = this.leaseManager.getLease(clientName);
            if (lease == null) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " for client " + clientMachine + " because pendingCreates is non-null but no leases found.");
            }
            if (force) {
                LOG.info((Object)("recoverLease: " + lease + ", src=" + src + " from client " + clientName));
                this.internalReleaseLease(lease, src, holder);
            } else {
                assert (lease.getHolder().equals(clientName)) : "Current lease holder " + lease.getHolder() + " does not match file creator " + clientName;
                if (lease.expiredSoftLimit()) {
                    LOG.info((Object)("startFile: recover " + lease + ", src=" + src + " client " + clientName));
                    boolean isClosed = this.internalReleaseLease(lease, src, null);
                    if (!isClosed) {
                        throw new RecoveryInProgressException("Failed to close file " + src + ". Lease recovery is in progress. Try again later.");
                    }
                } else {
                    BlockInfo lastBlock = fileInode.getLastBlock();
                    if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                        throw new RecoveryInProgressException("Recovery in progress, file [" + src + "], " + "lease owner [" + lease.getHolder() + "]");
                    }
                    throw new AlreadyBeingCreatedException("Failed to create file [" + src + "] for [" + holder + "] for client [" + clientMachine + "], because this file is already being created by [" + clientName + "] on [" + uc.getClientMachine() + "]");
                }
            }
        }
    }

    LocatedBlock appendFile(String src, String holder, String clientMachine) throws AccessControlException, SafeModeException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        LocatedBlock locatedBlock;
        LocatedBlock lb = null;
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (LocatedBlock)cacheEntry.getPayload();
        }
        boolean success = false;
        try {
            lb = this.appendFileInt(src, holder, clientMachine, cacheEntry != null);
            success = true;
            locatedBlock = lb;
        }
        catch (AccessControlException e) {
            try {
                this.logAuditEvent(false, "append", src);
                throw e;
            }
            catch (Throwable throwable) {
                RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (boolean)success, lb);
                throw throwable;
            }
        }
        RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (boolean)success, (Object)lb);
        return locatedBlock;
    }

    private LocatedBlock appendFileInt(String src, String holder, String clientMachine, boolean logRetryCache) throws AccessControlException, SafeModeException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine));
        }
        boolean skipSync = false;
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append is not enabled on this NameNode. Use the dfs.support.append configuration option to enable it.");
        }
        LocatedBlock lb = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot append to file" + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            lb = this.appendFileInternal(pc, src, holder, clientMachine, logRetryCache);
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock();
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes()));
        }
        this.logAuditEvent(true, "append", src);
        return lb;
    }

    ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.blockPoolId, blk);
    }

    void setBlockPoolId(String bpid) {
        this.blockPoolId = bpid;
        this.blockManager.setBlockPoolId(this.blockPoolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalBlock(String src, long fileId, String clientName, ExtendedBlock previous, Set<Node> excludedNodes, List<String> favoredNodes) throws LeaseExpiredException, NotReplicatedYetException, QuotaExceededException, SafeModeException, UnresolvedLinkException, IOException {
        long offset;
        short replication;
        long blockSize;
        DatanodeDescriptor clientNode = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: " + src + " inodeId " + fileId + " for " + clientName));
        }
        this.checkOperation(NameNode.OperationCategory.READ);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            LocatedBlock[] onRetryBlock = new LocatedBlock[1];
            INode[] inodes = this.analyzeFileState(src, fileId, clientName, previous, onRetryBlock).getINodes();
            INodeFile pendingFile = inodes[inodes.length - 1].asFile();
            if (onRetryBlock[0] != null && onRetryBlock[0].getLocations().length > 0) {
                LocatedBlock locatedBlock = onRetryBlock[0];
                return locatedBlock;
            }
            if ((long)pendingFile.getBlocks().length >= this.maxBlocksPerFile) {
                throw new IOException("File has reached the limit on maximum number of blocks (dfs.namenode.fs-limits.max-blocks-per-file): " + pendingFile.getBlocks().length + " >= " + this.maxBlocksPerFile);
            }
            blockSize = pendingFile.getPreferredBlockSize();
            clientNode = pendingFile.getFileUnderConstructionFeature().getClientNode();
            replication = pendingFile.getFileReplication();
        }
        finally {
            this.readUnlock();
        }
        DatanodeStorageInfo[] targets = this.getBlockManager().chooseTarget(src, replication, clientNode, excludedNodes, blockSize, favoredNodes);
        Block newBlock = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            LocatedBlock[] onRetryBlock = new LocatedBlock[1];
            INodesInPath inodesInPath = this.analyzeFileState(src, fileId, clientName, previous, onRetryBlock);
            INode[] inodes = inodesInPath.getINodes();
            INodeFile pendingFile = inodes[inodes.length - 1].asFile();
            if (onRetryBlock[0] != null) {
                if (onRetryBlock[0].getLocations().length > 0) {
                    LocatedBlock locatedBlock = onRetryBlock[0];
                    return locatedBlock;
                }
                BlockInfo lastBlockInFile = pendingFile.getLastBlock();
                ((BlockInfoUnderConstruction)lastBlockInFile).setExpectedLocations(targets);
                long offset2 = pendingFile.computeFileSize();
                LocatedBlock locatedBlock = this.makeLocatedBlock(lastBlockInFile, targets, offset2);
                return locatedBlock;
            }
            this.commitOrCompleteLastBlock(pendingFile, ExtendedBlock.getLocalBlock(previous));
            newBlock = this.createNewBlock();
            this.saveAllocatedBlock(src, inodesInPath, newBlock, targets);
            this.dir.persistNewBlock(src, pendingFile);
            offset = pendingFile.computeFileSize();
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return this.makeLocatedBlock(newBlock, targets, offset);
    }

    INodesInPath analyzeFileState(String src, long fileId, String clientName, ExtendedBlock previous, LocatedBlock[] onRetryBlock) throws IOException {
        assert (this.hasReadLock());
        this.checkBlock(previous);
        onRetryBlock[0] = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.checkNameNodeSafeMode("Cannot add block to " + src);
        this.checkFsObjectLimit();
        Block previousBlock = ExtendedBlock.getLocalBlock(previous);
        INodesInPath iip = this.dir.getINodesInPath4Write(src);
        INodeFile pendingFile = this.checkLease(src, fileId, clientName, iip.getLastINode());
        BlockInfo lastBlockInFile = pendingFile.getLastBlock();
        if (!Block.matchingIdAndGenStamp(previousBlock, lastBlockInFile)) {
            BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
            if (previous == null && lastBlockInFile != null && lastBlockInFile.getNumBytes() == pendingFile.getPreferredBlockSize() && lastBlockInFile.isComplete()) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.allocateBlock: handling block allocation writing to a file with a complete previous block: src=" + src + " lastBlock=" + lastBlockInFile));
                }
            } else {
                if (Block.matchingIdAndGenStamp(penultimateBlock, previousBlock)) {
                    if (lastBlockInFile.getNumBytes() != 0L) {
                        throw new IOException("Request looked like a retry to allocate block " + lastBlockInFile + " but it already contains " + lastBlockInFile.getNumBytes() + " bytes");
                    }
                    NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: caught retry for allocation of a new block in " + src + ". Returning previously allocated block " + lastBlockInFile));
                    long offset = pendingFile.computeFileSize();
                    onRetryBlock[0] = this.makeLocatedBlock(lastBlockInFile, ((BlockInfoUnderConstruction)lastBlockInFile).getExpectedStorageLocations(), offset);
                    return iip;
                }
                throw new IOException("Cannot allocate block in " + src + ": " + "passed 'previous' block " + previous + " does not match actual " + "last block in file " + lastBlockInFile);
            }
        }
        if (!this.checkFileProgress(pendingFile, false)) {
            throw new NotReplicatedYetException("Not replicated yet: " + src);
        }
        return iip;
    }

    LocatedBlock makeLocatedBlock(Block blk, DatanodeStorageInfo[] locs, long offset) throws IOException {
        LocatedBlock lBlk = new LocatedBlock(this.getExtendedBlock(blk), locs, offset, false);
        this.getBlockManager().setBlockToken(lBlk, BlockTokenSecretManager.AccessMode.WRITE);
        return lBlk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, String[] storageIDs, Set<Node> excludes, int numAdditionalNodes, String clientName) throws IOException {
        List<DatanodeStorageInfo> chosen;
        long preferredblocksize;
        DatanodeDescriptor clientnode;
        this.dtpReplaceDatanodeOnFailure.checkEnabled();
        this.checkOperation(NameNode.OperationCategory.READ);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            this.checkNameNodeSafeMode("Cannot add datanode; src=" + src + ", blk=" + blk);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            INodeFile file = this.checkLease(src, clientName);
            clientnode = file.getFileUnderConstructionFeature().getClientNode();
            preferredblocksize = file.getPreferredBlockSize();
            DatanodeManager dm = this.blockManager.getDatanodeManager();
            chosen = Arrays.asList(dm.getDatanodeStorageInfos(existings, storageIDs));
        }
        finally {
            this.readUnlock();
        }
        DatanodeStorageInfo[] targets = this.blockManager.getBlockPlacementPolicy().chooseTarget(src, numAdditionalNodes, clientnode, chosen, true, excludes, preferredblocksize, StorageType.DEFAULT);
        LocatedBlock lb = new LocatedBlock(blk, targets);
        this.blockManager.setBlockToken(lb, BlockTokenSecretManager.AccessMode.COPY);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean abandonBlock(ExtendedBlock b, String src, String holder) throws LeaseExpiredException, FileNotFoundException, UnresolvedLinkException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src));
        }
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot abandon block " + b + " for fle" + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            INodeFile file = this.checkLease(src, holder);
            boolean removed = this.dir.removeBlock(src, file, ExtendedBlock.getLocalBlock(b));
            if (!removed) {
                boolean bl = true;
                return bl;
            }
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates"));
            }
            this.dir.persistBlocks(src, file, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return true;
    }

    private INodeFile checkLease(String src, String holder) throws LeaseExpiredException, UnresolvedLinkException, FileNotFoundException {
        return this.checkLease(src, 0L, holder, this.dir.getINode(src));
    }

    private INodeFile checkLease(String src, long fileId, String holder, INode inode) throws LeaseExpiredException, FileNotFoundException {
        assert (this.hasReadLock());
        if (inode == null || !inode.isFile()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + ": File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        INodeFile file = inode.asFile();
        if (!file.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + ": File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (file.getParent() == null || file.isWithSnapshot() && file.getFileWithSnapshotFeature().isCurrentFileDeleted()) {
            throw new FileNotFoundException(src);
        }
        String clientName = file.getFileUnderConstructionFeature().getClientName();
        if (holder != null && !clientName.equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + clientName + " but is accessed by " + holder);
        }
        INodeId.checkId(fileId, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean completeFile(String src, String holder, ExtendedBlock last, long fileId) throws SafeModeException, UnresolvedLinkException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
        }
        this.checkBlock(last);
        boolean success = false;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot complete file " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            success = this.completeFileInternal(src, holder, ExtendedBlock.getLocalBlock(last), fileId);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (success) {
            NameNode.stateChangeLog.info((Object)("DIR* completeFile: " + src + " is closed by " + holder));
        }
        return success;
    }

    private boolean completeFileInternal(String src, String holder, Block last, long fileId) throws SafeModeException, UnresolvedLinkException, IOException {
        INodeFile pendingFile;
        assert (this.hasWriteLock());
        INodesInPath iip = this.dir.getLastINodeInPath(src);
        try {
            pendingFile = this.checkLease(src, fileId, holder, iip.getINode(0));
        }
        catch (LeaseExpiredException lee) {
            BlockInfo realLastBlock;
            INode inode = this.dir.getINode(src);
            if (inode != null && inode.isFile() && !inode.asFile().isUnderConstruction() && Block.matchingIdAndGenStamp(last, realLastBlock = inode.asFile().getLastBlock())) {
                NameNode.stateChangeLog.info((Object)("DIR* completeFile: request from " + holder + " to complete " + src + " which is already closed. But, it appears to be an RPC " + "retry. Returning success"));
                return true;
            }
            throw lee;
        }
        if (!this.checkFileProgress(pendingFile, false)) {
            return false;
        }
        this.commitOrCompleteLastBlock(pendingFile, last);
        if (!this.checkFileProgress(pendingFile, true)) {
            return false;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId());
        return true;
    }

    BlockInfo saveAllocatedBlock(String src, INodesInPath inodes, Block newBlock, DatanodeStorageInfo[] targets) throws IOException {
        assert (this.hasWriteLock());
        BlockInfo b = this.dir.addBlock(src, inodes, newBlock, targets);
        NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: " + src + ". " + this.getBlockPoolId() + " " + b));
        DatanodeStorageInfo.incrementBlocksScheduled(targets);
        return b;
    }

    Block createNewBlock() throws IOException {
        assert (this.hasWriteLock());
        Block b = new Block(this.nextBlockId(), 0L, 0L);
        b.setGenerationStamp(this.nextGenerationStamp(false));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileProgress(INodeFile v, boolean checkall) {
        this.readLock();
        try {
            if (checkall) {
                for (BlockInfo block : v.getBlocks()) {
                    if (block.isComplete()) continue;
                    LOG.info((Object)("BLOCK* checkFileProgress: " + block + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            } else {
                BlockInfo b = v.getPenultimateBlock();
                if (b != null && !b.isComplete()) {
                    LOG.warn((Object)("BLOCK* checkFileProgress: " + b + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Deprecated
    boolean renameTo(String src, String dst) throws IOException, UnresolvedLinkException {
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.renameToInt(src, dst, cacheEntry != null);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename", src, dst, null);
            throw e;
        }
        finally {
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameToInt(String src, String dst, boolean logRetryCache) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new IOException("Invalid name: " + dst);
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] srcComponents = FSDirectory.getPathComponentsForReservedPath(src);
        byte[][] dstComponents = FSDirectory.getPathComponentsForReservedPath(dst);
        boolean status = false;
        HdfsFileStatus resultingStat = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot rename " + src);
            src = FSDirectory.resolvePath(src, srcComponents, this.dir);
            dst = FSDirectory.resolvePath(dst, dstComponents, this.dir);
            this.checkOperation(NameNode.OperationCategory.WRITE);
            status = this.renameToInternal(pc, src, dst, logRetryCache);
            if (status) {
                resultingStat = this.getAuditFileInfo(dst, false);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (status) {
            this.logAuditEvent(true, "rename", src, dst, resultingStat);
        }
        return status;
    }

    @Deprecated
    private boolean renameToInternal(FSPermissionChecker pc, String src, String dst, boolean logRetryCache) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isPermissionEnabled) {
            String actualdst = this.dir.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
            this.checkPermission(pc, src, false, null, FsAction.WRITE, null, null, false);
            this.checkPermission(pc, actualdst, false, FsAction.WRITE, null, null, null, false);
        }
        return this.dir.renameTo(src, dst, logRetryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameTo(String src, String dst, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: with options - " + src + " to " + dst));
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new InvalidPathException("Invalid name: " + dst);
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        byte[][] srcComponents = FSDirectory.getPathComponentsForReservedPath(src);
        byte[][] dstComponents = FSDirectory.getPathComponentsForReservedPath(dst);
        HdfsFileStatus resultingStat = null;
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot rename " + src);
            src = FSDirectory.resolvePath(src, srcComponents, this.dir);
            dst = FSDirectory.resolvePath(dst, dstComponents, this.dir);
            this.renameToInternal(pc, src, dst, cacheEntry != null, options);
            resultingStat = this.getAuditFileInfo(dst, false);
            success = true;
        }
        finally {
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
        if (resultingStat != null) {
            StringBuilder cmd = new StringBuilder("rename options=");
            for (Options.Rename option : options) {
                cmd.append(option.value()).append(" ");
            }
            this.logAuditEvent(true, cmd.toString(), src, dst, resultingStat);
        }
    }

    private void renameToInternal(FSPermissionChecker pc, String src, String dst, boolean logRetryCache, Options.Rename ... options) throws IOException {
        assert (this.hasWriteLock());
        if (this.isPermissionEnabled) {
            this.checkPermission(pc, src, false, null, FsAction.WRITE, null, null, false);
            this.checkPermission(pc, dst, false, FsAction.WRITE, null, null, null, false);
        }
        this.dir.renameTo(src, dst, logRetryCache, options);
    }

    boolean delete(String src, boolean recursive) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.deleteInt(src, recursive, cacheEntry != null);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "delete", src);
            throw e;
        }
        finally {
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)ret);
        }
        return ret;
    }

    private boolean deleteInt(String src, boolean recursive, boolean logRetryCache) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        boolean status;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        }
        if (status = this.deleteInternal(src, recursive, true, logRetryCache)) {
            this.logAuditEvent(true, "delete", src);
        }
        return status;
    }

    private FSPermissionChecker getPermissionChecker() throws AccessControlException {
        try {
            return new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup, FSNamesystem.getRemoteUser());
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInternal(String src, boolean recursive, boolean enforcePermission, boolean logRetryCache) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        boolean ret = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot delete " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            if (!recursive && this.dir.isNonEmptyDirectory(src)) {
                throw new IOException(src + " is non empty");
            }
            if (enforcePermission && this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, FsAction.WRITE, null, FsAction.ALL, false);
            }
            if (!this.dir.delete(src, collectedBlocks, removedINodes, logRetryCache)) {
                boolean bl = false;
                return bl;
            }
            ret = true;
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        this.dir.writeLock();
        try {
            this.dir.removeFromInodeMap(removedINodes);
        }
        finally {
            this.dir.writeUnlock();
        }
        removedINodes.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* Namesystem.delete: " + src + " is removed"));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBlocks(INode.BlocksMapUpdateInfo blocks) {
        List<Block> toDeleteList = blocks.getToDeleteList();
        Iterator<Block> iter = toDeleteList.iterator();
        while (iter.hasNext()) {
            this.writeLock();
            try {
                for (int i = 0; i < BLOCK_DELETION_INCREMENT && iter.hasNext(); ++i) {
                    this.blockManager.removeBlock(iter.next());
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    void removePathAndBlocks(String src, INode.BlocksMapUpdateInfo blocks, List<INode> removedINodes) {
        assert (this.hasWriteLock());
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (removedINodes != null) {
            this.dir.removeFromInodeMap(removedINodes);
            removedINodes.clear();
        }
        if (blocks == null) {
            return;
        }
        this.removeBlocksAndUpdateSafemodeTotal(blocks);
    }

    void removeBlocksAndUpdateSafemodeTotal(INode.BlocksMapUpdateInfo blocks) {
        assert (this.hasWriteLock());
        boolean trackBlockCounts = this.isSafeModeTrackingBlocks();
        int numRemovedComplete = 0;
        int numRemovedSafe = 0;
        for (Block b : blocks.getToDeleteList()) {
            BlockInfo bi;
            if (trackBlockCounts && (bi = this.getStoredBlock(b)).isComplete()) {
                ++numRemovedComplete;
                if (bi.numNodes() >= this.blockManager.minReplication) {
                    ++numRemovedSafe;
                }
            }
            this.blockManager.removeBlock(b);
        }
        if (trackBlockCounts) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adjusting safe-mode totals for deletion.decreasing safeBlocks by " + numRemovedSafe + ", totalBlocks by " + numRemovedComplete));
            }
            this.adjustSafeModeBlockTotals(-numRemovedSafe, -numRemovedComplete);
        }
    }

    private boolean isSafeModeTrackingBlocks() {
        if (!this.haEnabled) {
            return false;
        }
        SafeModeInfo sm = this.safeMode;
        return sm != null && sm.shouldIncrementallyTrackBlocks();
    }

    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        HdfsFileStatus stat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            if (this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, null, null, null, resolveLink);
            }
            stat = this.dir.getFileInfo(src, resolveLink);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getfileinfo", src);
            throw e;
        }
        finally {
            this.readUnlock();
        }
        this.logAuditEvent(true, "getfileinfo", src);
        return stat;
    }

    boolean isFileClosed(String src) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, src);
            }
            boolean bl = !INodeFile.valueOf(this.dir.getINode(src), src).isUnderConstruction();
            return bl;
        }
        catch (AccessControlException e) {
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(false, "isFileClosed", src);
            }
            throw e;
        }
        finally {
            this.readUnlock();
        }
    }

    boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        boolean ret = false;
        try {
            ret = this.mkdirsInt(src, permissions, createParent);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "mkdirs", src);
            throw e;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdirsInt(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.mkdirs: " + src));
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        HdfsFileStatus resultingStat = null;
        boolean status = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create directory " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            status = this.mkdirsInternal(pc, src, permissions, createParent);
            if (status) {
                resultingStat = this.dir.getFileInfo(src, false);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (status) {
            this.logAuditEvent(true, "mkdirs", src, null, resultingStat);
        }
        return status;
    }

    private boolean mkdirsInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isPermissionEnabled) {
            this.checkTraverse(pc, src);
        }
        if (this.dir.isDirMutable(src)) {
            return true;
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, src, FsAction.WRITE);
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        this.checkFsObjectLimit();
        if (!this.dir.mkdirs(src, permissions, false, Time.now())) {
            throw new IOException("Failed to create directory: " + src);
        }
        return true;
    }

    ContentSummary getContentSummary(String src) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.readLock();
        boolean success = true;
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            if (this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, null, null, FsAction.READ_EXECUTE);
            }
            ContentSummary contentSummary = this.dir.getContentSummary(src);
            return contentSummary;
        }
        catch (AccessControlException ace) {
            success = false;
            throw ace;
        }
        finally {
            this.readUnlock();
            this.logAuditEvent(success, "contentSummary", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String path, long nsQuota, long dsQuota) throws IOException, UnresolvedLinkException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set quota on " + path);
            this.dir.setQuota(path, nsQuota, dsQuota);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, String clientName, long lastBlockLength) throws IOException, UnresolvedLinkException {
        NameNode.stateChangeLog.info((Object)("BLOCK* fsync: " + src + " for " + clientName));
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot fsync file " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            INodeFile pendingFile = this.checkLease(src, clientName);
            if (lastBlockLength > 0L) {
                pendingFile.getFileUnderConstructionFeature().updateLengthOfLastBlock(pendingFile, lastBlockLength);
            }
            this.dir.persistBlocks(src, pendingFile, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    boolean internalReleaseLease(LeaseManager.Lease lease, String src, String recoveryLeaseHolder) throws AlreadyBeingCreatedException, IOException, UnresolvedLinkException {
        boolean penultimateBlockMinReplication;
        HdfsServerConstants.BlockUCState penultimateBlockState;
        int nrCompleteBlocks;
        LOG.info((Object)("Recovering " + lease + ", src=" + src));
        assert (!this.isInSafeMode());
        assert (this.hasWriteLock());
        INodesInPath iip = this.dir.getLastINodeInPath(src);
        INodeFile pendingFile = iip.getINode(0).asFile();
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId());
            NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock != null && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        BlockInfo lastBlock = pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        if (penultimateBlock == null) {
            penultimateBlockState = HdfsServerConstants.BlockUCState.COMPLETE;
            penultimateBlockMinReplication = true;
        } else {
            penultimateBlockState = HdfsServerConstants.BlockUCState.COMMITTED;
            penultimateBlockMinReplication = this.blockManager.checkMinReplication(penultimateBlock);
        }
        assert (penultimateBlockState == HdfsServerConstants.BlockUCState.COMPLETE || penultimateBlockState == HdfsServerConstants.BlockUCState.COMMITTED) : "Unexpected state of penultimate block in " + src;
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId());
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated." + " Try again later.";
                NameNode.stateChangeLog.warn((Object)message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                BlockInfoUnderConstruction uc = (BlockInfoUnderConstruction)lastBlock;
                if (uc.getNumExpectedLocations() == 0) {
                    uc.setExpectedLocations(this.blockManager.getStorages(lastBlock));
                }
                if (uc.getNumExpectedLocations() == 0 && uc.getNumBytes() == 0L) {
                    pendingFile.removeLastBlock(lastBlock);
                    this.finalizeINodeFileUnderConstruction(src, pendingFile, iip.getLatestSnapshotId());
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Removed empty last block and closed file.");
                    return true;
                }
                long blockRecoveryId = this.nextGenerationStamp(this.isLegacyBlock(uc));
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                uc.initializeBlockRecovery(blockRecoveryId);
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed." + " Lease recovery is in progress. " + "RecoveryId = " + blockRecoveryId + " for block " + lastBlock));
            }
        }
        return false;
    }

    private LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFile pendingFile) {
        assert (this.hasWriteLock());
        if (newHolder == null) {
            return lease;
        }
        this.logReassignLease(lease.getHolder(), src, newHolder);
        return this.reassignLeaseInternal(lease, src, newHolder, pendingFile);
    }

    LeaseManager.Lease reassignLeaseInternal(LeaseManager.Lease lease, String src, String newHolder, INodeFile pendingFile) {
        assert (this.hasWriteLock());
        pendingFile.getFileUnderConstructionFeature().setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void commitOrCompleteLastBlock(INodeFile fileINode, Block commitBlock) throws IOException {
        assert (this.hasWriteLock());
        Preconditions.checkArgument((boolean)fileINode.isUnderConstruction());
        if (!this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock)) {
            return;
        }
        long diff = fileINode.getPreferredBlockSize() - commitBlock.getNumBytes();
        if (diff > 0L) {
            try {
                String path = fileINode.getFullPathName();
                this.dir.updateSpaceConsumed(path, 0L, -diff * (long)fileINode.getFileReplication());
            }
            catch (IOException e) {
                LOG.warn((Object)"Unexpected exception while updating disk space.", (Throwable)e);
            }
        }
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFile pendingFile, int latestSnapshot) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        FileUnderConstructionFeature uc = pendingFile.getFileUnderConstructionFeature();
        Preconditions.checkArgument((uc != null ? 1 : 0) != 0);
        this.leaseManager.removeLease(uc.getClientName(), src);
        pendingFile = pendingFile.recordModification(latestSnapshot);
        INodeFile newFile = pendingFile.toCompleteFile(Time.now());
        this.dir.closeFile(src, newFile);
        this.blockManager.checkReplication(newFile);
    }

    @VisibleForTesting
    BlockInfo getStoredBlock(Block block) {
        return this.blockManager.getStoredBlock(block);
    }

    @Override
    public boolean isInSnapshot(BlockInfoUnderConstruction blockUC) {
        assert (this.hasReadLock());
        BlockCollection bc = blockUC.getBlockCollection();
        if (bc == null || !(bc instanceof INodeFile) || !((INodeFile)bc).isUnderConstruction()) {
            return false;
        }
        INodeFile inodeUC = (INodeFile)bc;
        String fullName = inodeUC.getName();
        try {
            if (fullName != null && fullName.startsWith("/") && this.dir.getINode(fullName) == inodeUC) {
                return false;
            }
        }
        catch (UnresolvedLinkException e) {
            LOG.error((Object)("Error while resolving the link : " + fullName), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitBlockSynchronization(ExtendedBlock lastblock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException, UnresolvedLinkException {
        LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")"));
        this.checkOperation(NameNode.OperationCategory.WRITE);
        String src = "";
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot commitBlockSynchronization while in safe mode");
            BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock(lastblock));
            if (storedBlock == null) {
                if (deleteblock) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Block (=" + lastblock + ") not found"));
                    }
                    return;
                }
                throw new IOException("Block (=" + lastblock + ") not found");
            }
            INodeFile iFile = ((INode)((Object)storedBlock.getBlockCollection())).asFile();
            if (!iFile.isUnderConstruction() || storedBlock.isComplete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unexpected block (=" + lastblock + ") since the file (=" + iFile.getLocalName() + ") is not under construction"));
                }
                return;
            }
            long recoveryId = ((BlockInfoUnderConstruction)storedBlock).getBlockRecoveryId();
            if (recoveryId != newgenerationstamp) {
                throw new IOException("The recovery id " + newgenerationstamp + " does not match current recovery id " + recoveryId + " for block " + lastblock);
            }
            if (deleteblock) {
                Block blockToDel = ExtendedBlock.getLocalBlock(lastblock);
                boolean remove = iFile.removeLastBlock(blockToDel);
                if (remove) {
                    this.blockManager.removeBlockFromMap(storedBlock);
                }
            } else {
                int i;
                storedBlock.setGenerationStamp(newgenerationstamp);
                storedBlock.setNumBytes(newlength);
                ArrayList<DatanodeDescriptor> trimmedTargets = new ArrayList<DatanodeDescriptor>(newtargets.length);
                ArrayList<String> trimmedStorages = new ArrayList<String>(newtargets.length);
                if (newtargets.length > 0) {
                    for (i = 0; i < newtargets.length; ++i) {
                        DatanodeDescriptor targetNode = this.blockManager.getDatanodeManager().getDatanode(newtargets[i]);
                        if (targetNode != null) {
                            trimmedTargets.add(targetNode);
                            trimmedStorages.add(newtargetstorages[i]);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("DatanodeDescriptor (=" + newtargets[i] + ") not found"));
                    }
                }
                if (closeFile && !trimmedTargets.isEmpty()) {
                    for (i = 0; i < trimmedTargets.size(); ++i) {
                        ((DatanodeDescriptor)trimmedTargets.get(i)).addBlock((String)trimmedStorages.get(i), storedBlock);
                    }
                }
                DatanodeStorageInfo[] trimmedStorageInfos = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(trimmedTargets.toArray(new DatanodeID[trimmedTargets.size()]), trimmedStorages.toArray(new String[trimmedStorages.size()]));
                iFile.setLastBlock(storedBlock, trimmedStorageInfos);
            }
            src = closeFile ? this.closeFileCommitBlocks(iFile, storedBlock) : this.persistBlocks(iFile, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (closeFile) {
            LOG.info((Object)("commitBlockSynchronization(newblock=" + lastblock + ", file=" + src + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
        } else {
            LOG.info((Object)("commitBlockSynchronization(" + lastblock + ") successful"));
        }
    }

    @VisibleForTesting
    String closeFileCommitBlocks(INodeFile pendingFile, BlockInfo storedBlock) throws IOException {
        String src = pendingFile.getFullPathName();
        this.commitOrCompleteLastBlock(pendingFile, storedBlock);
        this.finalizeINodeFileUnderConstruction(src, pendingFile, Snapshot.findLatestSnapshot(pendingFile, 0x7FFFFFFE));
        return src;
    }

    @VisibleForTesting
    String persistBlocks(INodeFile pendingFile, boolean logRetryCache) throws IOException {
        String src = pendingFile.getFullPathName();
        this.dir.persistBlocks(src, pendingFile, logRetryCache);
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewLease(String holder) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot renew lease for " + holder);
            this.leaseManager.renewLease(holder);
        }
        finally {
            this.readUnlock();
        }
    }

    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, UnresolvedLinkException, IOException {
        try {
            return this.getListingInt(src, startAfter, needLocation);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listStatus", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryListing getListingInt(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, UnresolvedLinkException, IOException {
        DirectoryListing dl;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        String startAfterString = new String(startAfter);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            if (FSDirectory.isReservedName(startAfterString)) {
                byte[][] startAfterComponents = FSDirectory.getPathComponentsForReservedPath(startAfterString);
                try {
                    String tmp = FSDirectory.resolvePath(src, startAfterComponents, this.dir);
                    byte[][] regularPath = INode.getPathComponents(tmp);
                    startAfter = regularPath[regularPath.length - 1];
                }
                catch (IOException e) {
                    throw new DirectoryListingStartAfterNotFoundException("Can't find startAfter " + startAfterString);
                }
            }
            if (this.isPermissionEnabled) {
                if (this.dir.isDir(src)) {
                    this.checkPathAccess(pc, src, FsAction.READ_EXECUTE);
                } else {
                    this.checkTraverse(pc, src);
                }
            }
            this.logAuditEvent(true, "listStatus", src);
            dl = this.dir.getListing(src, startAfter, needLocation);
        }
        finally {
            this.readUnlock();
        }
        return dl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.writeLock();
        try {
            this.getBlockManager().getDatanodeManager().registerDatanode(nodeReg);
            this.checkSafeMode();
        }
        finally {
            this.writeUnlock();
        }
    }

    String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage.getStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeartbeatResponse handleHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes) throws IOException {
        this.readLock();
        try {
            int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
            DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, reports, this.blockPoolId, cacheCapacity, cacheUsed, xceiverCount, maxTransfer, failedVolumes);
            NNHAStatusHeartbeat haState = new NNHAStatusHeartbeat(this.haContext.getState().getServiceState(), this.getFSImage().getLastAppliedOrWrittenTxId());
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(cmds, haState, this.rollingUpgradeInfo);
            return heartbeatResponse;
        }
        finally {
            this.readUnlock();
        }
    }

    boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    void checkAvailableResources() {
        Preconditions.checkState((this.nnResourceChecker != null ? 1 : 0) != 0, (Object)"nnResourceChecker not initialized");
        this.hasResourcesAvailable = this.nnResourceChecker.hasAvailableDiskSpace();
    }

    public FSImage getFSImage() {
        return this.dir.fsImage;
    }

    public FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    private void checkBlock(ExtendedBlock block) throws IOException {
        if (block != null && !this.blockPoolId.equals(block.getBlockPoolId())) {
            throw new IOException("Unexpected BlockPoolId " + block.getBlockPoolId() + " - expected " + this.blockPoolId);
        }
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"})
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    @Metric(value={"TransactionsSinceLastCheckpoint", "Number of transactions since last checkpoint"})
    public long getTransactionsSinceLastCheckpoint() {
        return this.getEditLog().getLastWrittenTxId() - this.getFSImage().getStorage().getMostRecentCheckpointTxId();
    }

    @Metric(value={"TransactionsSinceLastLogRoll", "Number of transactions since last edit log roll"})
    public long getTransactionsSinceLastLogRoll() {
        if (this.isInStandbyState() || !this.getEditLog().isSegmentOpen()) {
            return 0L;
        }
        return this.getEditLog().getLastWrittenTxId() - this.getEditLog().getCurSegmentTxId() + 1L;
    }

    @Metric(value={"LastWrittenTransactionId", "Transaction ID written to the edit log"})
    public long getLastWrittenTransactionId() {
        return this.getEditLog().getLastWrittenTxId();
    }

    @Metric(value={"LastCheckpointTime", "Time in milliseconds since the epoch of the last checkpoint"})
    public long getLastCheckpointTime() {
        return this.getFSImage().getStorage().getMostRecentCheckpointTime();
    }

    long[] getStats() {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getUnderReplicatedBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        return stats;
    }

    @Override
    @Metric(value={"CapacityTotal", "Total raw capacity of data nodes in bytes"})
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric(value={"CapacityTotalGB", "Total raw capacity of data nodes in GB"})
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    @Metric(value={"CapacityUsed", "Total used capacity across all data nodes in bytes"})
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric(value={"CapacityUsedGB", "Total used capacity across all data nodes in GB"})
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    @Metric(value={"CapacityRemaining", "Remaining capacity in bytes"})
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Metric(value={"CapacityRemainingGB", "Remaining capacity in GB"})
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Metric(value={"CapacityUsedNonDFS", "Total space used by data nodes for non DFS purposes in bytes"})
    public long getCapacityUsedNonDFS() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    @Metric(value={"SnapshottableDirectories", "Number of snapshottable directories"})
    public int getNumSnapshottableDirs() {
        return this.snapshotManager.getNumSnapshottableDirs();
    }

    @Metric(value={"Snapshots", "The number of snapshots"})
    public int getNumSnapshots() {
        return this.snapshotManager.getNumSnapshots();
    }

    @Override
    public String getSnapshotStats() {
        HashMap<String, Integer> info = new HashMap<String, Integer>();
        info.put("SnapshottableDirectories", this.getNumSnapshottableDirs());
        info.put("Snapshots", this.getNumSnapshots());
        return JSON.toString(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        this.readLock();
        try {
            int n = this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
            DatanodeInfo[] arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo(results.get(i));
            }
            DatanodeInfo[] datanodeInfoArray = arr;
            return datanodeInfoArray;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNamespace() throws AccessControlException, IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image.");
            }
            this.getFSImage().saveNamespace(this);
            success = true;
        }
        finally {
            this.readUnlock();
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        LOG.info((Object)"New namespace image has been created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restoreFailedStorage(String arg) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            if (arg.equals("check")) {
                boolean bl = this.getFSImage().getStorage().getRestoreFailedStorage();
                return bl;
            }
            boolean val = arg.equals("true");
            this.getFSImage().getStorage().setRestoreFailedStorage(val);
            boolean bl = val;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    Date getStartTime() {
        return new Date(this.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.UNCHECKED);
            this.getFSImage().finalizeUpgrade(this.isHaEnabled() && this.inActiveState());
        }
        finally {
            this.writeUnlock();
        }
    }

    void refreshNodes() throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode();
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                    break;
                }
                default: {
                    LOG.error((Object)"Unexpected safe mode action");
                }
            }
        }
        return this.isInSafeMode();
    }

    @Override
    public void checkSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode != null) {
            safeMode.checkMode();
        }
    }

    @Override
    public boolean isInSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return safeMode.isOn();
    }

    @Override
    public boolean isInStartupSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow() && safeMode.isOn();
    }

    @Override
    public boolean isPopulatingReplQueues() {
        if (!this.shouldPopulateReplQueues()) {
            return false;
        }
        return this.initializedReplQueues;
    }

    private boolean shouldPopulateReplQueues() {
        if (this.haContext == null || this.haContext.getState() == null) {
            return false;
        }
        return this.haContext.getState().shouldPopulateReplQueues();
    }

    @Override
    public void incrementSafeBlockCount(int replication) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.incrementSafeBlockCount((short)replication);
    }

    @Override
    public void decrementSafeBlockCount(Block b) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        BlockInfo storedBlock = this.getStoredBlock(b);
        if (storedBlock.isComplete()) {
            safeMode.decrementSafeBlockCount((short)this.blockManager.countNodes(b).liveReplicas());
        }
    }

    @Override
    public void adjustSafeModeBlockTotals(int deltaSafe, int deltaTotal) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.adjustBlockTotals(deltaSafe, deltaTotal);
    }

    public void setBlockTotal() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.setBlockTotal((int)this.getCompleteBlocksTotal());
    }

    @Override
    @Metric
    public long getBlocksTotal() {
        return this.blockManager.getTotalBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCompleteBlocksTotal() {
        long numUCBlocks = 0L;
        this.readLock();
        try {
            for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
                for (String path : lease.getPaths()) {
                    INodeFile cons;
                    try {
                        cons = this.dir.getINode(path).asFile();
                        Preconditions.checkState((boolean)cons.isUnderConstruction());
                    }
                    catch (UnresolvedLinkException e) {
                        throw new AssertionError((Object)"Lease files should reside on this FS");
                    }
                    BlockInfo[] blocks = cons.getBlocks();
                    if (blocks == null) continue;
                    for (BlockInfo b : blocks) {
                        if (b.isComplete()) continue;
                        ++numUCBlocks;
                    }
                }
            }
            LOG.info((Object)("Number of blocks under construction: " + numUCBlocks));
            long l = this.getBlocksTotal() - numUCBlocks;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterSafeMode(boolean resourcesLow) throws IOException {
        this.writeLock();
        try {
            this.stopSecretManager();
            boolean isEditlogOpenForWrite = this.getEditLog().isOpenForWrite();
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            if (!this.isInSafeMode()) {
                this.safeMode = new SafeModeInfo(resourcesLow);
                return;
            }
            if (resourcesLow) {
                this.safeMode.setResourcesLow();
            } else {
                this.safeMode.setManual();
            }
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            NameNode.stateChangeLog.info((Object)("STATE* Safe mode is ON" + this.safeMode.getTurnOffTip()));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveSafeMode() {
        this.writeLock();
        try {
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF");
                return;
            }
            this.safeMode.leave();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSafeModeTip() {
        this.readLock();
        try {
            if (!this.isInSafeMode()) {
                String string = "";
                return string;
            }
            String string = this.safeMode.getTurnOffTip();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CheckpointSignature rollEditLog() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.JOURNAL);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.JOURNAL);
            this.checkNameNodeSafeMode("Log not rolled");
            if (Server.isRpcInvocation()) {
                LOG.info((Object)("Roll Edit Log from " + Server.getRemoteAddress()));
            }
            CheckpointSignature checkpointSignature = this.getFSImage().rollEditLog();
            return checkpointSignature;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamenodeCommand startCheckpoint(NamenodeRegistration backupNode, NamenodeRegistration activeNamenode) throws IOException {
        NamenodeCommand namenodeCommand;
        this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (NamenodeCommand)cacheEntry.getPayload();
        }
        this.writeLock();
        NamenodeCommand cmd = null;
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            this.checkNameNodeSafeMode("Checkpoint not started");
            LOG.info((Object)("Start checkpoint for " + backupNode.getAddress()));
            cmd = this.getFSImage().startCheckpoint(backupNode, activeNamenode);
            this.getEditLog().logSync();
            namenodeCommand = cmd;
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (cmd != null ? 1 : 0) != 0, (Object)cmd);
        }
        catch (Throwable throwable) {
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (cmd != null ? 1 : 0) != 0, cmd);
            throw throwable;
        }
        return namenodeCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncrementalBlockReport(DatanodeID nodeID, String poolId, StorageReceivedDeletedBlocks srdb) throws IOException {
        this.writeLock();
        try {
            this.blockManager.processIncrementalBlockReport(nodeID, srdb);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            this.checkNameNodeSafeMode("Checkpoint not ended");
            LOG.info((Object)("End checkpoint for " + registration.getAddress()));
            this.getFSImage().endCheckpoint(sig);
            success = true;
        }
        finally {
            this.readUnlock();
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    private void checkOwner(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, true, null, null, null, null);
    }

    private void checkPathAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, access, null);
    }

    private void checkParentAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, access, null, null);
    }

    private void checkAncestorAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, access, null, null, null);
    }

    private void checkTraverse(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, null, null);
    }

    @Override
    public void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        if (!pc.isSuperUser()) {
            this.dir.waitForReady();
            this.readLock();
            try {
                pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, resolveLink);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    @Override
    public long getMaxObjects() {
        return this.maxFsObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Metric
    public long getFilesTotal() {
        this.readLock();
        try {
            long l = this.dir.totalInodes();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    @Metric
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getUnderReplicatedBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getPendingDeletionBlocks() {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Metric
    public long getExcessBlocks() {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public long getPostponedMisreplicatedBlocks() {
        return this.blockManager.getPostponedMisreplicatedBlocksCount();
    }

    @Metric
    public int getPendingDataNodeMessageCount() {
        return this.blockManager.getPendingDataNodeMessageCount();
    }

    @Metric
    public String getHAState() {
        return this.haContext.getState().toString();
    }

    @Metric
    public long getMillisSinceLastLoadedEdits() {
        if (this.isInStandbyState() && this.editLogTailer != null) {
            return Time.now() - this.editLogTailer.getLastLoadTimestamp();
        }
        return 0L;
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info((Object)"Registered FSNamesystemState MBean");
    }

    void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
            this.mbeanName = null;
        }
        if (this.mxbeanName != null) {
            MBeans.unregister((ObjectName)this.mxbeanName);
            this.mxbeanName = null;
        }
        if (this.dir != null) {
            this.dir.shutdown();
        }
        if (this.blockManager != null) {
            this.blockManager.shutdown();
        }
    }

    @Override
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    @Override
    public int getNumDecomLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        int liveDecommissioned = 0;
        for (DatanodeDescriptor node : live) {
            liveDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return liveDecommissioned;
    }

    @Override
    public int getNumDecomDeadDataNodes() {
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(null, dead, true);
        int deadDecommissioned = 0;
        for (DatanodeDescriptor node : dead) {
            deadDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return deadDecommissioned;
    }

    @Override
    public int getNumDecommissioningDataNodes() {
        return this.getBlockManager().getDatanodeManager().getDecommissioningNodes().size();
    }

    @Override
    @Metric(value={"StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat"})
    public int getNumStaleDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumStaleNodes();
    }

    void setGenerationStampV1(long stamp) {
        this.generationStampV1.setCurrentValue(stamp);
    }

    long getGenerationStampV1() {
        return this.generationStampV1.getCurrentValue();
    }

    void setGenerationStampV2(long stamp) {
        this.generationStampV2.setCurrentValue(stamp);
    }

    long getGenerationStampV2() {
        return this.generationStampV2.getCurrentValue();
    }

    long upgradeGenerationStampToV2() {
        Preconditions.checkState((this.generationStampV2.getCurrentValue() == 1000L ? 1 : 0) != 0);
        this.generationStampV2.skipTo(this.generationStampV1.getCurrentValue() + 0x10000000000L);
        this.generationStampV1Limit = this.generationStampV2.getCurrentValue();
        return this.generationStampV2.getCurrentValue();
    }

    void setGenerationStampV1Limit(long stamp) {
        Preconditions.checkState((this.generationStampV1Limit == 0L ? 1 : 0) != 0);
        this.generationStampV1Limit = stamp;
    }

    long getGenerationStampAtblockIdSwitch() {
        return this.generationStampV1Limit;
    }

    @VisibleForTesting
    SequentialBlockIdGenerator getBlockIdGenerator() {
        return this.blockIdGenerator;
    }

    void setLastAllocatedBlockId(long blockId) {
        this.blockIdGenerator.skipTo(blockId);
    }

    long getLastAllocatedBlockId() {
        return this.blockIdGenerator.getCurrentValue();
    }

    long nextGenerationStamp(boolean legacyBlock) throws IOException, SafeModeException {
        long gs;
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get next generation stamp");
        if (legacyBlock) {
            gs = this.getNextGenerationStampV1();
            this.getEditLog().logGenerationStampV1(gs);
        } else {
            gs = this.getNextGenerationStampV2();
            this.getEditLog().logGenerationStampV2(gs);
        }
        return gs;
    }

    @VisibleForTesting
    long getNextGenerationStampV1() throws IOException {
        long genStampV1 = this.generationStampV1.nextValue();
        if (genStampV1 >= this.generationStampV1Limit) {
            throw new OutOfV1GenerationStampsException();
        }
        return genStampV1;
    }

    @VisibleForTesting
    long getNextGenerationStampV2() {
        return this.generationStampV2.nextValue();
    }

    long getGenerationStampV1Limit() {
        return this.generationStampV1Limit;
    }

    boolean isLegacyBlock(Block block) {
        return block.getGenerationStamp() < this.getGenerationStampV1Limit();
    }

    private long nextBlockId() throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get next block ID");
        long blockId = this.blockIdGenerator.nextValue();
        this.getEditLog().logAllocateBlockId(blockId);
        return blockId;
    }

    private INodeFile checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        assert (this.hasWriteLock());
        this.checkNameNodeSafeMode("Cannot get a new generation stamp and an access token for block " + block);
        BlockInfo storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock(block));
        if (storedBlock == null || storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException(block + " does not exist or is not under Construction" + storedBlock);
        }
        INodeFile file = ((INode)((Object)storedBlock.getBlockCollection())).asFile();
        if (file == null || !file.isUnderConstruction()) {
            throw new IOException("The file " + storedBlock + " belonged to does not exist or it is not under construction.");
        }
        if (clientName == null || !clientName.equals(file.getFileUnderConstructionFeature().getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        NameNode.stateChangeLog.info((Object)"*DIR* reportBadBlocks");
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            for (int i = 0; i < blocks.length; ++i) {
                ExtendedBlock blk = blocks[i].getBlock();
                DatanodeInfo[] nodes = blocks[i].getLocations();
                String[] storageIDs = blocks[i].getStorageIDs();
                for (int j = 0; j < nodes.length; ++j) {
                    this.blockManager.findAndMarkBlockAsCorrupt(blk, nodes[j], storageIDs == null ? null : storageIDs[j], "client machine reported it");
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        LocatedBlock locatedBlock;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkUCBlock(block, clientName);
            block.setGenerationStamp(this.nextGenerationStamp(this.isLegacyBlock(block.getLocalBlock())));
            locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
            this.blockManager.setBlockToken(locatedBlock, BlockTokenSecretManager.AccessMode.WRITE);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        LOG.info((Object)("updatePipeline(block=" + oldBlock + ", newGenerationStamp=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", clientName=" + clientName + ")"));
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Pipeline not updated");
            assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
            this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes, newStorageIDs, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
        LOG.info((Object)("updatePipeline(" + oldBlock + ") successfully to " + newBlock));
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs, boolean logRetryCache) throws IOException {
        assert (this.hasWriteLock());
        INodeFile pendingFile = this.checkUCBlock(oldBlock, clientName);
        BlockInfoUnderConstruction blockinfo = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
        if (newBlock.getGenerationStamp() <= blockinfo.getGenerationStamp() || newBlock.getNumBytes() < blockinfo.getNumBytes()) {
            String msg = "Update " + oldBlock + " (len = " + blockinfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        blockinfo.setNumBytes(newBlock.getNumBytes());
        blockinfo.setGenerationStampAndVerifyReplicas(newBlock.getGenerationStamp());
        DatanodeStorageInfo[] storages = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(newNodes, newStorageIDs);
        blockinfo.setExpectedLocations(storages);
        String src = pendingFile.getFullPathName();
        this.dir.persistBlocks(src, pendingFile, logRetryCache);
    }

    void unprotectedChangeLease(String src, String dst) {
        assert (this.hasWriteLock());
        this.leaseManager.changeLease(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, INodeFile> getFilesUnderConstruction() {
        LeaseManager leaseManager = this.leaseManager;
        synchronized (leaseManager) {
            return this.leaseManager.getINodesUnderConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerBackupNode(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != bnReg.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)bnReg.getRole()) + " node namespaceID = " + bnReg.getNamespaceID());
            }
            if (bnReg.getRole() == HdfsServerConstants.NamenodeRole.BACKUP) {
                this.getFSImage().getEditLog().registerBackupNode(bnReg, nnReg);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBackupNode(NamenodeRegistration registration) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.getFSImage().getStorage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            this.getEditLog().releaseBackupStream(registration);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (!this.isPopulatingReplQueues()) {
                throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
            }
            int count = 0;
            ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
            Iterator<Block> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
            if (cookieTab == null) {
                cookieTab = new String[]{null};
            }
            int skip = FSNamesystem.getIntCookie(cookieTab[0]);
            for (int i = 0; i < skip && blkIterator.hasNext(); ++i) {
                blkIterator.next();
            }
            while (blkIterator.hasNext()) {
                String src;
                Block blk = blkIterator.next();
                INode inode = (INode)((Object)this.blockManager.getBlockCollection(blk));
                ++skip;
                if (inode == null || this.blockManager.countNodes(blk).liveReplicas() != 0 || !(src = FSDirectory.getFullPathName(inode)).startsWith(path)) continue;
                corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                if (++count < 100) continue;
                break;
            }
            cookieTab[0] = String.valueOf(skip);
            LOG.info((Object)("list corrupt file blocks returned: " + count));
            ArrayList<CorruptFileBlockInfo> arrayList = corruptFiles;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false), this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token token;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot issue delegation token");
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
            }
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                LOG.warn((Object)"trying to get DT with no secret manager running");
                Token<DelegationTokenIdentifier> token2 = null;
                return token2;
            }
            UserGroupInformation ugi = FSNamesystem.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
            token = new Token((TokenIdentifier)dtId, (SecretManager)this.dtSecretManager);
            long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
            this.getEditLog().logGetDelegationToken(dtId, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        long expiryTime;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot renew delegation token");
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
            }
            String renewer = FSNamesystem.getRemoteUser().getShortUserName();
            expiryTime = this.dtSecretManager.renewToken(token, renewer);
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields(in);
            this.getEditLog().logRenewDelegationToken(id, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot cancel delegation token");
            String canceller = FSNamesystem.getRemoteUser().getUserName();
            DelegationTokenIdentifier id = (DelegationTokenIdentifier)this.dtSecretManager.cancelToken(token, canceller);
            this.getEditLog().logCancelDelegationToken(id);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    DelegationTokenSecretManager.SecretManagerState saveSecretManagerState() {
        return this.dtSecretManager.saveSecretManagerState();
    }

    void loadSecretManagerStateCompat(DataInput in) throws IOException {
        this.dtSecretManager.loadSecretManagerStateCompat(in);
    }

    void loadSecretManagerState(FsImageProto.SecretManagerSection s, List<FsImageProto.SecretManagerSection.DelegationKey> keys, List<FsImageProto.SecretManagerSection.PersistToken> tokens) throws IOException {
        this.dtSecretManager.loadSecretManagerState(new DelegationTokenSecretManager.SecretManagerState(s, keys, tokens));
    }

    public void logUpdateMasterKey(DelegationKey key) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logUpdateMasterKey(key);
        this.getEditLog().logSync();
    }

    public void logExpireDelegationToken(DelegationTokenIdentifier id) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logCancelDelegationToken(id);
    }

    private void logReassignLease(String leaseHolder, String src, String newHolder) {
        assert (this.hasWriteLock());
        this.getEditLog().logReassignLease(leaseHolder, src, newHolder);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        return !UserGroupInformation.isSecurityEnabled() || this.getConnectionAuthenticationMethod().allowsDelegation();
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private boolean isExternalInvocation() {
        return Server.isRpcInvocation() || NamenodeWebHdfsMethods.isWebHdfsInvocation();
    }

    private static InetAddress getRemoteIp() {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            return ip;
        }
        return NamenodeWebHdfsMethods.getRemoteIp();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (this.isAuditEnabled()) {
            this.logAuditEvent(true, FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        this.mxbeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. " + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getCacheCapacity() {
        return this.datanodeStatistics.getCacheCapacity();
    }

    @Override
    public long getCacheUsed() {
        return this.datanodeStatistics.getCacheUsed();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    @Metric
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() {
        return this.getMissingBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        for (DatanodeDescriptor node : live) {
            ImmutableMap innerinfo = ImmutableMap.builder().put((Object)"infoAddr", (Object)node.getInfoAddr()).put((Object)"infoSecureAddr", (Object)node.getInfoSecureAddr()).put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"usedSpace", (Object)this.getDfsUsed(node)).put((Object)"adminState", (Object)node.getAdminState().toString()).put((Object)"nonDfsUsedSpace", (Object)node.getNonDfsUsed()).put((Object)"capacity", (Object)node.getCapacity()).put((Object)"numBlocks", (Object)node.numBlocks()).put((Object)"version", (Object)node.getSoftwareVersion()).put((Object)"used", (Object)node.getDfsUsed()).put((Object)"remaining", (Object)node.getRemaining()).put((Object)"blockScheduled", (Object)node.getBlocksScheduled()).put((Object)"blockPoolUsed", (Object)node.getBlockPoolUsed()).put((Object)"blockPoolUsedPercent", (Object)Float.valueOf(node.getBlockPoolUsedPercent())).put((Object)"volfails", (Object)node.getVolumeFailures()).build();
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, true);
        for (DatanodeDescriptor node : dead) {
            ImmutableMap innerinfo = ImmutableMap.builder().put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"decommissioned", (Object)node.isDecommissioned()).put((Object)"xferaddr", (Object)node.getXferAddr()).build();
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            ImmutableMap innerinfo = ImmutableMap.builder().put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"underReplicatedBlocks", (Object)node.decommissioningStatus.getUnderReplicatedBlocks()).put((Object)"decommissionOnlyReplicas", (Object)node.decommissioningStatus.getDecommissionOnlyReplicas()).put((Object)"underReplicateInOpenFiles", (Object)node.decommissioningStatus.getUnderReplicatedInOpenFiles()).build();
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (Time.now() - alivenode.getLastUpdate()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        return this.dir.fsImage.getStorage().getClusterID();
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    @Override
    public String getNameDirStatuses() {
        HashMap statusMap = new HashMap();
        HashMap<File, Storage.StorageDirType> activeDirs = new HashMap<File, Storage.StorageDirType>();
        Iterator<Storage.StorageDirectory> it = this.getFSImage().getStorage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory st = it.next();
            activeDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("active", activeDirs);
        List<Storage.StorageDirectory> removedStorageDirs = this.getFSImage().getStorage().getRemovedStorageDirs();
        HashMap<File, Storage.StorageDirType> failedDirs = new HashMap<File, Storage.StorageDirType>();
        for (Storage.StorageDirectory st : removedStorageDirs) {
            failedDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("failed", failedDirs);
        return JSON.toString(statusMap);
    }

    @Override
    public String getNodeUsage() {
        float median = 0.0f;
        float max = 0.0f;
        float min = 0.0f;
        float dev = 0.0f;
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        if (live.size() > 0) {
            float totalDfsUsed = 0.0f;
            float[] usages = new float[live.size()];
            int i = 0;
            for (DatanodeDescriptor dn : live) {
                usages[i++] = dn.getDfsUsedPercent();
                totalDfsUsed += dn.getDfsUsedPercent();
            }
            totalDfsUsed /= (float)live.size();
            Arrays.sort(usages);
            median = usages[usages.length / 2];
            max = usages[usages.length - 1];
            min = usages[0];
            for (i = 0; i < usages.length; ++i) {
                dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
            }
            dev = (float)Math.sqrt(dev / (float)usages.length);
        }
        HashMap<String, String> innerInfo = new HashMap<String, String>();
        innerInfo.put("min", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(min)}));
        innerInfo.put("median", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(median)}));
        innerInfo.put("max", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(max)}));
        innerInfo.put("stdDev", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(dev)}));
        info.put("nodeUsage", innerInfo);
        return JSON.toString(info);
    }

    @Override
    public String getNameJournalStatus() {
        ArrayList jasList = new ArrayList();
        FSEditLog log = this.getFSImage().getEditLog();
        if (log != null) {
            boolean openForWrite = log.isOpenForWrite();
            for (JournalSet.JournalAndStream jas : log.getJournals()) {
                HashMap<String, String> jasMap = new HashMap<String, String>();
                String manager = jas.getManager().toString();
                jasMap.put("required", String.valueOf(jas.isRequired()));
                jasMap.put("disabled", String.valueOf(jas.isDisabled()));
                jasMap.put("manager", manager);
                if (jas.isDisabled()) {
                    jasMap.put("stream", "Failed");
                } else if (openForWrite) {
                    EditLogOutputStream elos = jas.getCurrentStream();
                    if (elos != null) {
                        jasMap.put("stream", elos.generateReport());
                    } else {
                        jasMap.put("stream", "not currently writing");
                    }
                } else {
                    jasMap.put("stream", "open for read");
                }
                jasList.add(jasMap);
            }
        }
        return JSON.toString(jasList);
    }

    @Override
    public String getJournalTransactionInfo() {
        HashMap<String, String> txnIdMap = new HashMap<String, String>();
        txnIdMap.put("LastAppliedOrWrittenTxId", Long.toString(this.getFSImage().getLastAppliedOrWrittenTxId()));
        txnIdMap.put("MostRecentCheckpointTxId", Long.toString(this.getFSImage().getMostRecentCheckpointTxId()));
        return JSON.toString(txnIdMap);
    }

    @Override
    public String getNNStarted() {
        return this.getStartTime().toString();
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public FSDirectory getFSDirectory() {
        return this.dir;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public String getCorruptFiles() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks("/", null);
            int corruptFileCount = corruptFileBlocks.size();
            if (corruptFileCount != 0) {
                for (CorruptFileBlockInfo c : corruptFileBlocks) {
                    list.add(c.toString());
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Get corrupt file blocks returned error: " + e.getMessage()));
        }
        return JSON.toString(list);
    }

    @Override
    public int getDistinctVersionCount() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions().size();
    }

    @Override
    public Map<String, Integer> getDistinctVersions() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken, RetriableException {
        try {
            this.getDelegationTokenSecretManager().verifyToken(identifier, password);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.inTransitionToActive()) {
                throw new RetriableException((Exception)((Object)it));
            }
            throw it;
        }
    }

    @Override
    public boolean isGenStampInFuture(Block block) {
        if (this.isLegacyBlock(block)) {
            return block.getGenerationStamp() > this.getGenerationStampV1();
        }
        return block.getGenerationStamp() > this.getGenerationStampV2();
    }

    @VisibleForTesting
    public EditLogTailer getEditLogTailer() {
        return this.editLogTailer;
    }

    @VisibleForTesting
    public void setEditLogTailerForTests(EditLogTailer tailer) {
        this.editLogTailer = tailer;
    }

    @VisibleForTesting
    void setFsLockForTests(ReentrantReadWriteLock lock) {
        this.fsLock.coarseLock = lock;
    }

    @VisibleForTesting
    public ReentrantReadWriteLock getFsLockForTests() {
        return this.fsLock.coarseLock;
    }

    @VisibleForTesting
    public ReentrantLock getLongReadLockForTests() {
        return this.fsLock.longReadLock;
    }

    @VisibleForTesting
    public SafeModeInfo getSafeModeInfoForTests() {
        return this.safeMode;
    }

    @VisibleForTesting
    public void setNNResourceChecker(NameNodeResourceChecker nnResourceChecker) {
        this.nnResourceChecker = nnResourceChecker;
    }

    @Override
    public boolean isAvoidingStaleDataNodesForWrite() {
        return this.blockManager.getDatanodeManager().shouldAvoidStaleDataNodesForWrite();
    }

    @Override
    public int getNumDatanodesInService() {
        return this.getNumLiveDataNodes() - this.getNumDecomLiveDataNodes();
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allowSnapshot(String path) throws SafeModeException, IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot allow snapshot for " + path);
            this.checkSuperuserPrivilege();
            this.dir.writeLock();
            try {
                this.snapshotManager.setSnapshottable(path, true);
            }
            finally {
                this.dir.writeUnlock();
            }
            this.getEditLog().logAllowSnapshot(path);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "allowSnapshot", path, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disallowSnapshot(String path) throws SafeModeException, IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot disallow snapshot for " + path);
            this.checkSuperuserPrivilege();
            this.dir.writeLock();
            try {
                this.snapshotManager.resetSnapshottable(path);
            }
            finally {
                this.dir.writeUnlock();
            }
            this.getEditLog().logDisallowSnapshot(path);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "disallowSnapshot", path, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createSnapshot(String snapshotRoot, String snapshotName) throws SafeModeException, IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (String)cacheEntry.getPayload();
        }
        String snapshotPath = null;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot create snapshot for " + snapshotRoot);
            if (this.isPermissionEnabled) {
                this.checkOwner(pc, snapshotRoot);
            }
            if (snapshotName == null || snapshotName.isEmpty()) {
                snapshotName = Snapshot.generateDefaultSnapshotName();
            }
            if (snapshotName != null && !DFSUtil.isValidNameForComponent(snapshotName)) {
                throw new InvalidPathException("Invalid snapshot name: " + snapshotName);
            }
            this.dir.verifySnapshotName(snapshotName, snapshotRoot);
            this.dir.writeLock();
            try {
                snapshotPath = this.snapshotManager.createSnapshot(snapshotRoot, snapshotName);
            }
            finally {
                this.dir.writeUnlock();
            }
            this.getEditLog().logCreateSnapshot(snapshotRoot, snapshotName, cacheEntry != null);
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (snapshotPath != null ? 1 : 0) != 0, (Object)snapshotPath);
        }
        catch (Throwable throwable) {
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (snapshotPath != null ? 1 : 0) != 0, snapshotPath);
            throw throwable;
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "createSnapshot", snapshotRoot, snapshotPath, null);
        }
        return snapshotPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameSnapshot(String path, String snapshotOldName, String snapshotNewName) throws SafeModeException, IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot rename snapshot for " + path);
            if (this.isPermissionEnabled) {
                this.checkOwner(pc, path);
            }
            this.dir.verifySnapshotName(snapshotNewName, path);
            this.snapshotManager.renameSnapshot(path, snapshotOldName, snapshotNewName);
            this.getEditLog().logRenameSnapshot(path, snapshotOldName, snapshotNewName, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            String oldSnapshotRoot = Snapshot.getSnapshotPath(path, snapshotOldName);
            String newSnapshotRoot = Snapshot.getSnapshotPath(path, snapshotNewName);
            this.logAuditEvent(true, "renameSnapshot", oldSnapshotRoot, newSnapshotRoot, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        SnapshottableDirectoryStatus[] status = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker checker = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            String user = checker.isSuperUser() ? null : checker.getUser();
            status = this.snapshotManager.getSnapshottableDirListing(user);
        }
        finally {
            this.readUnlock();
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "listSnapshottableDirectory", null, null, null);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnapshotDiffReport getSnapshotDiffReport(String path, String fromSnapshot, String toSnapshot) throws IOException {
        INodeDirectorySnapshottable.SnapshotDiffInfo diffs = null;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (this.isPermissionEnabled) {
                this.checkSubtreeReadPermission(pc, path, fromSnapshot);
                this.checkSubtreeReadPermission(pc, path, toSnapshot);
            }
            diffs = this.snapshotManager.diff(path, fromSnapshot, toSnapshot);
        }
        finally {
            this.readUnlock();
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "computeSnapshotDiff", null, null, null);
        }
        return diffs != null ? diffs.generateReport() : new SnapshotDiffReport(path, fromSnapshot, toSnapshot, Collections.<SnapshotDiffReport.DiffReportEntry>emptyList());
    }

    private void checkSubtreeReadPermission(FSPermissionChecker pc, String snapshottablePath, String snapshot) throws AccessControlException, UnresolvedLinkException {
        String fromPath = snapshot == null ? snapshottablePath : Snapshot.getSnapshotPath(snapshottablePath, snapshot);
        this.checkPermission(pc, fromPath, false, null, null, FsAction.READ, FsAction.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSnapshot(String snapshotRoot, String snapshotName) throws SafeModeException, IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.getPermissionChecker();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot delete snapshot for " + snapshotRoot);
            if (this.isPermissionEnabled) {
                this.checkOwner(pc, snapshotRoot);
            }
            ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
            this.dir.writeLock();
            try {
                this.snapshotManager.deleteSnapshot(snapshotRoot, snapshotName, collectedBlocks, removedINodes);
                this.dir.removeFromInodeMap(removedINodes);
            }
            finally {
                this.dir.writeUnlock();
            }
            removedINodes.clear();
            this.getEditLog().logDeleteSnapshot(snapshotRoot, snapshotName, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
        this.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            String rootPath = Snapshot.getSnapshotPath(snapshotRoot, snapshotName);
            this.logAuditEvent(true, "deleteSnapshot", rootPath, null, null);
        }
    }

    void removeSnapshottableDirs(List<INodeDirectorySnapshottable> toRemove) {
        if (this.snapshotManager != null) {
            this.snapshotManager.removeSnapshottable(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RollingUpgradeInfo queryRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            if (this.rollingUpgradeInfo != null) {
                boolean hasRollbackImage = this.getFSImage().hasRollbackFSImage();
                this.rollingUpgradeInfo.setCreatedRollbackImages(hasRollbackImage);
            }
            RollingUpgradeInfo rollingUpgradeInfo = this.rollingUpgradeInfo;
            return rollingUpgradeInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RollingUpgradeInfo startRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            long startTime = Time.now();
            if (!this.haEnabled) {
                this.startRollingUpgradeInternalForNonHA(startTime);
            } else {
                this.checkNameNodeSafeMode("Failed to start rolling upgrade");
                this.startRollingUpgradeInternal(startTime);
            }
            this.getEditLog().logStartRollingUpgrade(this.rollingUpgradeInfo.getStartTime());
            if (this.haEnabled) {
                this.getFSImage().rollEditLog();
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "startRollingUpgrade", null, null, null);
        }
        return this.rollingUpgradeInfo;
    }

    void startRollingUpgradeInternal(long startTime) throws IOException {
        this.checkRollingUpgrade("start rolling upgrade");
        this.getFSImage().checkUpgrade(this);
        this.setRollingUpgradeInfo(false, startTime);
    }

    private void startRollingUpgradeInternalForNonHA(long startTime) throws IOException {
        Preconditions.checkState((!this.haEnabled ? 1 : 0) != 0);
        if (!this.isInSafeMode()) {
            throw new IOException("Safe mode should be turned ON in order to create namespace image.");
        }
        this.checkRollingUpgrade("start rolling upgrade");
        this.getFSImage().checkUpgrade(this);
        this.getFSImage().saveNamespace(this, NNStorage.NameNodeFile.IMAGE_ROLLBACK, null);
        LOG.info((Object)"Successfully saved namespace for preparing rolling upgrade.");
        this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.setRollingUpgradeInfo(true, startTime);
    }

    void setRollingUpgradeInfo(boolean createdRollbackImages, long startTime) {
        this.rollingUpgradeInfo = new RollingUpgradeInfo(this.blockPoolId, createdRollbackImages, startTime, 0L);
    }

    public void setCreatedRollbackImages(boolean created) {
        if (this.rollingUpgradeInfo != null) {
            this.rollingUpgradeInfo.setCreatedRollbackImages(created);
        }
    }

    public RollingUpgradeInfo getRollingUpgradeInfo() {
        return this.rollingUpgradeInfo;
    }

    public boolean isNeedRollbackFsImage() {
        return this.needRollbackFsImage;
    }

    public void setNeedRollbackFsImage(boolean needRollbackFsImage) {
        this.needRollbackFsImage = needRollbackFsImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        this.readLock();
        try {
            RollingUpgradeInfo upgradeInfo = this.getRollingUpgradeInfo();
            if (upgradeInfo != null) {
                RollingUpgradeInfo.Bean bean = new RollingUpgradeInfo.Bean(upgradeInfo);
                return bean;
            }
            RollingUpgradeInfo.Bean bean = null;
            return bean;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isRollingUpgrade() {
        return this.rollingUpgradeInfo != null;
    }

    void checkRollingUpgrade(String action) throws RollingUpgradeException {
        if (this.isRollingUpgrade()) {
            throw new RollingUpgradeException("Failed to " + action + " since a rolling upgrade is already in progress." + " Existing rolling upgrade info:\n" + this.rollingUpgradeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RollingUpgradeInfo finalizeRollingUpgrade() throws IOException {
        RollingUpgradeInfo returnInfo;
        this.checkSuperuserPrivilege();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Failed to finalize rolling upgrade");
            returnInfo = this.finalizeRollingUpgradeInternal(Time.now());
            this.getEditLog().logFinalizeRollingUpgrade(returnInfo.getFinalizeTime());
            this.getFSImage().saveNamespace(this);
            this.getFSImage().renameCheckpoint(NNStorage.NameNodeFile.IMAGE_ROLLBACK, NNStorage.NameNodeFile.IMAGE);
        }
        finally {
            this.writeUnlock();
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "finalizeRollingUpgrade", null, null, null);
        }
        return returnInfo;
    }

    RollingUpgradeInfo finalizeRollingUpgradeInternal(long finalizeTime) throws RollingUpgradeException {
        if (!this.isRollingUpgrade()) {
            throw new RollingUpgradeException("Failed to finalize rolling upgrade since there is no rolling upgrade in progress.");
        }
        long startTime = this.rollingUpgradeInfo.getStartTime();
        this.rollingUpgradeInfo = null;
        return new RollingUpgradeInfo(this.blockPoolId, false, startTime, finalizeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        Long result;
        boolean success;
        RetryCache.CacheEntryWithPayload cacheEntry;
        block9: {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
            cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache, null);
            if (cacheEntry != null && cacheEntry.isSuccess()) {
                return (Long)cacheEntry.getPayload();
            }
            success = false;
            if (!flags.contains((Object)CacheFlag.FORCE)) {
                this.cacheManager.waitForRescanIfNeeded();
            }
            this.writeLock();
            result = null;
            try {
                this.checkOperation(NameNode.OperationCategory.WRITE);
                if (this.isInSafeMode()) {
                    throw new SafeModeException("Cannot add cache directive", this.safeMode);
                }
                if (directive.getId() != null) {
                    throw new IOException("addDirective: you cannot specify an ID for this operation.");
                }
                CacheDirectiveInfo effectiveDirective = this.cacheManager.addDirective(directive, pc, flags);
                this.getEditLog().logAddCacheDirectiveInfo(effectiveDirective, cacheEntry != null);
                result = effectiveDirective.getId();
                success = true;
                this.writeUnlock();
                if (success) {
                    this.getEditLog().logSync();
                }
                if (!this.isAuditEnabled() || !this.isExternalInvocation()) break block9;
            }
            catch (Throwable throwable) {
                this.writeUnlock();
                if (success) {
                    this.getEditLog().logSync();
                }
                if (this.isAuditEnabled() && this.isExternalInvocation()) {
                    this.logAuditEvent(success, "addCacheDirective", null, null, null);
                }
                RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (boolean)success, result);
                throw throwable;
            }
            this.logAuditEvent(success, "addCacheDirective", null, null, null);
        }
        RetryCache.setState((RetryCache.CacheEntryWithPayload)cacheEntry, (boolean)success, (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        boolean success = false;
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        if (!flags.contains((Object)CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add cache directive", this.safeMode);
            }
            this.cacheManager.modifyDirective(directive, pc, flags);
            this.getEditLog().logModifyCacheDirectiveInfo(directive, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            if (success) {
                this.getEditLog().logSync();
            }
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "modifyCacheDirective", null, null, null);
            }
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCacheDirective(Long id) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot remove cache directives", this.safeMode);
            }
            this.cacheManager.removeDirective(id, pc);
            this.getEditLog().logRemoveCacheDirectiveInfo(id, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "removeCacheDirective", null, null, null);
            }
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(long startId, CacheDirectiveInfo filter) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> results;
        this.checkOperation(NameNode.OperationCategory.READ);
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        this.cacheManager.waitForRescanIfNeeded();
        this.readLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            results = this.cacheManager.listCacheDirectives(startId, filter, pc);
            success = true;
        }
        finally {
            this.readUnlock();
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "listCacheDirectives", null, null, null);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachePool(CachePoolInfo req) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add cache pool " + req.getPoolName(), this.safeMode);
            }
            if (pc != null) {
                pc.checkSuperuserPrivilege();
            }
            CachePoolInfo info = this.cacheManager.addCachePool(req);
            this.getEditLog().logAddCachePool(info, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "addCachePool", req.getPoolName(), null, null);
            }
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCachePool(CachePoolInfo req) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot modify cache pool " + req.getPoolName(), this.safeMode);
            }
            if (pc != null) {
                pc.checkSuperuserPrivilege();
            }
            this.cacheManager.modifyCachePool(req);
            this.getEditLog().logModifyCachePool(req, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "modifyCachePool", req.getPoolName(), null, null);
            }
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachePool(String cachePoolName) throws IOException {
        this.checkOperation(NameNode.OperationCategory.WRITE);
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion((RetryCache)this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        this.writeLock();
        boolean success = false;
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot remove cache pool " + cachePoolName, this.safeMode);
            }
            if (pc != null) {
                pc.checkSuperuserPrivilege();
            }
            this.cacheManager.removeCachePool(cachePoolName);
            this.getEditLog().logRemoveCachePool(cachePoolName, cacheEntry != null);
            success = true;
        }
        finally {
            this.writeUnlock();
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "removeCachePool", cachePoolName, null, null);
            }
            RetryCache.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> results;
        FSPermissionChecker pc = this.isPermissionEnabled ? this.getPermissionChecker() : null;
        this.checkOperation(NameNode.OperationCategory.READ);
        boolean success = false;
        this.cacheManager.waitForRescanIfNeeded();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            results = this.cacheManager.listCachePools(pc, prevKey);
            success = true;
        }
        finally {
            this.readUnlock();
            if (this.isAuditEnabled() && this.isExternalInvocation()) {
                this.logAuditEvent(success, "listCachePools", null, null, null);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot modify ACL entries on " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            this.dir.modifyAclEntries(src, aclSpec);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "modifyAclEntries", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove ACL entries on " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            this.dir.removeAclEntries(src, aclSpec);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeAclEntries", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDefaultAcl(String src) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove default ACL entries on " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            this.dir.removeDefaultAcl(src);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeDefaultAcl", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcl(String src) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot remove ACL on " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            this.dir.removeAcl(src);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "removeAcl", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.WRITE);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkNameNodeSafeMode("Cannot set ACL on " + src);
            src = FSDirectory.resolvePath(src, pathComponents, this.dir);
            this.checkOwner(pc, src);
            this.dir.setAcl(src, aclSpec);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setAcl", src, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AclStatus getAclStatus(String src) throws IOException {
        this.aclConfigFlag.checkForApiCall();
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkOperation(NameNode.OperationCategory.READ);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, null, null, null);
            }
            AclStatus aclStatus = this.dir.getAclStatus(src);
            return aclStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    private static void enableAsyncAuditLog() {
        if (!(auditLog instanceof Log4JLogger)) {
            LOG.warn((Object)"Log4j is required to enable async auditlog");
            return;
        }
        Logger logger = ((Log4JLogger)auditLog).getLogger();
        ArrayList<Appender> appenders = Collections.list(logger.getAllAppenders());
        if (!appenders.isEmpty() && !(appenders.get(0) instanceof AsyncAppender)) {
            AsyncAppender asyncAppender = new AsyncAppender();
            for (Appender appender : appenders) {
                logger.removeAppender(appender);
                asyncAppender.addAppender(appender);
            }
            logger.addAppender((Appender)asyncAppender);
        }
    }

    private static class DefaultAuditLogger
    extends HdfsAuditLogger {
        private boolean logTokenTrackingId;

        private DefaultAuditLogger() {
        }

        @Override
        public void initialize(Configuration conf) {
            this.logTokenTrackingId = conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false);
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            if (auditLog.isInfoEnabled()) {
                StringBuilder sb = (StringBuilder)auditBuffer.get();
                sb.setLength(0);
                sb.append("allowed=").append(succeeded).append("\t");
                sb.append("ugi=").append(userName).append("\t");
                sb.append("ip=").append(addr).append("\t");
                sb.append("cmd=").append(cmd).append("\t");
                sb.append("src=").append(src).append("\t");
                sb.append("dst=").append(dst).append("\t");
                if (null == status) {
                    sb.append("perm=null");
                } else {
                    sb.append("perm=");
                    sb.append(status.getOwner()).append(":");
                    sb.append(status.getGroup()).append(":");
                    sb.append(status.getPermission());
                }
                if (this.logTokenTrackingId) {
                    sb.append("\t").append("trackingId=");
                    String trackingId = null;
                    if (ugi != null && dtSecretManager != null && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.TOKEN) {
                        for (TokenIdentifier tid : ugi.getTokenIdentifiers()) {
                            if (!(tid instanceof DelegationTokenIdentifier)) continue;
                            DelegationTokenIdentifier dtid = (DelegationTokenIdentifier)tid;
                            trackingId = dtSecretManager.getTokenTrackingId(dtid);
                            break;
                        }
                    }
                    sb.append(trackingId);
                }
                this.logAuditMessage(sb.toString());
            }
        }

        public void logAuditMessage(String message) {
            auditLog.info((Object)message);
        }
    }

    static class CorruptFileBlockInfo {
        final String path;
        final Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning) {
                FSNamesystem.this.writeLock();
                try {
                    if (FSNamesystem.this.safeMode == null) break;
                    if (FSNamesystem.this.safeMode.canLeave()) {
                        FSNamesystem.this.safeMode.leave();
                        FSNamesystem.this.smmthread = null;
                        break;
                    }
                }
                finally {
                    FSNamesystem.this.writeUnlock();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!FSNamesystem.this.fsRunning) {
                LOG.info((Object)"NameNode is being shutdown, exit SafeModeMonitor thread");
            }
        }
    }

    public class SafeModeInfo {
        private final double threshold;
        private final int datanodeThreshold;
        private int extension;
        private final int safeReplication;
        private final double replQueueThreshold;
        private long reached = -1L;
        int blockTotal;
        int blockSafe;
        private int blockThreshold;
        private int blockReplQueueThreshold;
        private long lastStatusReport = 0L;
        private boolean resourcesLow = false;
        private boolean shouldIncrementallyTrackBlocks = false;
        private StartupProgress.Counter awaitingReportedBlocksCounter;

        private SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn((Object)("The threshold value should't be greater than 1, threshold: " + this.threshold));
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.namenode.replication.min", 1);
            LOG.info((Object)("dfs.namenode.safemode.threshold-pct = " + this.threshold));
            LOG.info((Object)("dfs.namenode.safemode.min.datanodes = " + this.datanodeThreshold));
            LOG.info((Object)("dfs.namenode.safemode.extension     = " + this.extension));
            this.replQueueThreshold = conf.getFloat("dfs.namenode.replqueue.threshold-pct", (float)this.threshold);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private boolean shouldIncrementallyTrackBlocks() {
            return this.shouldIncrementallyTrackBlocks;
        }

        private SafeModeInfo(boolean resourcesLow) {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.replQueueThreshold = 1.5;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.resourcesLow = resourcesLow;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        private synchronized boolean isOn() {
            this.doConsistencyCheck();
            return this.reached >= 0L;
        }

        private void enter() {
            this.reached = 0L;
        }

        private synchronized void leave() {
            if (!FSNamesystem.this.isPopulatingReplQueues() && FSNamesystem.this.shouldPopulateReplQueues()) {
                FSNamesystem.this.initializeReplQueues();
            }
            long timeInSafemode = Time.now() - FSNamesystem.this.startTime;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs"));
            NameNode.getNameNodeMetrics().setSafeModeTime((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NetworkTopology nt = FSNamesystem.this.blockManager.getDatanodeManager().getNetworkTopology();
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + nt.getNumOfRacks() + " racks and " + nt.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.numOfUnderReplicatedBlocks() + " blocks"));
            FSNamesystem.this.startSecretManagerIfNecessary();
            StartupProgress prog = NameNode.getStartupProgress();
            if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                prog.endStep(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                prog.endPhase(Phase.SAFEMODE);
            }
        }

        private synchronized boolean canInitializeReplQueues() {
            return FSNamesystem.this.shouldPopulateReplQueues() && this.blockSafe >= this.blockReplQueueThreshold;
        }

        private synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (Time.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON, in safe mode extension.", false);
                return false;
            }
            if (this.needEnter()) {
                this.reportStatus("STATE* Safe mode ON, thresholds not met.", false);
                return false;
            }
            return true;
        }

        private boolean needEnter() {
            return this.threshold != 0.0 && this.blockSafe < this.blockThreshold || this.datanodeThreshold != 0 && FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold || !FSNamesystem.this.nameNodeHasResourcesAvailable();
        }

        private void checkMode() {
            assert (FSNamesystem.this.hasWriteLock());
            if (FSNamesystem.this.smmthread == null && this.needEnter()) {
                this.enter();
                if (this.canInitializeReplQueues() && !FSNamesystem.this.isPopulatingReplQueues() && !FSNamesystem.this.haEnabled) {
                    FSNamesystem.this.initializeReplQueues();
                }
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave();
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = Time.now();
            if (FSNamesystem.this.smmthread == null) {
                FSNamesystem.this.smmthread = new Daemon((Runnable)new SafeModeMonitor());
                FSNamesystem.this.smmthread.start();
                this.reportStatus("STATE* Safe mode extension entered.", true);
            }
            if (this.canInitializeReplQueues() && !FSNamesystem.this.isPopulatingReplQueues() && !FSNamesystem.this.haEnabled) {
                FSNamesystem.this.initializeReplQueues();
            }
        }

        private synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.blockThreshold = (int)((double)this.blockTotal * this.threshold);
            this.blockReplQueueThreshold = (int)((double)this.blockTotal * this.replQueueThreshold);
            if (FSNamesystem.this.haEnabled) {
                this.shouldIncrementallyTrackBlocks = true;
            }
            if (this.blockSafe < 0) {
                this.blockSafe = 0;
            }
            this.checkMode();
        }

        private synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
                StartupProgress prog = NameNode.getStartupProgress();
                if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                    if (this.awaitingReportedBlocksCounter == null) {
                        this.awaitingReportedBlocksCounter = prog.getCounter(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                    }
                    this.awaitingReportedBlocksCounter.increment();
                }
                this.checkMode();
            }
        }

        private synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
                assert (this.blockSafe >= 0 || this.isManual() || this.areResourcesLow());
                this.checkMode();
            }
        }

        private boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        private synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        private boolean areResourcesLow() {
            return this.resourcesLow;
        }

        private void setResourcesLow() {
            this.resourcesLow = true;
        }

        String getTurnOffTip() {
            if (!this.isOn()) {
                return "Safe mode is OFF.";
            }
            String adminMsg = "It was turned on manually. ";
            if (this.areResourcesLow()) {
                adminMsg = "Resources are low on NN. Please add or free up more resources then turn off safe mode manually. NOTE:  If you turn off safe mode before adding resources, the NN will immediately return to safe mode. ";
            }
            if (this.isManual() || this.areResourcesLow()) {
                return adminMsg + "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off.";
            }
            boolean thresholdsMet = true;
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            if (this.blockSafe < this.blockThreshold) {
                msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.\n", this.blockSafe, this.blockThreshold - this.blockSafe + 1, this.threshold, this.blockTotal);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", this.blockSafe, this.threshold, this.blockTotal);
            }
            if (numLive < this.datanodeThreshold) {
                msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.\n", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The number of live datanodes %d has reached the minimum number %d. ", numLive, this.datanodeThreshold);
            }
            msg = msg + (this.reached > 0L ? "In safe mode extension. " : "");
            msg = msg + "Safe mode will be turned off automatically ";
            msg = !thresholdsMet ? msg + "once the thresholds have been reached." : (this.reached + (long)this.extension - Time.now() > 0L ? msg + "in " + (this.reached + (long)this.extension - Time.now()) / 1000L + " seconds." : msg + "soon.");
            return msg;
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = Time.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe blocks = " + this.blockSafe + ". Target blocks = " + this.blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        private void doConsistencyCheck() {
            boolean assertsOn = false;
            if (!$assertionsDisabled) {
                assertsOn = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!assertsOn) {
                return;
            }
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return;
            }
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            if (this.blockTotal != activeBlocks && (this.blockSafe < 0 || this.blockSafe > this.blockTotal)) {
                throw new AssertionError((Object)(" SafeMode: Inconsistent filesystem state: SafeMode data: blockTotal=" + this.blockTotal + " blockSafe=" + this.blockSafe + "; " + "BlockManager data: active=" + activeBlocks));
            }
        }

        private synchronized void adjustBlockTotals(int deltaSafe, int deltaTotal) {
            if (!this.shouldIncrementallyTrackBlocks) {
                return;
            }
            assert (FSNamesystem.this.haEnabled);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adjusting block totals from " + this.blockSafe + "/" + this.blockTotal + " to " + (this.blockSafe + deltaSafe) + "/" + (this.blockTotal + deltaTotal)));
            }
            assert (this.blockSafe + deltaSafe >= 0) : "Can't reduce blockSafe " + this.blockSafe + " by " + deltaSafe + ": would be negative";
            assert (this.blockTotal + deltaTotal >= 0) : "Can't reduce blockTotal " + this.blockTotal + " by " + deltaTotal + ": would be negative";
            this.blockSafe += deltaSafe;
            this.setBlockTotal(this.blockTotal + deltaTotal);
        }
    }

    class NameNodeEditLogRoller
    implements Runnable {
        private boolean shouldRun = true;
        private final long rollThreshold;
        private final long sleepIntervalMs;

        public NameNodeEditLogRoller(long rollThreshold, int sleepIntervalMs) {
            this.rollThreshold = rollThreshold;
            this.sleepIntervalMs = sleepIntervalMs;
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && this.shouldRun) {
                try {
                    FSEditLog editLog = FSNamesystem.this.getFSImage().getEditLog();
                    long numEdits = editLog.getLastWrittenTxId() - editLog.getCurSegmentTxId();
                    if (numEdits > this.rollThreshold) {
                        LOG.info((Object)("NameNode rolling its own edit log because number of edits in open segment exceeds threshold of " + this.rollThreshold));
                        FSNamesystem.this.rollEditLog();
                    }
                    Thread.sleep(this.sleepIntervalMs);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)(NameNodeEditLogRoller.class.getSimpleName() + " was interrupted, exiting"));
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)("Swallowing exception in " + NameNodeEditLogRoller.class.getSimpleName() + ":"), (Throwable)e);
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        boolean shouldNNRmRun = true;

        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning && this.shouldNNRmRun) {
                    FSNamesystem.this.checkAvailableResources();
                    if (!FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode low on available disk space. ";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn((Object)(lowResourcesMsg + "Entering safe mode."));
                        } else {
                            LOG.warn((Object)(lowResourcesMsg + "Already in safe mode."));
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldNNRmRun = false;
        }
    }
}

