/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockInfoUnderConstruction {
    @Test
    public void testInitializeBlockRecovery() throws Exception {
        DatanodeStorageInfo s1 = DFSTestUtil.createDatanodeStorageInfo("10.10.1.1", "s1");
        DatanodeDescriptor dd1 = s1.getDatanodeDescriptor();
        DatanodeStorageInfo s2 = DFSTestUtil.createDatanodeStorageInfo("10.10.1.2", "s2");
        DatanodeDescriptor dd2 = s2.getDatanodeDescriptor();
        DatanodeStorageInfo s3 = DFSTestUtil.createDatanodeStorageInfo("10.10.1.3", "s3");
        DatanodeDescriptor dd3 = s3.getDatanodeDescriptor();
        dd3.isAlive = true;
        dd2.isAlive = true;
        dd1.isAlive = true;
        BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(new Block(0L, 0L, 1000L), 3, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, new DatanodeStorageInfo[]{s1, s2, s3});
        long currentTime = System.currentTimeMillis();
        dd1.setLastUpdate(currentTime - 3000L);
        dd2.setLastUpdate(currentTime - 1000L);
        dd3.setLastUpdate(currentTime - 2000L);
        blockInfo.initializeBlockRecovery(1L);
        BlockInfoUnderConstruction[] blockInfoRecovery = dd2.getLeaseRecoveryCommand(1);
        Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
        currentTime = System.currentTimeMillis();
        dd1.setLastUpdate(currentTime - 2000L);
        dd2.setLastUpdate(currentTime - 1000L);
        dd3.setLastUpdate(currentTime - 3000L);
        blockInfo.initializeBlockRecovery(2L);
        blockInfoRecovery = dd1.getLeaseRecoveryCommand(1);
        Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
        currentTime = System.currentTimeMillis();
        dd1.setLastUpdate(currentTime - 2000L);
        dd2.setLastUpdate(currentTime - 1000L);
        dd3.setLastUpdate(currentTime - 3000L);
        currentTime = System.currentTimeMillis();
        blockInfo.initializeBlockRecovery(3L);
        blockInfoRecovery = dd3.getLeaseRecoveryCommand(1);
        Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
        currentTime = System.currentTimeMillis();
        dd1.setLastUpdate(currentTime - 2000L);
        dd2.setLastUpdate(currentTime - 1000L);
        dd3.setLastUpdate(currentTime);
        currentTime = System.currentTimeMillis();
        blockInfo.initializeBlockRecovery(3L);
        blockInfoRecovery = dd3.getLeaseRecoveryCommand(1);
        Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
    }
}

