/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig"})
@InterfaceStability.Unstable
public class MiniDFSNNTopology {
    private final List<NSConf> nameservices = Lists.newArrayList();
    private boolean federation;

    public static MiniDFSNNTopology simpleSingleNN(int nameNodePort, int nameNodeHttpPort) {
        return new MiniDFSNNTopology().addNameservice(new NSConf(null).addNN(new NNConf(null).setHttpPort(nameNodeHttpPort).setIpcPort(nameNodePort)));
    }

    public static MiniDFSNNTopology simpleHATopology() {
        return new MiniDFSNNTopology().addNameservice(new NSConf("minidfs-ns").addNN(new NNConf("nn1")).addNN(new NNConf("nn2")));
    }

    public static MiniDFSNNTopology simpleFederatedTopology(int numNameservices) {
        MiniDFSNNTopology topology = new MiniDFSNNTopology();
        for (int i = 1; i <= numNameservices; ++i) {
            topology.addNameservice(new NSConf("ns" + i).addNN(new NNConf(null)));
        }
        topology.setFederation(true);
        return topology;
    }

    public static MiniDFSNNTopology simpleHAFederatedTopology(int numNameservices) {
        MiniDFSNNTopology topology = new MiniDFSNNTopology();
        for (int i = 0; i < numNameservices; ++i) {
            topology.addNameservice(new NSConf("ns" + i).addNN(new NNConf("nn0")).addNN(new NNConf("nn1")));
        }
        topology.setFederation(true);
        return topology;
    }

    public MiniDFSNNTopology setFederation(boolean federation) {
        this.federation = federation;
        return this;
    }

    public MiniDFSNNTopology addNameservice(NSConf nameservice) {
        Preconditions.checkArgument((!nameservice.getNNs().isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one NN in a nameservice");
        this.nameservices.add(nameservice);
        return this;
    }

    public int countNameNodes() {
        int count = 0;
        for (NSConf ns : this.nameservices) {
            count += ns.nns.size();
        }
        return count;
    }

    public NNConf getOnlyNameNode() {
        Preconditions.checkState((this.countNameNodes() == 1 ? 1 : 0) != 0, (Object)"must have exactly one NN!");
        return this.nameservices.get(0).getNNs().get(0);
    }

    public boolean isFederated() {
        return this.nameservices.size() > 1 || this.federation;
    }

    public boolean isHA() {
        for (NSConf ns : this.nameservices) {
            if (ns.getNNs().size() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean allHttpPortsSpecified() {
        for (NSConf ns : this.nameservices) {
            for (NNConf nn : ns.getNNs()) {
                if (nn.getHttpPort() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allIpcPortsSpecified() {
        for (NSConf ns : this.nameservices) {
            for (NNConf nn : ns.getNNs()) {
                if (nn.getIpcPort() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public List<NSConf> getNameservices() {
        return this.nameservices;
    }

    public static class NNConf {
        private final String nnId;
        private int httpPort;
        private int ipcPort;
        private String clusterId;

        public NNConf(String nnId) {
            this.nnId = nnId;
        }

        String getNnId() {
            return this.nnId;
        }

        int getIpcPort() {
            return this.ipcPort;
        }

        int getHttpPort() {
            return this.httpPort;
        }

        String getClusterId() {
            return this.clusterId;
        }

        public NNConf setHttpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public NNConf setIpcPort(int ipcPort) {
            this.ipcPort = ipcPort;
            return this;
        }

        public NNConf setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }
    }

    public static class NSConf {
        private final String id;
        private final List<NNConf> nns = Lists.newArrayList();

        public NSConf(String id) {
            this.id = id;
        }

        public NSConf addNN(NNConf nn) {
            this.nns.add(nn);
            return this;
        }

        public String getId() {
            return this.id;
        }

        public List<NNConf> getNNs() {
            return this.nns;
        }
    }
}

