/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.AclException;

final class AclConfigFlag {
    private final boolean enabled;

    public AclConfigFlag(Configuration conf) {
        this.enabled = conf.getBoolean("dfs.namenode.acls.enabled", false);
        LogFactory.getLog(AclConfigFlag.class).info((Object)("ACLs enabled? " + this.enabled));
    }

    public void checkForApiCall() throws AclException {
        if (!this.enabled) {
            throw new AclException(String.format("The ACL operation has been rejected.  Support for ACLs has been disabled by setting %s to false.", "dfs.namenode.acls.enabled"));
        }
    }
}

