/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.nfs.nfs3.DFSClientCache;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteManager;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.nfs.AccessPrivilege;
import org.apache.hadoop.nfs.NfsExports;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Interface;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.request.ACCESS3Request;
import org.apache.hadoop.nfs.nfs3.request.COMMIT3Request;
import org.apache.hadoop.nfs.nfs3.request.CREATE3Request;
import org.apache.hadoop.nfs.nfs3.request.FSINFO3Request;
import org.apache.hadoop.nfs.nfs3.request.FSSTAT3Request;
import org.apache.hadoop.nfs.nfs3.request.GETATTR3Request;
import org.apache.hadoop.nfs.nfs3.request.LOOKUP3Request;
import org.apache.hadoop.nfs.nfs3.request.MKDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.PATHCONF3Request;
import org.apache.hadoop.nfs.nfs3.request.READ3Request;
import org.apache.hadoop.nfs.nfs3.request.READDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.READDIRPLUS3Request;
import org.apache.hadoop.nfs.nfs3.request.READLINK3Request;
import org.apache.hadoop.nfs.nfs3.request.REMOVE3Request;
import org.apache.hadoop.nfs.nfs3.request.RENAME3Request;
import org.apache.hadoop.nfs.nfs3.request.RMDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.SETATTR3Request;
import org.apache.hadoop.nfs.nfs3.request.SYMLINK3Request;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.ACCESS3Response;
import org.apache.hadoop.nfs.nfs3.response.COMMIT3Response;
import org.apache.hadoop.nfs.nfs3.response.CREATE3Response;
import org.apache.hadoop.nfs.nfs3.response.FSINFO3Response;
import org.apache.hadoop.nfs.nfs3.response.FSSTAT3Response;
import org.apache.hadoop.nfs.nfs3.response.GETATTR3Response;
import org.apache.hadoop.nfs.nfs3.response.LOOKUP3Response;
import org.apache.hadoop.nfs.nfs3.response.MKDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.PATHCONF3Response;
import org.apache.hadoop.nfs.nfs3.response.READ3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIRPLUS3Response;
import org.apache.hadoop.nfs.nfs3.response.READLINK3Response;
import org.apache.hadoop.nfs.nfs3.response.REMOVE3Response;
import org.apache.hadoop.nfs.nfs3.response.RENAME3Response;
import org.apache.hadoop.nfs.nfs3.response.RMDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.SETATTR3Response;
import org.apache.hadoop.nfs.nfs3.response.SYMLINK3Response;
import org.apache.hadoop.nfs.nfs3.response.WRITE3Response;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcCallCache;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.oncrpc.security.SysSecurityHandler;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;

public class RpcProgramNfs3
extends RpcProgram
implements Nfs3Interface {
    public static final int DEFAULT_UMASK = 18;
    public static final FsPermission umask = new FsPermission(18);
    static final Log LOG = LogFactory.getLog(RpcProgramNfs3.class);
    private final Configuration config = new Configuration();
    private final WriteManager writeManager;
    private final IdUserGroup iug;
    private final DFSClientCache clientCache;
    private final NfsExports exports;
    private final DFSClient superUserClient;
    private final short replication;
    private final long blockSize;
    private final int bufferSize;
    private FileSystem.Statistics statistics;
    private String writeDumpDir;
    private final RpcCallCache rpcCallCache;

    public RpcProgramNfs3(Configuration config) throws IOException {
        super("NFS3", "localhost", config.getInt("nfs3.server.port", 2049), 100003, 3, 3);
        config.set("fs.permissions.umask-mode", "000");
        this.iug = new IdUserGroup();
        this.exports = NfsExports.getInstance((Configuration)config);
        this.writeManager = new WriteManager(this.iug, config);
        this.clientCache = new DFSClientCache(config);
        this.superUserClient = new DFSClient(NameNode.getAddress((Configuration)config), config);
        this.replication = (short)config.getInt("dfs.replication", 3);
        this.blockSize = config.getLong("dfs.blocksize", 0x8000000L);
        this.bufferSize = config.getInt("io.file.buffer.size", 4096);
        this.writeDumpDir = config.get("dfs.nfs3.dump.dir", "/tmp/.hdfs-nfs");
        boolean enableDump = config.getBoolean("dfs.nfs3.enableDump", true);
        UserGroupInformation.setConfiguration((Configuration)config);
        SecurityUtil.login((Configuration)config, (String)"dfs.nfs.keytab.file", (String)"dfs.nfs.kerberos.principal");
        if (!enableDump) {
            this.writeDumpDir = null;
        } else {
            this.clearDirectory(this.writeDumpDir);
        }
        this.rpcCallCache = new RpcCallCache("NFS3", 256);
    }

    private void clearDirectory(String writeDumpDir) throws IOException {
        File dumpDir = new File(writeDumpDir);
        if (dumpDir.exists()) {
            LOG.info((Object)("Delete current dump directory " + writeDumpDir));
            if (!FileUtil.fullyDelete((File)dumpDir)) {
                throw new IOException("Cannot remove current dump directory: " + dumpDir);
            }
        }
        LOG.info((Object)("Create new dump directory " + writeDumpDir));
        if (!dumpDir.mkdirs()) {
            throw new IOException("Cannot create dump directory " + dumpDir);
        }
    }

    public void startDaemons() {
        this.writeManager.startAsyncDataSerivce();
    }

    public NFS3Response nullProcedure() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NFS NULL");
        }
        return new NFS3Response(0);
    }

    public GETATTR3Response getattr(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        GETATTR3Response response = new GETATTR3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        GETATTR3Request request = null;
        try {
            request = new GETATTR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid GETATTR request");
            response.setStatus(22);
            return response;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GETATTR for fileId: " + handle.getFileId()));
        }
        Nfs3FileAttributes attrs = null;
        try {
            attrs = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
        }
        catch (RemoteException r) {
            LOG.warn((Object)"Exception ", (Throwable)r);
            IOException io = r.unwrapRemoteException();
            if (io instanceof AuthorizationException) {
                return new GETATTR3Response(13);
            }
            return new GETATTR3Response(5);
        }
        catch (IOException e) {
            LOG.info((Object)("Can't get file attribute, fileId=" + handle.getFileId()), (Throwable)e);
            response.setStatus(5);
            return response;
        }
        if (attrs == null) {
            LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
            response.setStatus(70);
            return response;
        }
        response.setPostOpAttr(attrs);
        return response;
    }

    private void setattrInternal(DFSClient dfsClient, String fileIdPath, SetAttr3 newAttr, boolean setMode) throws IOException {
        long mtime;
        EnumSet updateFields = newAttr.getUpdateFields();
        if (setMode && updateFields.contains(SetAttr3.SetAttrField.MODE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("set new mode:" + newAttr.getMode()));
            }
            dfsClient.setPermission(fileIdPath, new FsPermission((short)newAttr.getMode()));
        }
        if (updateFields.contains(SetAttr3.SetAttrField.UID) || updateFields.contains(SetAttr3.SetAttrField.GID)) {
            String uname = updateFields.contains(SetAttr3.SetAttrField.UID) ? this.iug.getUserName(newAttr.getUid(), "nobody") : null;
            String gname = updateFields.contains(SetAttr3.SetAttrField.GID) ? this.iug.getGroupName(newAttr.getGid(), "nobody") : null;
            dfsClient.setOwner(fileIdPath, uname, gname);
        }
        long atime = updateFields.contains(SetAttr3.SetAttrField.ATIME) ? newAttr.getAtime().getMilliSeconds() : -1L;
        long l = mtime = updateFields.contains(SetAttr3.SetAttrField.MTIME) ? newAttr.getMtime().getMilliSeconds() : -1L;
        if (atime != -1L || mtime != -1L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("set atime:" + atime + " mtime:" + mtime));
            }
            dfsClient.setTimes(fileIdPath, mtime, atime);
        }
    }

    public SETATTR3Response setattr(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        SETATTR3Response response = new SETATTR3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        SETATTR3Request request = null;
        try {
            request = new SETATTR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid SETATTR request");
            response.setStatus(22);
            return response;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS SETATTR fileId: " + handle.getFileId()));
        }
        if (request.getAttr().getUpdateFields().contains(SetAttr3.SetAttrField.SIZE)) {
            LOG.error((Object)("Setting file size is not supported when setattr, fileId: " + handle.getFileId()));
            response.setStatus(22);
            return response;
        }
        String fileIdPath = Nfs3Utils.getFileIdPath((FileHandle)handle);
        Nfs3FileAttributes preOpAttr = null;
        try {
            preOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            if (preOpAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                response.setStatus(70);
                return response;
            }
            WccAttr preOpWcc = Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr);
            if (request.isCheck() && !preOpAttr.getCtime().equals((Object)request.getCtime())) {
                WccData wccData = new WccData(preOpWcc, preOpAttr);
                return new SETATTR3Response(10002, wccData);
            }
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                return new SETATTR3Response(13, new WccData(preOpWcc, preOpAttr));
            }
            this.setattrInternal(dfsClient, fileIdPath, request.getAttr(), true);
            Nfs3FileAttributes postOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            WccData wccData = new WccData(preOpWcc, postOpAttr);
            return new SETATTR3Response(0, wccData);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            WccData wccData = null;
            try {
                wccData = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr), (DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpAttr for fileIdPath: " + fileIdPath), (Throwable)e1);
            }
            if (e instanceof AccessControlException) {
                return new SETATTR3Response(13, wccData);
            }
            return new SETATTR3Response(5, wccData);
        }
    }

    public LOOKUP3Response lookup(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        LOOKUP3Response response = new LOOKUP3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        LOOKUP3Request request = null;
        try {
            request = new LOOKUP3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid LOOKUP request");
            return new LOOKUP3Response(22);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS LOOKUP dir fileId: " + dirHandle.getFileId() + " name: " + fileName));
        }
        try {
            String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle);
            Nfs3FileAttributes postOpObjAttr = this.writeManager.getFileAttr(dfsClient, dirHandle, fileName);
            if (postOpObjAttr == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NFS LOOKUP fileId: " + dirHandle.getFileId() + " name:" + fileName + " does not exist"));
                }
                Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
                return new LOOKUP3Response(2, null, null, postOpDirAttr);
            }
            Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (postOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new LOOKUP3Response(70);
            }
            FileHandle fileHandle = new FileHandle(postOpObjAttr.getFileId());
            return new LOOKUP3Response(0, fileHandle, postOpObjAttr, postOpDirAttr);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new LOOKUP3Response(5);
        }
    }

    public ACCESS3Response access(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        ACCESS3Response response = new ACCESS3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        ACCESS3Request request = null;
        try {
            request = new ACCESS3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid ACCESS request");
            return new ACCESS3Response(22);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS ACCESS fileId: " + handle.getFileId()));
        }
        try {
            Nfs3FileAttributes attrs = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            if (attrs == null) {
                LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new ACCESS3Response(70);
            }
            int access = Nfs3Utils.getAccessRightsForUserGroup((int)securityHandler.getUid(), (int)securityHandler.getGid(), (Nfs3FileAttributes)attrs);
            return new ACCESS3Response(0, attrs, access);
        }
        catch (RemoteException r) {
            LOG.warn((Object)"Exception ", (Throwable)r);
            IOException io = r.unwrapRemoteException();
            if (io instanceof AuthorizationException) {
                return new ACCESS3Response(13);
            }
            return new ACCESS3Response(5);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new ACCESS3Response(5);
        }
    }

    public READLINK3Response readlink(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        READLINK3Response response = new READLINK3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        READLINK3Request request = null;
        try {
            request = new READLINK3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READLINK request");
            return new READLINK3Response(22);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READLINK fileId: " + handle.getFileId()));
        }
        String fileIdPath = Nfs3Utils.getFileIdPath((FileHandle)handle);
        try {
            String target = dfsClient.getLinkTarget(fileIdPath);
            Nfs3FileAttributes postOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            if (postOpAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READLINK3Response(70);
            }
            if (postOpAttr.getType() != NfsFileType.NFSLNK.toValue()) {
                LOG.error((Object)("Not a symlink, fileId:" + handle.getFileId()));
                return new READLINK3Response(22);
            }
            if (target == null) {
                LOG.error((Object)("Symlink target should not be null, fileId:" + handle.getFileId()));
                return new READLINK3Response(10006);
            }
            int rtmax = this.config.getInt("dfs.nfs.rtmax", 0x100000);
            if (rtmax < target.getBytes().length) {
                LOG.error((Object)("Link size: " + target.getBytes().length + " is larger than max transfer size: " + rtmax));
                return new READLINK3Response(5, postOpAttr, new byte[0]);
            }
            return new READLINK3Response(0, postOpAttr, target.getBytes());
        }
        catch (IOException e) {
            LOG.warn((Object)("Readlink error: " + e.getClass()), (Throwable)e);
            if (e instanceof FileNotFoundException) {
                return new READLINK3Response(70);
            }
            if (e instanceof AccessControlException) {
                return new READLINK3Response(13);
            }
            return new READLINK3Response(5);
        }
    }

    public READ3Response read(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        READ3Response response = new READ3Response(0);
        String userName = securityHandler.getUser();
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(userName);
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        READ3Request request = null;
        try {
            request = new READ3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READ request");
            return new READ3Response(22);
        }
        long offset = request.getOffset();
        int count = request.getCount();
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READ fileId: " + handle.getFileId() + " offset: " + offset + " count: " + count));
        }
        if (count == 0) {
            Nfs3FileAttributes attrs;
            try {
                attrs = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)Nfs3Utils.getFileIdPath((FileHandle)handle), (IdUserGroup)this.iug);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Get error accessing file, fileId:" + handle.getFileId()), (Throwable)e);
                }
                return new READ3Response(5);
            }
            if (attrs == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Can't get path for fileId:" + handle.getFileId()));
                }
                return new READ3Response(2);
            }
            int access = Nfs3Utils.getAccessRightsForUserGroup((int)securityHandler.getUid(), (int)securityHandler.getGid(), (Nfs3FileAttributes)attrs);
            if ((access & 1) != 0) {
                boolean eof = offset >= attrs.getSize();
                return new READ3Response(0, attrs, 0, eof, ByteBuffer.wrap(new byte[0]));
            }
            return new READ3Response(13);
        }
        int ret = this.writeManager.commitBeforeRead(dfsClient, handle, offset + (long)count);
        if (ret != 0) {
            LOG.warn((Object)("commitBeforeRead didn't succeed with ret=" + ret + ". Read may not get most recent data."));
        }
        try {
            int rtmax = this.config.getInt("dfs.nfs.rtmax", 0x100000);
            int buffSize = Math.min(rtmax, count);
            byte[] readbuffer = new byte[buffSize];
            int readCount = 0;
            for (int i = 0; i < 1; ++i) {
                FSDataInputStream fis = this.clientCache.getDfsInputStream(userName, Nfs3Utils.getFileIdPath((FileHandle)handle));
                try {
                    readCount = fis.read(offset, readbuffer, 0, count);
                    continue;
                }
                catch (IOException e) {
                    if (e.getMessage() == "Stream closed") {
                        this.clientCache.invalidateDfsInputStream(userName, Nfs3Utils.getFileIdPath((FileHandle)handle));
                        continue;
                    }
                    throw e;
                }
            }
            Nfs3FileAttributes attrs = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)Nfs3Utils.getFileIdPath((FileHandle)handle), (IdUserGroup)this.iug);
            if (readCount < count) {
                LOG.info((Object)("Partical read. Asked offset:" + offset + " count:" + count + " and read back:" + readCount + "file size:" + attrs.getSize()));
            }
            if (readCount < 0) {
                readCount = 0;
            }
            boolean eof = offset + (long)readCount >= attrs.getSize();
            return new READ3Response(0, attrs, readCount, eof, ByteBuffer.wrap(readbuffer));
        }
        catch (IOException e) {
            LOG.warn((Object)("Read error: " + e.getClass() + " offset: " + offset + " count: " + count), (Throwable)e);
            return new READ3Response(5);
        }
    }

    public WRITE3Response write(XDR xdr, Channel channel, int xid, SecurityHandler securityHandler, InetAddress client) {
        WRITE3Response response = new WRITE3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        WRITE3Request request = null;
        try {
            request = new WRITE3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid WRITE request");
            return new WRITE3Response(22);
        }
        long offset = request.getOffset();
        int count = request.getCount();
        Nfs3Constant.WriteStableHow stableHow = request.getStableHow();
        byte[] data = request.getData().array();
        if (data.length < count) {
            LOG.error((Object)"Invalid argument, data size is less than count in request");
            return new WRITE3Response(22);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS WRITE fileId: " + handle.getFileId() + " offset: " + offset + " length:" + count + " stableHow:" + stableHow.getValue() + " xid:" + xid));
        }
        Nfs3FileAttributes preOpAttr = null;
        try {
            preOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            if (preOpAttr == null) {
                LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new WRITE3Response(70);
            }
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                return new WRITE3Response(13, new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr), preOpAttr), 0, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("requesed offset=" + offset + " and current filesize=" + preOpAttr.getSize()));
            }
            this.writeManager.handleWrite(dfsClient, request, channel, xid, preOpAttr);
        }
        catch (IOException e) {
            LOG.info((Object)("Error writing to fileId " + handle.getFileId() + " at offset " + offset + " and length " + data.length), (Throwable)e);
            Nfs3FileAttributes postOpAttr = null;
            try {
                postOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpAttr for fileId: " + handle.getFileId()), (Throwable)e1);
            }
            WccAttr attr = preOpAttr == null ? null : Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr);
            WccData fileWcc = new WccData(attr, postOpAttr);
            return new WRITE3Response(5, fileWcc, 0, request.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
        }
        return null;
    }

    public CREATE3Response create(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        int createMode;
        CREATE3Response response = new CREATE3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        CREATE3Request request = null;
        try {
            request = new CREATE3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid CREATE request");
            return new CREATE3Response(22);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS CREATE dir fileId: " + dirHandle.getFileId() + " filename: " + fileName));
        }
        if ((createMode = request.getMode()) != 2 && request.getObjAttr().getUpdateFields().contains(SetAttr3.SetAttrField.SIZE) && request.getObjAttr().getSize() != 0L) {
            LOG.error((Object)("Setting file size is not supported when creating file: " + fileName + " dir fileId:" + dirHandle.getFileId()));
            return new CREATE3Response(22);
        }
        HdfsDataOutputStream fos = null;
        String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle);
        Nfs3FileAttributes preOpDirAttr = null;
        Nfs3FileAttributes postOpObjAttr = null;
        FileHandle fileHandle = null;
        WccData dirWcc = null;
        try {
            preOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (preOpDirAttr == null) {
                LOG.error((Object)("Can't get path for dirHandle:" + dirHandle));
                return new CREATE3Response(70);
            }
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                return new CREATE3Response(13, null, preOpDirAttr, new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), preOpDirAttr));
            }
            String fileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle) + "/" + fileName;
            SetAttr3 setAttr3 = request.getObjAttr();
            assert (setAttr3 != null);
            FsPermission permission = setAttr3.getUpdateFields().contains(SetAttr3.SetAttrField.MODE) ? new FsPermission((short)setAttr3.getMode()) : FsPermission.getDefault().applyUMask(umask);
            EnumSet<CreateFlag> flag = createMode != 2 ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE);
            fos = new HdfsDataOutputStream(dfsClient.create(fileIdPath, permission, flag, false, this.replication, this.blockSize, null, this.bufferSize, null), this.statistics);
            if (createMode == 0 || createMode == 1) {
                if (!setAttr3.getUpdateFields().contains(SetAttr3.SetAttrField.GID)) {
                    setAttr3.getUpdateFields().add(SetAttr3.SetAttrField.GID);
                    setAttr3.setGid(securityHandler.getGid());
                }
                this.setattrInternal(dfsClient, fileIdPath, setAttr3, false);
            }
            postOpObjAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            dirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), (DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            OpenFileCtx openFileCtx = new OpenFileCtx(fos, postOpObjAttr, this.writeDumpDir + "/" + postOpObjAttr.getFileId(), dfsClient, this.iug);
            fileHandle = new FileHandle(postOpObjAttr.getFileId());
            if (!this.writeManager.addOpenFileStream(fileHandle, openFileCtx)) {
                LOG.warn((Object)"Can't add more stream, close it. Future write will become append");
                fos.close();
                fos = null;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opened stream for file:" + fileName + ", fileId:" + fileHandle.getFileId()));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    LOG.error((Object)("Can't close stream for dirFileId:" + dirHandle.getFileId() + " filename: " + fileName), (Throwable)e1);
                }
            }
            if (dirWcc == null) {
                try {
                    dirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), (DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
                }
                catch (IOException e1) {
                    LOG.error((Object)("Can't get postOpDirAttr for dirFileId:" + dirHandle.getFileId()), (Throwable)e1);
                }
            }
            if (e instanceof AccessControlException) {
                return new CREATE3Response(13, fileHandle, postOpObjAttr, dirWcc);
            }
            return new CREATE3Response(5, fileHandle, postOpObjAttr, dirWcc);
        }
        return new CREATE3Response(0, fileHandle, postOpObjAttr, dirWcc);
    }

    public MKDIR3Response mkdir(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        MKDIR3Response response = new MKDIR3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        MKDIR3Request request = null;
        try {
            request = new MKDIR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid MKDIR request");
            return new MKDIR3Response(22);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (request.getObjAttr().getUpdateFields().contains(SetAttr3.SetAttrField.SIZE)) {
            LOG.error((Object)("Setting file size is not supported when mkdir: " + fileName + " in dirHandle" + dirHandle));
            return new MKDIR3Response(22);
        }
        String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle);
        Nfs3FileAttributes preOpDirAttr = null;
        Nfs3FileAttributes postOpDirAttr = null;
        Nfs3FileAttributes postOpObjAttr = null;
        FileHandle objFileHandle = null;
        try {
            FsPermission permission;
            preOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (preOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new MKDIR3Response(70);
            }
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                return new MKDIR3Response(13, null, preOpDirAttr, new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), preOpDirAttr));
            }
            String fileIdPath = dirFileIdPath + "/" + fileName;
            SetAttr3 setAttr3 = request.getObjAttr();
            FsPermission fsPermission = permission = setAttr3.getUpdateFields().contains(SetAttr3.SetAttrField.MODE) ? new FsPermission((short)setAttr3.getMode()) : FsPermission.getDefault().applyUMask(umask);
            if (!dfsClient.mkdirs(fileIdPath, permission, false)) {
                WccData dirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), (DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
                return new MKDIR3Response(5, null, null, dirWcc);
            }
            if (!setAttr3.getUpdateFields().contains(SetAttr3.SetAttrField.GID)) {
                setAttr3.getUpdateFields().add(SetAttr3.SetAttrField.GID);
                setAttr3.setGid(securityHandler.getGid());
            }
            this.setattrInternal(dfsClient, fileIdPath, setAttr3, false);
            postOpObjAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            objFileHandle = new FileHandle(postOpObjAttr.getFileId());
            WccData dirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), (DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            return new MKDIR3Response(0, new FileHandle(postOpObjAttr.getFileId()), postOpObjAttr, dirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            if (postOpDirAttr == null) {
                try {
                    postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
                }
                catch (IOException e1) {
                    LOG.info((Object)("Can't get postOpDirAttr for " + dirFileIdPath), (Throwable)e);
                }
            }
            WccData dirWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), postOpDirAttr);
            if (e instanceof AccessControlException) {
                return new MKDIR3Response(1, objFileHandle, postOpObjAttr, dirWcc);
            }
            return new MKDIR3Response(5, objFileHandle, postOpObjAttr, dirWcc);
        }
    }

    public READDIR3Response mknod(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        return new READDIR3Response(10004);
    }

    public REMOVE3Response remove(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        REMOVE3Response response = new REMOVE3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        REMOVE3Request request = null;
        try {
            request = new REMOVE3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid REMOVE request");
            return new REMOVE3Response(22);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS REMOVE dir fileId: " + dirHandle.getFileId() + " fileName: " + fileName));
        }
        String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle);
        Nfs3FileAttributes preOpDirAttr = null;
        Nfs3FileAttributes postOpDirAttr = null;
        try {
            preOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (preOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new REMOVE3Response(70);
            }
            String fileIdPath = dirFileIdPath + "/" + fileName;
            HdfsFileStatus fstat = Nfs3Utils.getFileStatus((DFSClient)dfsClient, (String)fileIdPath);
            if (fstat == null) {
                WccData dirWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), preOpDirAttr);
                return new REMOVE3Response(2, dirWcc);
            }
            if (fstat.isDir()) {
                WccData dirWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), preOpDirAttr);
                return new REMOVE3Response(21, dirWcc);
            }
            boolean result = dfsClient.delete(fileIdPath, false);
            WccData dirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), (DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (!result) {
                return new REMOVE3Response(13, dirWcc);
            }
            return new REMOVE3Response(0, dirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            if (postOpDirAttr == null) {
                try {
                    postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
                }
                catch (IOException e1) {
                    LOG.info((Object)("Can't get postOpDirAttr for " + dirFileIdPath), (Throwable)e1);
                }
            }
            WccData dirWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), postOpDirAttr);
            if (e instanceof AccessControlException) {
                return new REMOVE3Response(1, dirWcc);
            }
            return new REMOVE3Response(5, dirWcc);
        }
    }

    public RMDIR3Response rmdir(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        RMDIR3Response response = new RMDIR3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        RMDIR3Request request = null;
        try {
            request = new RMDIR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid RMDIR request");
            return new RMDIR3Response(22);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS RMDIR dir fileId: " + dirHandle.getFileId() + " fileName: " + fileName));
        }
        String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle);
        Nfs3FileAttributes preOpDirAttr = null;
        Nfs3FileAttributes postOpDirAttr = null;
        try {
            preOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (preOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new RMDIR3Response(70);
            }
            WccData errWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), preOpDirAttr);
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                return new RMDIR3Response(13, errWcc);
            }
            String fileIdPath = dirFileIdPath + "/" + fileName;
            HdfsFileStatus fstat = Nfs3Utils.getFileStatus((DFSClient)dfsClient, (String)fileIdPath);
            if (fstat == null) {
                return new RMDIR3Response(2, errWcc);
            }
            if (!fstat.isDir()) {
                return new RMDIR3Response(Nfs3Status.NFS3ERR_NOTDIR, errWcc);
            }
            if (fstat.getChildrenNum() > 0) {
                return new RMDIR3Response(66, errWcc);
            }
            boolean result = dfsClient.delete(fileIdPath, false);
            WccData dirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), (DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (!result) {
                return new RMDIR3Response(13, dirWcc);
            }
            return new RMDIR3Response(0, dirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            if (postOpDirAttr == null) {
                try {
                    postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
                }
                catch (IOException e1) {
                    LOG.info((Object)("Can't get postOpDirAttr for " + dirFileIdPath), (Throwable)e1);
                }
            }
            WccData dirWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpDirAttr), postOpDirAttr);
            if (e instanceof AccessControlException) {
                return new RMDIR3Response(1, dirWcc);
            }
            return new RMDIR3Response(5, dirWcc);
        }
    }

    public RENAME3Response rename(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        RENAME3Response response = new RENAME3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        RENAME3Request request = null;
        try {
            request = new RENAME3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid RENAME request");
            return new RENAME3Response(22);
        }
        FileHandle fromHandle = request.getFromDirHandle();
        String fromName = request.getFromName();
        FileHandle toHandle = request.getToDirHandle();
        String toName = request.getToName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS RENAME from: " + fromHandle.getFileId() + "/" + fromName + " to: " + toHandle.getFileId() + "/" + toName));
        }
        String fromDirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)fromHandle);
        String toDirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)toHandle);
        Nfs3FileAttributes fromPreOpAttr = null;
        Nfs3FileAttributes toPreOpAttr = null;
        WccData fromDirWcc = null;
        WccData toDirWcc = null;
        try {
            fromPreOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fromDirFileIdPath, (IdUserGroup)this.iug);
            if (fromPreOpAttr == null) {
                LOG.info((Object)("Can't get path for fromHandle fileId:" + fromHandle.getFileId()));
                return new RENAME3Response(70);
            }
            toPreOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)toDirFileIdPath, (IdUserGroup)this.iug);
            if (toPreOpAttr == null) {
                LOG.info((Object)("Can't get path for toHandle fileId:" + toHandle.getFileId()));
                return new RENAME3Response(70);
            }
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                WccData fromWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)fromPreOpAttr), fromPreOpAttr);
                WccData toWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)toPreOpAttr), toPreOpAttr);
                return new RENAME3Response(13, fromWcc, toWcc);
            }
            String src = fromDirFileIdPath + "/" + fromName;
            String dst = toDirFileIdPath + "/" + toName;
            dfsClient.rename(src, dst, new Options.Rename[]{Options.Rename.NONE});
            fromDirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)fromPreOpAttr), (DFSClient)dfsClient, (String)fromDirFileIdPath, (IdUserGroup)this.iug);
            toDirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)toPreOpAttr), (DFSClient)dfsClient, (String)toDirFileIdPath, (IdUserGroup)this.iug);
            return new RENAME3Response(0, fromDirWcc, toDirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            try {
                fromDirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)fromPreOpAttr), (DFSClient)dfsClient, (String)fromDirFileIdPath, (IdUserGroup)this.iug);
                toDirWcc = Nfs3Utils.createWccData((WccAttr)Nfs3Utils.getWccAttr((Nfs3FileAttributes)toPreOpAttr), (DFSClient)dfsClient, (String)toDirFileIdPath, (IdUserGroup)this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpDirAttr for " + fromDirFileIdPath + " or" + toDirFileIdPath), (Throwable)e1);
            }
            if (e instanceof AccessControlException) {
                return new RENAME3Response(1, fromDirWcc, toDirWcc);
            }
            return new RENAME3Response(5, fromDirWcc, toDirWcc);
        }
    }

    public SYMLINK3Response symlink(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        SYMLINK3Response response = new SYMLINK3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        SYMLINK3Request request = null;
        try {
            request = new SYMLINK3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid SYMLINK request");
            response.setStatus(22);
            return response;
        }
        FileHandle dirHandle = request.getHandle();
        String name = request.getName();
        String symData = request.getSymData();
        String linkDirIdPath = Nfs3Utils.getFileIdPath((FileHandle)dirHandle);
        String linkIdPath = linkDirIdPath + "/" + name;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS SYMLINK, target: " + symData + " link: " + linkIdPath));
        }
        try {
            WccData dirWcc = response.getDirWcc();
            WccAttr preOpAttr = Nfs3Utils.getWccAttr((DFSClient)dfsClient, (String)linkDirIdPath);
            dirWcc.setPreOpAttr(preOpAttr);
            dfsClient.createSymlink(symData, linkIdPath, false);
            HdfsFileStatus linkstat = dfsClient.getFileLinkInfo(linkIdPath);
            Nfs3FileAttributes objAttr = Nfs3Utils.getNfs3FileAttrFromFileStatus((HdfsFileStatus)linkstat, (IdUserGroup)this.iug);
            dirWcc.setPostOpAttr(Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)linkDirIdPath, (IdUserGroup)this.iug));
            return new SYMLINK3Response(0, new FileHandle(objAttr.getFileId()), objAttr, dirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)("Exception:" + e));
            response.setStatus(5);
            return response;
        }
    }

    public READDIR3Response link(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        return new READDIR3Response(10004);
    }

    private DirectoryListing listPaths(DFSClient dfsClient, String dirFileIdPath, byte[] startAfter) throws IOException {
        DirectoryListing dlisting = null;
        try {
            dlisting = dfsClient.listPaths(dirFileIdPath, startAfter);
        }
        catch (RemoteException e) {
            IOException io = e.unwrapRemoteException();
            if (!(io instanceof DirectoryListingStartAfterNotFoundException)) {
                throw io;
            }
            LOG.info((Object)("Cookie cound't be found: " + new String(startAfter) + ", do listing from beginning"));
            dlisting = dfsClient.listPaths(dirFileIdPath, HdfsFileStatus.EMPTY_NAME);
        }
        return dlisting;
    }

    public READDIR3Response readdir(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        int i;
        READDIR3Response.Entry3[] entries;
        boolean eof;
        READDIR3Response response = new READDIR3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        READDIR3Request request = null;
        try {
            request = new READDIR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READDIR request");
            return new READDIR3Response(22);
        }
        FileHandle handle = request.getHandle();
        long cookie = request.getCookie();
        if (cookie < 0L) {
            LOG.error((Object)("Invalid READDIR request, with negitve cookie:" + cookie));
            return new READDIR3Response(22);
        }
        long count = request.getCount();
        if (count <= 0L) {
            LOG.info((Object)("Nonpositive count in invalid READDIR request:" + count));
            return new READDIR3Response(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READDIR fileId: " + handle.getFileId() + " cookie: " + cookie + " count: " + count));
        }
        HdfsFileStatus dirStatus = null;
        DirectoryListing dlisting = null;
        Nfs3FileAttributes postOpAttr = null;
        long dotdotFileId = 0L;
        try {
            byte[] startAfter;
            String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)handle);
            dirStatus = dfsClient.getFileInfo(dirFileIdPath);
            if (dirStatus == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIR3Response(70);
            }
            if (!dirStatus.isDir()) {
                LOG.error((Object)("Can't readdir for regular file, fileId:" + handle.getFileId()));
                return new READDIR3Response(Nfs3Status.NFS3ERR_NOTDIR);
            }
            long cookieVerf = request.getCookieVerf();
            if (cookieVerf != 0L && cookieVerf != dirStatus.getModificationTime()) {
                LOG.error((Object)("CookierVerf mismatch. request cookierVerf:" + cookieVerf + " dir cookieVerf:" + dirStatus.getModificationTime()));
                return new READDIR3Response(10003);
            }
            if (cookie == 0L) {
                String dotdotFileIdPath = dirFileIdPath + "/..";
                HdfsFileStatus dotdotStatus = dfsClient.getFileInfo(dotdotFileIdPath);
                if (dotdotStatus == null) {
                    throw new IOException("Can't get path for handle path:" + dotdotFileIdPath);
                }
                dotdotFileId = dotdotStatus.getFileId();
            }
            if (cookie == 0L) {
                startAfter = HdfsFileStatus.EMPTY_NAME;
            } else {
                String inodeIdPath = Nfs3Utils.getFileIdPath((long)cookie);
                startAfter = inodeIdPath.getBytes();
            }
            dlisting = this.listPaths(dfsClient, dirFileIdPath, startAfter);
            postOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (postOpAttr == null) {
                LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIR3Response(70);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new READDIR3Response(5);
        }
        HdfsFileStatus[] fstatus = dlisting.getPartialListing();
        int n = (int)Math.min((long)fstatus.length, count - 2L);
        boolean bl = n < fstatus.length ? false : (eof = dlisting.getRemainingEntries() == 0);
        if (cookie == 0L) {
            entries = new READDIR3Response.Entry3[n + 2];
            entries[0] = new READDIR3Response.Entry3(postOpAttr.getFileId(), ".", 0L);
            entries[1] = new READDIR3Response.Entry3(dotdotFileId, "..", dotdotFileId);
            for (i = 2; i < n + 2; ++i) {
                entries[i] = new READDIR3Response.Entry3(fstatus[i - 2].getFileId(), fstatus[i - 2].getLocalName(), fstatus[i - 2].getFileId());
            }
        } else {
            entries = new READDIR3Response.Entry3[n];
            for (i = 0; i < n; ++i) {
                entries[i] = new READDIR3Response.Entry3(fstatus[i].getFileId(), fstatus[i].getLocalName(), fstatus[i].getFileId());
            }
        }
        READDIR3Response.DirList3 dirList = new READDIR3Response.DirList3(entries, eof);
        return new READDIR3Response(0, postOpAttr, dirStatus.getModificationTime(), dirList);
    }

    public READDIRPLUS3Response readdirplus(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        int i;
        READDIRPLUS3Response.EntryPlus3[] entries;
        boolean eof;
        HdfsFileStatus dirStatus;
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            return new READDIRPLUS3Response(13);
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            return new READDIRPLUS3Response(10006);
        }
        READDIRPLUS3Request request = null;
        try {
            request = new READDIRPLUS3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READDIRPLUS request");
            return new READDIRPLUS3Response(22);
        }
        FileHandle handle = request.getHandle();
        long cookie = request.getCookie();
        if (cookie < 0L) {
            LOG.error((Object)("Invalid READDIRPLUS request, with negitve cookie:" + cookie));
            return new READDIRPLUS3Response(22);
        }
        long dirCount = request.getDirCount();
        if (dirCount <= 0L) {
            LOG.info((Object)("Nonpositive dircount in invalid READDIRPLUS request:" + dirCount));
            return new READDIRPLUS3Response(22);
        }
        int maxCount = request.getMaxCount();
        if (maxCount <= 0) {
            LOG.info((Object)("Nonpositive maxcount in invalid READDIRPLUS request:" + maxCount));
            return new READDIRPLUS3Response(22);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READDIRPLUS fileId: " + handle.getFileId() + " cookie: " + cookie + " dirCount: " + dirCount + " maxCount: " + maxCount));
        }
        DirectoryListing dlisting = null;
        Nfs3FileAttributes postOpDirAttr = null;
        long dotdotFileId = 0L;
        try {
            byte[] startAfter;
            String dirFileIdPath = Nfs3Utils.getFileIdPath((FileHandle)handle);
            dirStatus = dfsClient.getFileInfo(dirFileIdPath);
            if (dirStatus == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIRPLUS3Response(70);
            }
            if (!dirStatus.isDir()) {
                LOG.error((Object)("Can't readdirplus for regular file, fileId:" + handle.getFileId()));
                return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_NOTDIR);
            }
            long cookieVerf = request.getCookieVerf();
            if (cookieVerf != 0L && cookieVerf != dirStatus.getModificationTime()) {
                LOG.error((Object)("CookierVerf mismatch. request cookierVerf:" + cookieVerf + " dir cookieVerf:" + dirStatus.getModificationTime()));
                return new READDIRPLUS3Response(10003);
            }
            if (cookie == 0L) {
                String dotdotFileIdPath = dirFileIdPath + "/..";
                HdfsFileStatus dotdotStatus = dfsClient.getFileInfo(dotdotFileIdPath);
                if (dotdotStatus == null) {
                    throw new IOException("Can't get path for handle path:" + dotdotFileIdPath);
                }
                dotdotFileId = dotdotStatus.getFileId();
            }
            if (cookie == 0L) {
                startAfter = HdfsFileStatus.EMPTY_NAME;
            } else {
                String inodeIdPath = Nfs3Utils.getFileIdPath((long)cookie);
                startAfter = inodeIdPath.getBytes();
            }
            dlisting = this.listPaths(dfsClient, dirFileIdPath, startAfter);
            postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)dirFileIdPath, (IdUserGroup)this.iug);
            if (postOpDirAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIRPLUS3Response(70);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new READDIRPLUS3Response(5);
        }
        HdfsFileStatus[] fstatus = dlisting.getPartialListing();
        int n = (int)Math.min((long)fstatus.length, dirCount - 2L);
        boolean bl = n < fstatus.length ? false : (eof = dlisting.getRemainingEntries() == 0);
        if (cookie == 0L) {
            entries = new READDIRPLUS3Response.EntryPlus3[n + 2];
            entries[0] = new READDIRPLUS3Response.EntryPlus3(postOpDirAttr.getFileId(), ".", 0L, postOpDirAttr, new FileHandle(postOpDirAttr.getFileId()));
            entries[1] = new READDIRPLUS3Response.EntryPlus3(dotdotFileId, "..", dotdotFileId, postOpDirAttr, new FileHandle(dotdotFileId));
            for (i = 2; i < n + 2; ++i) {
                Nfs3FileAttributes attr;
                long fileId = fstatus[i - 2].getFileId();
                FileHandle childHandle = new FileHandle(fileId);
                try {
                    attr = this.writeManager.getFileAttr(dfsClient, childHandle, this.iug);
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't get file attributes for fileId:" + fileId), (Throwable)e);
                    continue;
                }
                entries[i] = new READDIRPLUS3Response.EntryPlus3(fileId, fstatus[i - 2].getLocalName(), fileId, attr, childHandle);
            }
        } else {
            entries = new READDIRPLUS3Response.EntryPlus3[n];
            for (i = 0; i < n; ++i) {
                Nfs3FileAttributes attr;
                long fileId = fstatus[i].getFileId();
                FileHandle childHandle = new FileHandle(fileId);
                try {
                    attr = this.writeManager.getFileAttr(dfsClient, childHandle, this.iug);
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't get file attributes for fileId:" + fileId), (Throwable)e);
                    continue;
                }
                entries[i] = new READDIRPLUS3Response.EntryPlus3(fileId, fstatus[i].getLocalName(), fileId, attr, childHandle);
            }
        }
        READDIRPLUS3Response.DirListPlus3 dirListPlus = new READDIRPLUS3Response.DirListPlus3(entries, eof);
        return new READDIRPLUS3Response(0, postOpDirAttr, dirStatus.getModificationTime(), dirListPlus);
    }

    public FSSTAT3Response fsstat(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        FSSTAT3Response response = new FSSTAT3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        FSSTAT3Request request = null;
        try {
            request = new FSSTAT3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid FSSTAT request");
            return new FSSTAT3Response(22);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS FSSTAT fileId: " + handle.getFileId()));
        }
        try {
            FsStatus fsStatus = this.superUserClient.getDiskStatus();
            long totalBytes = fsStatus.getCapacity();
            long freeBytes = fsStatus.getRemaining();
            Nfs3FileAttributes attrs = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            if (attrs == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new FSSTAT3Response(70);
            }
            long maxFsObjects = this.config.getLong("dfs.max.objects", 0L);
            if (maxFsObjects == 0L) {
                maxFsObjects = Integer.MAX_VALUE;
            }
            return new FSSTAT3Response(0, attrs, totalBytes, freeBytes, freeBytes, maxFsObjects, maxFsObjects, maxFsObjects, 0);
        }
        catch (RemoteException r) {
            LOG.warn((Object)"Exception ", (Throwable)r);
            IOException io = r.unwrapRemoteException();
            if (io instanceof AuthorizationException) {
                return new FSSTAT3Response(13);
            }
            return new FSSTAT3Response(5);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new FSSTAT3Response(5);
        }
    }

    public FSINFO3Response fsinfo(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        FSINFO3Response response = new FSINFO3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        FSINFO3Request request = null;
        try {
            request = new FSINFO3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid FSINFO request");
            return new FSINFO3Response(22);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS FSINFO fileId: " + handle.getFileId()));
        }
        try {
            int rtmax = this.config.getInt("dfs.nfs.rtmax", 0x100000);
            int wtmax = this.config.getInt("dfs.nfs.wtmax", 0x100000);
            int dtperf = this.config.getInt("dfs.nfs.dtmax", 65536);
            Nfs3FileAttributes attrs = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)Nfs3Utils.getFileIdPath((FileHandle)handle), (IdUserGroup)this.iug);
            if (attrs == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new FSINFO3Response(70);
            }
            int fsProperty = 24;
            return new FSINFO3Response(0, attrs, rtmax, rtmax, 1, wtmax, wtmax, 1, dtperf, Long.MAX_VALUE, new NfsTime(1L), fsProperty);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new FSINFO3Response(5);
        }
    }

    public PATHCONF3Response pathconf(XDR xdr, SecurityHandler securityHandler, InetAddress client) {
        PATHCONF3Response response = new PATHCONF3Response(0);
        if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_ONLY)) {
            response.setStatus(13);
            return response;
        }
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        PATHCONF3Request request = null;
        try {
            request = new PATHCONF3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid PATHCONF request");
            return new PATHCONF3Response(22);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS PATHCONF fileId: " + handle.getFileId()));
        }
        try {
            Nfs3FileAttributes attrs = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)Nfs3Utils.getFileIdPath((FileHandle)handle), (IdUserGroup)this.iug);
            if (attrs == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new PATHCONF3Response(70);
            }
            return new PATHCONF3Response(0, attrs, 0, 8000, true, false, false, true);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new PATHCONF3Response(5);
        }
    }

    public COMMIT3Response commit(XDR xdr, Channel channel, int xid, SecurityHandler securityHandler, InetAddress client) {
        COMMIT3Response response = new COMMIT3Response(0);
        DFSClient dfsClient = this.clientCache.getDfsClient(securityHandler.getUser());
        if (dfsClient == null) {
            response.setStatus(10006);
            return response;
        }
        COMMIT3Request request = null;
        try {
            request = new COMMIT3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid COMMIT request");
            response.setStatus(22);
            return response;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS COMMIT fileId: " + handle.getFileId() + " offset=" + request.getOffset() + " count=" + request.getCount()));
        }
        String fileIdPath = Nfs3Utils.getFileIdPath((FileHandle)handle);
        Nfs3FileAttributes preOpAttr = null;
        try {
            preOpAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdUserGroup)this.iug);
            if (preOpAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new COMMIT3Response(70);
            }
            if (!this.checkAccessPrivilege(client, AccessPrivilege.READ_WRITE)) {
                return new COMMIT3Response(13, new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr), preOpAttr), Nfs3Constant.WRITE_COMMIT_VERF);
            }
            long commitOffset = request.getCount() == 0 ? 0L : request.getOffset() + (long)request.getCount();
            this.writeManager.handleCommit(dfsClient, handle, commitOffset, channel, xid, preOpAttr);
            return null;
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            Nfs3FileAttributes postOpAttr = null;
            try {
                postOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpAttr for fileId: " + handle.getFileId()), (Throwable)e1);
            }
            WccData fileWcc = new WccData(Nfs3Utils.getWccAttr((Nfs3FileAttributes)preOpAttr), postOpAttr);
            return new COMMIT3Response(5, fileWcc, Nfs3Constant.WRITE_COMMIT_VERF);
        }
    }

    private SecurityHandler getSecurityHandler(Credentials credentials, Verifier verifier) {
        if (credentials instanceof CredentialsSys) {
            return new SysSecurityHandler((CredentialsSys)credentials, this.iug);
        }
        return null;
    }

    public void handleInternal(ChannelHandlerContext ctx, RpcInfo info) {
        RpcCallCache.CacheEntry entry;
        RpcCall rpcCall = (RpcCall)info.header();
        Nfs3Constant.NFSPROC3 nfsproc3 = Nfs3Constant.NFSPROC3.fromValue((int)rpcCall.getProcedure());
        int xid = rpcCall.getXid();
        byte[] data = new byte[info.data().readableBytes()];
        info.data().readBytes(data);
        XDR xdr = new XDR(data);
        XDR out = new XDR();
        InetAddress client = ((InetSocketAddress)info.remoteAddress()).getAddress();
        Channel channel = info.channel();
        Credentials credentials = rpcCall.getCredential();
        if (nfsproc3 != Nfs3Constant.NFSPROC3.NULL && credentials.getFlavor() != RpcAuthInfo.AuthFlavor.AUTH_SYS && credentials.getFlavor() != RpcAuthInfo.AuthFlavor.RPCSEC_GSS) {
            LOG.info((Object)("Wrong RPC AUTH flavor, " + credentials.getFlavor() + " is not AUTH_SYS or RPCSEC_GSS."));
            XDR reply = new XDR();
            RpcDeniedReply rdr = new RpcDeniedReply(xid, RpcReply.ReplyState.MSG_ACCEPTED, RpcDeniedReply.RejectState.AUTH_ERROR, (Verifier)new VerifierNone());
            rdr.write(reply);
            ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)reply.asReadOnlyWrap().buffer());
            RpcResponse rsp = new RpcResponse(buf, info.remoteAddress());
            RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
            return;
        }
        if (!this.isIdempotent(rpcCall) && (entry = this.rpcCallCache.checkOrAddToCache(client, xid)) != null) {
            if (entry.isCompleted()) {
                LOG.info((Object)("Sending the cached reply to retransmitted request " + xid));
                RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)entry.getResponse());
                return;
            }
            LOG.info((Object)("Retransmitted request, transaction still in progress " + xid));
            return;
        }
        SecurityHandler securityHandler = this.getSecurityHandler(credentials, rpcCall.getVerifier());
        NFS3Response response = null;
        if (nfsproc3 == Nfs3Constant.NFSPROC3.NULL) {
            response = this.nullProcedure();
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.GETATTR) {
            response = this.getattr(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.SETATTR) {
            response = this.setattr(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.LOOKUP) {
            response = this.lookup(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.ACCESS) {
            response = this.access(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.READLINK) {
            response = this.readlink(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.READ) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("READ_RPC_CALL_START____" + xid));
            }
            response = this.read(xdr, securityHandler, client);
            if (LOG.isDebugEnabled() && nfsproc3 == Nfs3Constant.NFSPROC3.READ) {
                LOG.debug((Object)("READ_RPC_CALL_END______" + xid));
            }
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.WRITE) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WRITE_RPC_CALL_START____" + xid));
            }
            response = this.write(xdr, channel, xid, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.CREATE) {
            response = this.create(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.MKDIR) {
            response = this.mkdir(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.SYMLINK) {
            response = this.symlink(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.MKNOD) {
            response = this.mknod(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.REMOVE) {
            response = this.remove(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.RMDIR) {
            response = this.rmdir(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.RENAME) {
            response = this.rename(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.LINK) {
            response = this.link(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.READDIR) {
            response = this.readdir(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.READDIRPLUS) {
            response = this.readdirplus(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.FSSTAT) {
            response = this.fsstat(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.FSINFO) {
            response = this.fsinfo(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.PATHCONF) {
            response = this.pathconf(xdr, securityHandler, client);
        } else if (nfsproc3 == Nfs3Constant.NFSPROC3.COMMIT) {
            response = this.commit(xdr, channel, xid, securityHandler, client);
        } else {
            RpcAcceptedReply.getInstance((int)xid, (RpcAcceptedReply.AcceptState)RpcAcceptedReply.AcceptState.PROC_UNAVAIL, (Verifier)new VerifierNone()).write(out);
        }
        if (response == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No sync response, expect an async response for request XID=" + rpcCall.getXid()));
            }
            return;
        }
        out = response.writeHeaderAndResponse(out, xid, (Verifier)new VerifierNone());
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, info.remoteAddress());
        if (!this.isIdempotent(rpcCall)) {
            this.rpcCallCache.callCompleted(client, xid, rsp);
        }
        RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
    }

    protected boolean isIdempotent(RpcCall call) {
        Nfs3Constant.NFSPROC3 nfsproc3 = Nfs3Constant.NFSPROC3.fromValue((int)call.getProcedure());
        return nfsproc3 == null || nfsproc3.isIdempotent();
    }

    private boolean checkAccessPrivilege(InetAddress client, AccessPrivilege expected) {
        AccessPrivilege access = this.exports.getAccessPrivilege(client);
        if (access == AccessPrivilege.NONE) {
            return false;
        }
        return access != AccessPrivilege.READ_ONLY || expected != AccessPrivilege.READ_WRITE;
    }

    @VisibleForTesting
    WriteManager getWriteManager() {
        return this.writeManager;
    }
}

