/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class FSOperations {
    private static Map<String, Object> aclStatusToJSON(AclStatus aclStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        JSONArray entriesArray = new JSONArray();
        inner.put("owner", aclStatus.getOwner());
        inner.put("group", aclStatus.getGroup());
        inner.put("stickyBit", aclStatus.isStickyBit());
        for (AclEntry e : aclStatus.getEntries()) {
            entriesArray.add((Object)e.toString());
        }
        inner.put("entries", entriesArray);
        json.put("AclStatus", inner);
        return json;
    }

    private static Map fileChecksumToJSON(FileChecksum checksum) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("algorithm", checksum.getAlgorithmName());
        json.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        json.put("length", checksum.getLength());
        LinkedHashMap<String, LinkedHashMap<String, Object>> response = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        response.put("FileChecksum", json);
        return response;
    }

    private static Map xAttrsToJSON(Map<String, byte[]> xAttrs, XAttrCodec encoding) throws IOException {
        LinkedHashMap<String, JSONArray> jsonMap = new LinkedHashMap<String, JSONArray>();
        JSONArray jsonArray = new JSONArray();
        if (xAttrs != null) {
            for (Map.Entry<String, byte[]> e : xAttrs.entrySet()) {
                LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
                json.put("name", e.getKey());
                if (e.getValue() != null) {
                    json.put("value", XAttrCodec.encodeValue((byte[])e.getValue(), (XAttrCodec)encoding));
                }
                jsonArray.add(json);
            }
        }
        jsonMap.put("XAttrs", jsonArray);
        return jsonMap;
    }

    private static Map xAttrNamesToJSON(List<String> names) throws IOException {
        LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
        jsonMap.put("XAttrNames", JSONArray.toJSONString(names));
        return jsonMap;
    }

    private static Map contentSummaryToJSON(ContentSummary contentSummary) {
        LinkedHashMap<String, Long> json = new LinkedHashMap<String, Long>();
        json.put("directoryCount", contentSummary.getDirectoryCount());
        json.put("fileCount", contentSummary.getFileCount());
        json.put("length", contentSummary.getLength());
        json.put("quota", contentSummary.getQuota());
        json.put("spaceConsumed", contentSummary.getSpaceConsumed());
        json.put("spaceQuota", contentSummary.getSpaceQuota());
        LinkedHashMap<String, LinkedHashMap<String, Long>> response = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
        response.put("ContentSummary", json);
        return response;
    }

    private static JSONObject toJSON(String name, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)name, value);
        return json;
    }

    static /* synthetic */ Map access$000(ContentSummary x0) {
        return FSOperations.contentSummaryToJSON((ContentSummary)x0);
    }

    static /* synthetic */ JSONObject access$100(String x0, Object x1) {
        return FSOperations.toJSON((String)x0, (Object)x1);
    }

    static /* synthetic */ Map access$200(FileChecksum x0) {
        return FSOperations.fileChecksumToJSON((FileChecksum)x0);
    }

    static /* synthetic */ Map access$300(AclStatus x0) {
        return FSOperations.aclStatusToJSON((AclStatus)x0);
    }

    static /* synthetic */ Map access$400(List x0) throws IOException {
        return FSOperations.xAttrNamesToJSON((List)x0);
    }

    static /* synthetic */ Map access$500(Map x0, XAttrCodec x1) throws IOException {
        return FSOperations.xAttrsToJSON((Map)x0, (XAttrCodec)x1);
    }
}

