/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class FSOperations {
    private static Map fileStatusToJSONRaw(FileStatus status, boolean emptyPathSuffix) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("pathSuffix", emptyPathSuffix ? "" : status.getPath().getName());
        json.put("type", HttpFSFileSystem.FILE_TYPE.getType((FileStatus)status).toString());
        json.put("length", status.getLen());
        json.put("owner", status.getOwner());
        json.put("group", status.getGroup());
        json.put("permission", HttpFSFileSystem.permissionToString((FsPermission)status.getPermission()));
        json.put("accessTime", status.getAccessTime());
        json.put("modificationTime", status.getModificationTime());
        json.put("blockSize", status.getBlockSize());
        json.put("replication", status.getReplication());
        return json;
    }

    private static Map fileStatusToJSON(FileStatus status) {
        LinkedHashMap<String, Map> json = new LinkedHashMap<String, Map>();
        json.put("FileStatus", FSOperations.fileStatusToJSONRaw((FileStatus)status, (boolean)true));
        return json;
    }

    private static Map fileChecksumToJSON(FileChecksum checksum) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("algorithm", checksum.getAlgorithmName());
        json.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        json.put("length", checksum.getLength());
        LinkedHashMap<String, LinkedHashMap<String, Object>> response = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        response.put("FileChecksum", json);
        return response;
    }

    private static Map contentSummaryToJSON(ContentSummary contentSummary) {
        LinkedHashMap<String, Long> json = new LinkedHashMap<String, Long>();
        json.put("directoryCount", contentSummary.getDirectoryCount());
        json.put("fileCount", contentSummary.getFileCount());
        json.put("length", contentSummary.getLength());
        json.put("quota", contentSummary.getQuota());
        json.put("spaceConsumed", contentSummary.getSpaceConsumed());
        json.put("spaceQuota", contentSummary.getSpaceQuota());
        LinkedHashMap<String, LinkedHashMap<String, Long>> response = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
        response.put("ContentSummary", json);
        return response;
    }

    private static Map fileStatusToJSON(FileStatus[] status) {
        JSONArray json = new JSONArray();
        if (status != null) {
            for (FileStatus s : status) {
                json.add((Object)FSOperations.fileStatusToJSONRaw((FileStatus)s, (boolean)false));
            }
        }
        LinkedHashMap response = new LinkedHashMap();
        LinkedHashMap<String, JSONArray> temp = new LinkedHashMap<String, JSONArray>();
        temp.put("FileStatus", json);
        response.put("FileStatuses", temp);
        return response;
    }

    private static JSONObject toJSON(String name, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)name, value);
        return json;
    }

    static /* synthetic */ Map access$000(ContentSummary x0) {
        return FSOperations.contentSummaryToJSON((ContentSummary)x0);
    }

    static /* synthetic */ JSONObject access$100(String x0, Object x1) {
        return FSOperations.toJSON((String)x0, (Object)x1);
    }

    static /* synthetic */ Map access$200(FileChecksum x0) {
        return FSOperations.fileChecksumToJSON((FileChecksum)x0);
    }

    static /* synthetic */ Map access$300(FileStatus x0) {
        return FSOperations.fileStatusToJSON((FileStatus)x0);
    }

    static /* synthetic */ Map access$400(FileStatus[] x0) {
        return FSOperations.fileStatusToJSON((FileStatus[])x0);
    }
}

