/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.http.client.BaseTestHttpFSWith;
import org.apache.hadoop.fs.http.client.TestHttpFSWithHttpFSFileSystem;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.AfterClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHttpFSFWithSWebhdfsFileSystem
extends TestHttpFSWithHttpFSFileSystem {
    private static String classpathDir;
    private static final String BASEDIR;
    private static Configuration sslConf;

    @AfterClass
    public static void cleanUp() {
        new File(classpathDir, "ssl-client.xml").delete();
        new File(classpathDir, "ssl-server.xml").delete();
    }

    public TestHttpFSFWithSWebhdfsFileSystem(BaseTestHttpFSWith.Operation operation) {
        super(operation);
        URL url = Thread.currentThread().getContextClassLoader().getResource("classutils.txt");
        classpathDir = url.toExternalForm();
        if (!classpathDir.startsWith("file:")) {
            throw new RuntimeException("Cannot find test classes dir");
        }
        classpathDir = classpathDir.substring("file:".length());
        classpathDir = classpathDir.substring(0, classpathDir.length() - "/classutils.txt".length());
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        String keyStoreDir = new File(BASEDIR).getAbsolutePath();
        try {
            sslConf = new Configuration();
            KeyStoreTestUtil.setupSSLConfig((String)keyStoreDir, (String)classpathDir, (Configuration)sslConf, (boolean)false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.jettyTestHelper = new TestJettyHelper("jks", keyStoreDir + "/serverKS.jks", "serverP");
    }

    protected Class getFileSystemClass() {
        return SWebHdfsFileSystem.class;
    }

    protected String getScheme() {
        return "swebhdfs";
    }

    protected FileSystem getHttpFSFileSystem() throws Exception {
        Configuration conf = new Configuration(sslConf);
        conf.set("fs.swebhdfs.impl", this.getFileSystemClass().getName());
        URI uri = new URI("swebhdfs://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        return FileSystem.get((URI)uri, (Configuration)conf);
    }

    static {
        BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + UUID.randomUUID();
    }
}

