/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.security;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.Groups;
import org.apache.hadoop.lib.service.ProxyUser;
import org.apache.hadoop.lib.service.security.GroupsService;
import org.apache.hadoop.lib.service.security.ProxyUserService;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestException;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestProxyUserService
extends HTestCase {
    @Test
    @TestDir
    public void service() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        server.destroy();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="PRXU02.*")
    @TestDir
    public void wrongConfigGroups() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="PRXU01.*")
    @TestDir
    public void wrongHost() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "otherhost");
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="PRXU02.*")
    @TestDir
    public void wrongConfigHosts() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestDir
    public void validateAnyHostAnyUser() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "*");
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("foo", "localhost", "bar");
        server.destroy();
    }

    @Test(expected=AccessControlException.class)
    @TestDir
    public void invalidProxyUser() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "*");
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("bar", "localhost", "foo");
        server.destroy();
    }

    @Test
    @TestDir
    public void validateHost() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "localhost");
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("foo", "localhost", "bar");
        server.destroy();
    }

    private String getGroup() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName())));
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Groups groups = (Groups)server.get(Groups.class);
        List g = groups.getGroups(System.getProperty("user.name"));
        server.destroy();
        return (String)g.get(0);
    }

    @Test
    @TestDir
    public void validateGroup() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "*");
        conf.set("server.proxyuser.foo.groups", this.getGroup());
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("foo", "localhost", System.getProperty("user.name"));
        server.destroy();
    }

    @Test(expected=AccessControlException.class)
    @TestDir
    public void unknownHost() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "localhost");
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("foo", "unknownhost.bar.foo", "bar");
        server.destroy();
    }

    @Test(expected=AccessControlException.class)
    @TestDir
    public void invalidHost() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "localhost");
        conf.set("server.proxyuser.foo.groups", "*");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("foo", "www.yahoo.com", "bar");
        server.destroy();
    }

    @Test(expected=AccessControlException.class)
    @TestDir
    public void invalidGroup() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("server.proxyuser.foo.hosts", "localhost");
        conf.set("server.proxyuser.foo.groups", "nobody");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        ProxyUser proxyUser = (ProxyUser)server.get(ProxyUser.class);
        Assert.assertNotNull((Object)proxyUser);
        proxyUser.validate("foo", "localhost", System.getProperty("user.name"));
        server.destroy();
    }
}

