/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.wsrs.Param;
import org.apache.hadoop.lib.wsrs.Parameters;

@InterfaceAudience.Private
public class ParametersProvider
extends AbstractHttpContextInjectable<Parameters>
implements InjectableProvider<Context, Type> {
    private String driverParam;
    private Class<? extends Enum> enumClass;
    private Map<Enum, Class<Param<?>>[]> paramsDef;

    public ParametersProvider(String driverParam, Class<? extends Enum> enumClass, Map<Enum, Class<Param<?>>[]> paramsDef) {
        this.driverParam = driverParam;
        this.enumClass = enumClass;
        this.paramsDef = paramsDef;
    }

    public Parameters getValue(HttpContext httpContext) {
        Object op;
        HashMap<String, Param> map = new HashMap<String, Param>();
        MultivaluedMap queryString = httpContext.getRequest().getQueryParameters();
        String str = (String)queryString.getFirst((Object)this.driverParam);
        if (str == null) {
            throw new IllegalArgumentException(MessageFormat.format("Missing Operation parameter [{0}]", this.driverParam));
        }
        try {
            op = Enum.valueOf(this.enumClass, str.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid Operation [{0}]", str));
        }
        if (!this.paramsDef.containsKey(op)) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported Operation [{0}]", op));
        }
        for (Class paramClass : (Class[])this.paramsDef.get(op)) {
            Param param;
            try {
                param = (Param)paramClass.newInstance();
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException(MessageFormat.format("Param class [{0}] does not have default constructor", paramClass.getName()));
            }
            try {
                param.parseParam((String)queryString.getFirst((Object)param.getName()));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString(), ex);
            }
            map.put(param.getName(), param);
        }
        return new Parameters(map);
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable getInjectable(ComponentContext componentContext, Context context, Type type) {
        return type.equals(Parameters.class) ? this : null;
    }
}

