/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestHdfsHelper;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHdfsHelper
extends TestDirHelper {
    public static final String HADOOP_MINI_HDFS = "test.hadoop.hdfs";
    private static ThreadLocal<Configuration> HDFS_CONF_TL = new InheritableThreadLocal();
    private static ThreadLocal<Path> HDFS_TEST_DIR_TL = new InheritableThreadLocal();
    private static MiniDFSCluster MINI_DFS = null;

    @Test
    public void dummy() {
    }

    public Statement apply(Statement statement, FrameworkMethod frameworkMethod, Object o) {
        TestHdfs testHdfsAnnotation = (TestHdfs)frameworkMethod.getAnnotation(TestHdfs.class);
        if (testHdfsAnnotation != null) {
            statement = new HdfsStatement(statement, frameworkMethod.getName());
        }
        return super.apply(statement, frameworkMethod, o);
    }

    public static Path getHdfsTestDir() {
        Path testDir = (Path)HDFS_TEST_DIR_TL.get();
        if (testDir == null) {
            throw new IllegalStateException("This test does not use @TestHdfs");
        }
        return testDir;
    }

    public static Configuration getHdfsConf() {
        Configuration conf = (Configuration)HDFS_CONF_TL.get();
        if (conf == null) {
            throw new IllegalStateException("This test does not use @TestHdfs");
        }
        return new Configuration(conf);
    }

    private static synchronized MiniDFSCluster startMiniHdfs(Configuration conf) throws Exception {
        if (MINI_DFS == null) {
            if (System.getProperty("hadoop.log.dir") == null) {
                System.setProperty("hadoop.log.dir", new File(TEST_DIR_ROOT, "hadoop-log").getAbsolutePath());
            }
            if (System.getProperty("test.build.data") == null) {
                System.setProperty("test.build.data", new File(TEST_DIR_ROOT, "hadoop-data").getAbsolutePath());
            }
            conf = new Configuration(conf);
            HadoopUsersConfTestHelper.addUserConf((Configuration)conf);
            conf.set("fs.hdfs.impl.disable.cache", "true");
            conf.set("dfs.block.access.token.enable", "false");
            conf.set("dfs.permissions", "true");
            conf.set("hadoop.security.authentication", "simple");
            MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
            builder.numDataNodes(2);
            MiniDFSCluster miniHdfs = builder.build();
            DistributedFileSystem fileSystem = miniHdfs.getFileSystem();
            fileSystem.mkdirs(new Path("/tmp"));
            fileSystem.mkdirs(new Path("/user"));
            fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
            fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
            MINI_DFS = miniHdfs;
        }
        return MINI_DFS;
    }

    static /* synthetic */ MiniDFSCluster access$000(Configuration x0) throws Exception {
        return TestHdfsHelper.startMiniHdfs((Configuration)x0);
    }

    static /* synthetic */ ThreadLocal access$100() {
        return HDFS_CONF_TL;
    }

    static /* synthetic */ ThreadLocal access$200() {
        return HDFS_TEST_DIR_TL;
    }
}

