/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.security;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.lang.XException;
import org.apache.hadoop.lib.server.BaseService;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.Groups;
import org.apache.hadoop.lib.service.ProxyUser;
import org.apache.hadoop.lib.service.security.ProxyUserService;
import org.apache.hadoop.lib.util.Check;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProxyUserService
extends BaseService
implements ProxyUser {
    private static Logger LOG = LoggerFactory.getLogger(ProxyUserService.class);
    private static final String PREFIX = "proxyuser";
    private static final String GROUPS = ".groups";
    private static final String HOSTS = ".hosts";
    private Map<String, Set<String>> proxyUserHosts = new HashMap();
    private Map<String, Set<String>> proxyUserGroups = new HashMap();

    public ProxyUserService() {
        super(PREFIX);
    }

    public Class getInterface() {
        return ProxyUser.class;
    }

    public Class[] getServiceDependencies() {
        return new Class[]{Groups.class};
    }

    protected void init() throws ServiceException {
        for (Map.Entry entry : this.getServiceConfig()) {
            HashSet<String> values;
            String value;
            String proxyUser;
            String key = (String)entry.getKey();
            if (key.endsWith(GROUPS)) {
                proxyUser = key.substring(0, key.lastIndexOf(GROUPS));
                if (this.getServiceConfig().get(proxyUser + HOSTS) == null) {
                    throw new ServiceException((XException.ERROR)ERROR.PRXU02, new Object[]{this.getPrefixedName(proxyUser + HOSTS)});
                }
                value = ((String)entry.getValue()).trim();
                LOG.info("Loading proxyuser settings [{}]=[{}]", (Object)key, (Object)value);
                values = null;
                if (!value.equals("*")) {
                    values = new HashSet<String>(Arrays.asList(value.split(",")));
                }
                this.proxyUserGroups.put(proxyUser, values);
            }
            if (!key.endsWith(HOSTS)) continue;
            proxyUser = key.substring(0, key.lastIndexOf(HOSTS));
            if (this.getServiceConfig().get(proxyUser + GROUPS) == null) {
                throw new ServiceException((XException.ERROR)ERROR.PRXU02, new Object[]{this.getPrefixedName(proxyUser + GROUPS)});
            }
            value = ((String)entry.getValue()).trim();
            LOG.info("Loading proxyuser settings [{}]=[{}]", (Object)key, (Object)value);
            values = null;
            if (!value.equals("*")) {
                String[] hosts = value.split(",");
                for (int i = 0; i < hosts.length; ++i) {
                    String originalName = hosts[i];
                    try {
                        hosts[i] = this.normalizeHostname(originalName);
                    }
                    catch (Exception ex) {
                        throw new ServiceException((XException.ERROR)ERROR.PRXU01, new Object[]{originalName, ex.getMessage(), ex});
                    }
                    LOG.info("  Hostname, original [{}], normalized [{}]", (Object)originalName, (Object)hosts[i]);
                }
                values = new HashSet<String>(Arrays.asList(hosts));
            }
            this.proxyUserHosts.put(proxyUser, values);
        }
    }

    public void validate(String proxyUser, String proxyHost, String doAsUser) throws IOException, AccessControlException {
        Check.notEmpty((String)proxyUser, (String)"proxyUser");
        Check.notEmpty((String)proxyHost, (String)"proxyHost");
        Check.notEmpty((String)doAsUser, (String)"doAsUser");
        LOG.debug("Authorization check proxyuser [{}] host [{}] doAs [{}]", new Object[]{proxyUser, proxyHost, doAsUser});
        if (!this.proxyUserHosts.containsKey(proxyUser)) {
            throw new AccessControlException(MessageFormat.format("User [{0}] not defined as proxyuser", proxyUser));
        }
        proxyHost = this.normalizeHostname(proxyHost);
        this.validateRequestorHost(proxyUser, proxyHost, (Set)this.proxyUserHosts.get(proxyUser));
        this.validateGroup(proxyUser, doAsUser, (Set)this.proxyUserGroups.get(proxyUser));
    }

    private void validateRequestorHost(String proxyUser, String hostname, Set<String> validHosts) throws IOException, AccessControlException {
        if (validHosts != null && !validHosts.contains(hostname) && !validHosts.contains(this.normalizeHostname(hostname))) {
            throw new AccessControlException(MessageFormat.format("Unauthorized host [{0}] for proxyuser [{1}]", hostname, proxyUser));
        }
    }

    private void validateGroup(String proxyUser, String user, Set<String> validGroups) throws IOException, AccessControlException {
        if (validGroups != null) {
            List userGroups = ((Groups)this.getServer().get(Groups.class)).getGroups(user);
            for (String g : validGroups) {
                if (!userGroups.contains(g)) continue;
                return;
            }
            throw new AccessControlException(MessageFormat.format("Unauthorized proxyuser [{0}] for user [{1}], not in proxyuser groups", proxyUser, user));
        }
    }

    private String normalizeHostname(String name) {
        try {
            InetAddress address = InetAddress.getByName(name);
            return address.getCanonicalHostName();
        }
        catch (IOException ex) {
            throw new AccessControlException(MessageFormat.format("Could not resolve host [{0}], {1}", name, ex.getMessage()));
        }
    }
}

