/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.gridmix.PseudoLocalFs;
import org.apache.hadoop.util.Progressable;

class PseudoLocalFs
extends FileSystem {
    Path home;
    private static final long TIME = System.currentTimeMillis();
    private static final String HOME_DIR = "/";
    private static final long BLOCK_SIZE = 0x400000L;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    static final URI NAME = URI.create("pseudo:///");

    PseudoLocalFs() {
        this(new Path(HOME_DIR));
    }

    PseudoLocalFs(Path home) {
        this.home = home;
    }

    public URI getUri() {
        return NAME;
    }

    public Path getHomeDirectory() {
        return this.home;
    }

    public Path getWorkingDirectory() {
        return this.getHomeDirectory();
    }

    static Path generateFilePath(String fileId, long fileSize) {
        return new Path(fileId + "." + fileSize);
    }

    public FSDataOutputStream create(Path path) throws IOException {
        try {
            this.validateFileNameFormat(path);
        }
        catch (FileNotFoundException e) {
            throw new IOException("File creation failed for " + path);
        }
        return null;
    }

    long validateFileNameFormat(Path path) throws FileNotFoundException {
        path = path.makeQualified((FileSystem)this);
        boolean valid = true;
        long fileSize = 0L;
        if (!path.toUri().getScheme().equals(this.getUri().getScheme())) {
            valid = false;
        } else {
            String[] parts = path.toUri().getPath().split("\\.");
            try {
                fileSize = Long.valueOf(parts[parts.length - 1]);
                valid = fileSize >= 0L;
            }
            catch (NumberFormatException e) {
                valid = false;
            }
        }
        if (!valid) {
            throw new FileNotFoundException("File " + path + " does not exist in pseudo local file system");
        }
        return fileSize;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        long fileSize = this.validateFileNameFormat(path);
        RandomInputStream in = new RandomInputStream(fileSize, bufferSize);
        return new FSDataInputStream((InputStream)in);
    }

    public FSDataInputStream open(Path path) throws IOException {
        return this.open(path, 0x100000);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        long fileSize = this.validateFileNameFormat(path);
        return new FileStatus(fileSize, false, 1, 0x400000L, TIME, path);
    }

    public boolean exists(Path path) {
        try {
            this.validateFileNameFormat(path);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return true;
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(path);
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        return new FileStatus[]{this.getFileStatus(path)};
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported in pseudo local file system.");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException("Mkdirs is not supported in pseudo local file system.");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("Rename is not supported in pseudo local file system.");
    }

    public boolean delete(Path path, boolean recursive) {
        throw new UnsupportedOperationException("File deletion is not supported in pseudo local file system.");
    }

    public void setWorkingDirectory(Path newDir) {
        throw new UnsupportedOperationException("SetWorkingDirectory is not supported in pseudo local file system.");
    }
}

