/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class GenerateData
extends GridmixJob {
    public static final String GRIDMIX_GEN_BYTES = "gridmix.gen.bytes";
    public static final String GRIDMIX_GEN_CHUNK = "gridmix.gen.bytes.per.file";
    public static final String GRIDMIX_VAL_BYTES = "gendata.val.bytes";
    public static final String GRIDMIX_GEN_INTERVAL = "gendata.interval.mb";
    public static final String GRIDMIX_GEN_BLOCKSIZE = "gridmix.gen.blocksize";
    public static final String GRIDMIX_GEN_REPLICATION = "gridmix.gen.replicas";
    static final String JOB_NAME = "GRIDMIX_GENERATE_INPUT_DATA";

    public GenerateData(Configuration conf, Path outdir, long genbytes) throws IOException {
        super(conf, 0L, "GRIDMIX_GENERATE_INPUT_DATA");
        this.job.getConfiguration().setLong("gridmix.gen.bytes", genbytes);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outdir);
    }

    static DataStatistics publishDataStatistics(Path inputDir, long genBytes, Configuration conf) throws IOException {
        if (CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf)) {
            return CompressionEmulationUtil.publishCompressedDataStatistics((Path)inputDir, (Configuration)conf, (long)genBytes);
        }
        return GenerateData.publishPlainDataStatistics((Configuration)conf, (Path)inputDir);
    }

    static DataStatistics publishPlainDataStatistics(Configuration conf, Path inputDir) throws IOException {
        FileSystem fs = inputDir.getFileSystem(conf);
        long dataSize = 0L;
        long fileCount = 0L;
        RemoteIterator iter = fs.listFiles(inputDir, true);
        Utils.OutputFileUtils.OutputFilesFilter filter = new Utils.OutputFileUtils.OutputFilesFilter();
        while (iter.hasNext()) {
            LocatedFileStatus lStatus = (LocatedFileStatus)iter.next();
            if (!filter.accept(lStatus.getPath())) continue;
            dataSize += lStatus.getLen();
            ++fileCount;
        }
        LOG.info((Object)("Total size of input data : " + StringUtils.humanReadableInt((long)dataSize)));
        LOG.info((Object)("Total number of input data files : " + fileCount));
        return new DataStatistics(dataSize, fileCount, false);
    }

    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        return this.job;
    }

    protected boolean canEmulateCompression() {
        return false;
    }
}

