/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.RandomAlgorithms;
import org.apache.hadoop.mapred.gridmix.SleepJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.ReduceTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public class SleepJob
extends GridmixJob {
    public static final Log LOG = LogFactory.getLog(SleepJob.class);
    private static final ThreadLocal<Random> rand = new /* Unavailable Anonymous Inner Class!! */;
    public static final String SLEEPJOB_MAPTASK_ONLY = "gridmix.sleep.maptask-only";
    private final boolean mapTasksOnly;
    private final int fakeLocations;
    private final String[] hosts;
    private final RandomAlgorithms.Selector selector;
    public static final String GRIDMIX_SLEEP_INTERVAL = "gridmix.sleep.interval";
    public static final String GRIDMIX_SLEEP_MAX_MAP_TIME = "gridmix.sleep.max-map-time";
    public static final String GRIDMIX_SLEEP_MAX_REDUCE_TIME = "gridmix.sleep.max-reduce-time";
    private final long mapMaxSleepTime;
    private final long reduceMaxSleepTime;

    public SleepJob(Configuration conf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq, int numLocations, String[] hosts) throws IOException {
        super(conf, submissionMillis, jobdesc, outRoot, ugi, seq);
        this.fakeLocations = numLocations;
        this.hosts = (String[])hosts.clone();
        this.selector = this.fakeLocations > 0 ? new RandomAlgorithms.Selector(hosts.length, (double)((float)this.fakeLocations / (float)hosts.length), (Random)rand.get()) : null;
        this.mapTasksOnly = conf.getBoolean("gridmix.sleep.maptask-only", false);
        this.mapMaxSleepTime = conf.getLong("gridmix.sleep.max-map-time", Long.MAX_VALUE);
        this.reduceMaxSleepTime = conf.getLong("gridmix.sleep.max-reduce-time", Long.MAX_VALUE);
    }

    protected boolean canEmulateCompression() {
        return false;
    }

    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        this.ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        return this.job;
    }

    private TaskAttemptInfo getSuccessfulAttemptInfo(TaskType type, int task) {
        TaskAttemptInfo ret;
        int i = 0;
        while ((ret = this.jobdesc.getTaskAttemptInfo(type, task, i)).getRunState() != TaskStatus.State.SUCCEEDED) {
            ++i;
        }
        if (ret.getRunState() != TaskStatus.State.SUCCEEDED) {
            LOG.warn((Object)("No sucessful attempts tasktype " + type + " task " + task));
        }
        return ret;
    }

    void buildSplits(FilePool inputDir) throws IOException {
        ArrayList<SleepSplit> splits = new ArrayList<SleepSplit>();
        int reds = this.mapTasksOnly ? 0 : this.jobdesc.getNumberReduces();
        int maps = this.jobdesc.getNumberMaps();
        for (int i = 0; i < maps; ++i) {
            int index;
            int nSpec = reds / maps + (reds % maps > i ? 1 : 0);
            long[] redDurations = new long[nSpec];
            for (int j = 0; j < nSpec; ++j) {
                ReduceTaskAttemptInfo info = (ReduceTaskAttemptInfo)this.getSuccessfulAttemptInfo(TaskType.REDUCE, i + j * maps);
                redDurations[j] = Math.min(this.reduceMaxSleepTime, info.getMergeRuntime() + info.getReduceRuntime());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("SPEC(%d) %d -> %d %d/%d", this.id(), i, i + j * maps, redDurations[j], info.getRuntime()));
            }
            TaskAttemptInfo info = this.getSuccessfulAttemptInfo(TaskType.MAP, i);
            ArrayList<String> locations = new ArrayList<String>(this.fakeLocations);
            if (this.fakeLocations > 0) {
                this.selector.reset();
            }
            for (int k = 0; k < this.fakeLocations && (index = this.selector.next()) >= 0; ++k) {
                locations.add(this.hosts[index]);
            }
            splits.add(new SleepSplit(i, Math.min(info.getRuntime(), this.mapMaxSleepTime), redDurations, maps, locations.toArray(new String[locations.size()])));
        }
        SleepJob.pushDescription((int)this.id(), splits);
    }

    static /* synthetic */ boolean access$000(SleepJob x0) {
        return x0.mapTasksOnly;
    }
}

