/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.Logalyzer;
import org.junit.Assert;
import org.junit.Test;

public class TestLogalyzer {
    private static String EL = System.getProperty("line.separator");
    private static String TAB = "\t";
    private static final Log LOG = LogFactory.getLog(TestLogalyzer.class);
    private static File workSpace = new File("target", TestLogalyzer.class.getName() + "-workSpace");
    private static File outdir = new File(workSpace.getAbsoluteFile() + File.separator + "out");

    @Test
    public void testLogalyzer() throws Exception {
        Path f = this.createLogFile();
        String[] args = new String[]{"-archiveDir", f.toString(), "-grep", "44", "-sort", "0", "-analysis", outdir.getAbsolutePath(), "-separator", " "};
        Logalyzer.main((String[])args);
        this.checkResult();
    }

    private void checkResult() throws Exception {
        File result = new File(outdir.getAbsolutePath() + File.separator + "part-00000");
        File success = new File(outdir.getAbsolutePath() + File.separator + "_SUCCESS");
        Assert.assertTrue((boolean)success.exists());
        FileInputStream fis = new FileInputStream(result);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        String line = br.readLine();
        Assert.assertTrue((boolean)("1 44" + TAB + "2").equals(line));
        line = br.readLine();
        Assert.assertTrue((boolean)("3 44" + TAB + "1").equals(line));
        line = br.readLine();
        Assert.assertTrue((boolean)("4 44" + TAB + "1").equals(line));
        br.close();
    }

    private Path createLogFile() throws IOException {
        FileContext files = FileContext.getLocalFSFileContext();
        Path ws = new Path(workSpace.getAbsoluteFile().getAbsolutePath());
        files.delete(ws, true);
        Path workSpacePath = new Path(workSpace.getAbsolutePath(), "log");
        files.mkdir(workSpacePath, null, true);
        LOG.info((Object)"create logfile.log");
        Path logfile1 = new Path(workSpacePath, "logfile.log");
        FSDataOutputStream os = files.create(logfile1, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        os.writeBytes("4 3" + EL + "1 3" + EL + "4 44" + EL);
        os.writeBytes("2 3" + EL + "1 3" + EL + "0 45" + EL);
        os.writeBytes("4 3" + EL + "1 3" + EL + "1 44" + EL);
        os.flush();
        os.close();
        LOG.info((Object)"create logfile1.log");
        Path logfile2 = new Path(workSpacePath, "logfile1.log");
        os = files.create(logfile2, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        os.writeBytes("4 3" + EL + "1 3" + EL + "3 44" + EL);
        os.writeBytes("2 3" + EL + "1 3" + EL + "0 45" + EL);
        os.writeBytes("4 3" + EL + "1 3" + EL + "1 44" + EL);
        os.flush();
        os.close();
        return workSpacePath;
    }
}

