/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public final class CopyListingFileStatus
extends FileStatus {
    private static final byte NO_ACL_ENTRIES = -1;
    private static final int NO_XATTRS = -1;
    private static final AclEntryType[] ACL_ENTRY_TYPES = AclEntryType.values();
    private static final AclEntryScope[] ACL_ENTRY_SCOPES = AclEntryScope.values();
    private static final FsAction[] FS_ACTIONS = FsAction.values();
    private List<AclEntry> aclEntries;
    private Map<String, byte[]> xAttrs;

    public CopyListingFileStatus() {
    }

    public CopyListingFileStatus(FileStatus fileStatus) throws IOException {
        super(fileStatus);
    }

    public List<AclEntry> getAclEntries() {
        return AclUtil.getAclFromPermAndEntries((FsPermission)this.getPermission(), this.aclEntries != null ? this.aclEntries : Collections.emptyList());
    }

    public void setAclEntries(List<AclEntry> aclEntries) {
        this.aclEntries = aclEntries;
    }

    public Map<String, byte[]> getXAttrs() {
        return this.xAttrs;
    }

    public void setXAttrs(Map<String, byte[]> xAttrs) {
        this.xAttrs = xAttrs;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this.aclEntries != null) {
            out.writeByte(this.aclEntries.size());
            for (AclEntry aclEntry : this.aclEntries) {
                out.writeByte(aclEntry.getScope().ordinal());
                out.writeByte(aclEntry.getType().ordinal());
                WritableUtils.writeString((DataOutput)out, (String)aclEntry.getName());
                out.writeByte(aclEntry.getPermission().ordinal());
            }
        } else {
            out.writeByte(-1);
        }
        if (this.xAttrs != null) {
            out.writeInt(this.xAttrs.size());
            for (Map.Entry<String, byte[]> entry : this.xAttrs.entrySet()) {
                WritableUtils.writeString((DataOutput)out, (String)entry.getKey());
                byte[] value = entry.getValue();
                if (value != null) {
                    out.writeInt(value.length);
                    if (value.length <= 0) continue;
                    out.write(value);
                    continue;
                }
                out.writeInt(-1);
            }
        } else {
            out.writeInt(-1);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int xAttrsSize;
        super.readFields(in);
        int aclEntriesSize = in.readByte();
        if (aclEntriesSize != -1) {
            this.aclEntries = Lists.newArrayListWithCapacity((int)aclEntriesSize);
            for (int i = 0; i < aclEntriesSize; ++i) {
                this.aclEntries.add(new AclEntry.Builder().setScope(ACL_ENTRY_SCOPES[in.readByte()]).setType(ACL_ENTRY_TYPES[in.readByte()]).setName(WritableUtils.readString((DataInput)in)).setPermission(FS_ACTIONS[in.readByte()]).build());
            }
        } else {
            this.aclEntries = null;
        }
        if ((xAttrsSize = in.readInt()) != -1) {
            this.xAttrs = Maps.newHashMap();
            for (int i = 0; i < xAttrsSize; ++i) {
                String name = WritableUtils.readString((DataInput)in);
                int valueLen = in.readInt();
                byte[] value = null;
                if (valueLen > -1) {
                    value = new byte[valueLen];
                    if (valueLen > 0) {
                        in.readFully(value);
                    }
                }
                this.xAttrs.put(name, value);
            }
        } else {
            this.xAttrs = null;
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CopyListingFileStatus other = (CopyListingFileStatus)((Object)o);
        return Objects.equal(this.aclEntries, other.aclEntries) && Objects.equal(this.xAttrs, other.xAttrs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.aclEntries, this.xAttrs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('{');
        sb.append("aclEntries = " + this.aclEntries);
        sb.append(", xAttrs = " + this.xAttrs);
        sb.append('}');
        return sb.toString();
    }
}

