/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.OptionsParser;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.mapred.CopyOutputFormat;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistCp
extends Configured
implements Tool {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(DistCp.class);
    private DistCpOptions inputOptions;
    private Path metaFolder;
    private static final String PREFIX = "_distcp";
    private static final String WIP_PREFIX = "._WIP_";
    private static final String DISTCP_DEFAULT_XML = "distcp-default.xml";
    public static final Random rand = new Random();
    private boolean submitted;
    private FileSystem jobFS;

    public DistCp(Configuration configuration, DistCpOptions inputOptions) throws Exception {
        Configuration config = new Configuration(configuration);
        config.addResource("distcp-default.xml");
        this.setConf(config);
        this.inputOptions = inputOptions;
        this.metaFolder = this.createMetaFolderPath();
    }

    private DistCp() {
    }

    public int run(String[] argv) {
        if (argv.length < 1) {
            OptionsParser.usage();
            return -1;
        }
        try {
            this.inputOptions = OptionsParser.parse((String[])argv);
            LOG.info((Object)("Input Options: " + this.inputOptions));
        }
        catch (Throwable e) {
            LOG.error((Object)"Invalid arguments: ", e);
            System.err.println("Invalid arguments: " + e.getMessage());
            OptionsParser.usage();
            return -1;
        }
        try {
            this.execute();
        }
        catch (CopyListing.InvalidInputException e) {
            LOG.error((Object)"Invalid input: ", (Throwable)e);
            return -1;
        }
        catch (CopyListing.DuplicateFileException e) {
            LOG.error((Object)"Duplicate files in input path: ", (Throwable)e);
            return -2;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            return -999;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job execute() throws Exception {
        assert (this.inputOptions != null);
        assert (this.getConf() != null);
        Job job = null;
        try {
            DistCp distCp = this;
            synchronized (distCp) {
                this.metaFolder = this.createMetaFolderPath();
                this.jobFS = this.metaFolder.getFileSystem(this.getConf());
                job = this.createJob();
            }
            this.createInputFileListing(job);
            job.submit();
            this.submitted = true;
        }
        finally {
            if (!this.submitted) {
                this.cleanup();
            }
        }
        String jobID = job.getJobID().toString();
        job.getConfiguration().set("distcp.job.id", jobID);
        LOG.info((Object)("DistCp job-id: " + jobID));
        if (this.inputOptions.shouldBlock() && !job.waitForCompletion(true)) {
            throw new IOException("DistCp failure: Job " + jobID + " has failed: " + job.getStatus().getFailureInfo());
        }
        return job;
    }

    private Job createJob() throws IOException {
        String jobName = "distcp";
        String userChosenName = this.getConf().get("mapreduce.job.name");
        if (userChosenName != null) {
            jobName = jobName + ": " + userChosenName;
        }
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(jobName);
        job.setInputFormatClass(DistCpUtils.getStrategy((Configuration)this.getConf(), (DistCpOptions)this.inputOptions));
        job.setJarByClass(CopyMapper.class);
        this.configureOutputFormat(job);
        job.setMapperClass(CopyMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(CopyOutputFormat.class);
        job.getConfiguration().set("mapreduce.map.speculative", "false");
        job.getConfiguration().set("mapreduce.job.maps", String.valueOf(this.inputOptions.getMaxMaps()));
        if (this.inputOptions.getSslConfigurationFile() != null) {
            this.setupSSLConfig(job);
        }
        this.inputOptions.appendToConf(job.getConfiguration());
        return job;
    }

    private void setupSSLConfig(Job job) throws IOException {
        Configuration configuration = job.getConfiguration();
        Path sslConfigPath = new Path(configuration.getResource(this.inputOptions.getSslConfigurationFile()).toString());
        this.addSSLFilesToDistCache(job, sslConfigPath);
        configuration.set("distcp.keystore.resource", sslConfigPath.getName());
        configuration.set("dfs.https.client.keystore.resource", sslConfigPath.getName());
    }

    private void addSSLFilesToDistCache(Job job, Path sslConfigPath) throws IOException {
        Configuration configuration = job.getConfiguration();
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)configuration);
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(sslConfigPath);
        Path localStorePath = this.getLocalStorePath(sslConf, "ssl.client.truststore.location");
        job.addCacheFile(localStorePath.makeQualified(localFS.getUri(), localFS.getWorkingDirectory()).toUri());
        configuration.set("ssl.client.truststore.location", localStorePath.getName());
        localStorePath = this.getLocalStorePath(sslConf, "ssl.client.keystore.location");
        job.addCacheFile(localStorePath.makeQualified(localFS.getUri(), localFS.getWorkingDirectory()).toUri());
        configuration.set("ssl.client.keystore.location", localStorePath.getName());
        job.addCacheFile(sslConfigPath.makeQualified(localFS.getUri(), localFS.getWorkingDirectory()).toUri());
    }

    private Path getLocalStorePath(Configuration sslConf, String storeKey) throws IOException {
        if (sslConf.get(storeKey) != null) {
            return new Path(sslConf.get(storeKey));
        }
        throw new IOException("Store for " + storeKey + " is not set in " + this.inputOptions.getSslConfigurationFile());
    }

    private void configureOutputFormat(Job job) throws IOException {
        Configuration configuration = job.getConfiguration();
        Path targetPath = this.inputOptions.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(configuration);
        targetPath = targetPath.makeQualified(targetFS.getUri(), targetFS.getWorkingDirectory());
        if (this.inputOptions.shouldAtomicCommit()) {
            FileSystem workFS;
            Path workDir = this.inputOptions.getAtomicWorkPath();
            if (workDir == null) {
                workDir = targetPath.getParent();
            }
            if (!DistCpUtils.compareFs((FileSystem)targetFS, (FileSystem)(workFS = (workDir = new Path(workDir, "._WIP_" + targetPath.getName() + rand.nextInt())).getFileSystem(configuration)))) {
                throw new IllegalArgumentException("Work path " + workDir + " and target path " + targetPath + " are in different file system");
            }
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)workDir);
        } else {
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)targetPath);
        }
        CopyOutputFormat.setCommitDirectory((Job)job, (Path)targetPath);
        Path logPath = this.inputOptions.getLogPath();
        if (logPath == null) {
            logPath = new Path(this.metaFolder, "_logs");
        } else {
            LOG.info((Object)("DistCp job log path: " + logPath));
        }
        CopyOutputFormat.setOutputPath((Job)job, (Path)logPath);
    }

    private Path createInputFileListing(Job job) throws IOException {
        Path fileListingPath = this.getFileListingPath();
        CopyListing copyListing = CopyListing.getCopyListing((Configuration)job.getConfiguration(), (Credentials)job.getCredentials(), (DistCpOptions)this.inputOptions);
        copyListing.buildListing(fileListingPath, this.inputOptions);
        return fileListingPath;
    }

    private Path getFileListingPath() throws IOException {
        String fileListPathStr = this.metaFolder + "/fileList.seq";
        Path path = new Path(fileListPathStr);
        return new Path(path.toUri().normalize().toString());
    }

    private Path createMetaFolderPath() throws Exception {
        Configuration configuration = this.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(configuration), (Configuration)configuration);
        Path metaFolderPath = new Path(stagingDir, "_distcp" + String.valueOf(rand.nextInt()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Meta folder location: " + metaFolderPath));
        }
        configuration.set("distcp.meta.folder", metaFolderPath.toString());
        return metaFolderPath;
    }

    public static void main(String[] argv) {
        int exitCode;
        try {
            DistCp distCp = new DistCp();
            Cleanup CLEANUP = new Cleanup(distCp);
            ShutdownHookManager.get().addShutdownHook((Runnable)CLEANUP, 30);
            exitCode = ToolRunner.run((Configuration)DistCp.getDefaultConf(), (Tool)distCp, (String[])argv);
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't complete DistCp operation: ", (Throwable)e);
            exitCode = -999;
        }
        System.exit(exitCode);
    }

    private static Configuration getDefaultConf() {
        Configuration config = new Configuration();
        config.addResource("distcp-default.xml");
        return config;
    }

    private synchronized void cleanup() {
        try {
            if (this.metaFolder == null) {
                return;
            }
            this.jobFS.delete(this.metaFolder, true);
            this.metaFolder = null;
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to cleanup meta folder: " + this.metaFolder), (Throwable)e);
        }
    }

    private boolean isSubmitted() {
        return this.submitted;
    }

    static /* synthetic */ boolean access$000(DistCp x0) {
        return x0.isSubmitted();
    }

    static /* synthetic */ void access$100(DistCp x0) {
        x0.cleanup();
    }
}

