/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.UniformSizeInputFormat;

public class DistCpUtils {
    private static final Log LOG = LogFactory.getLog(DistCpUtils.class);
    private static ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.0");
        }
    };

    public static long getFileSize(Path path, Configuration configuration) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving file size for: " + path));
        }
        return path.getFileSystem(configuration).getFileStatus(path).getLen();
    }

    public static <T> void publish(Configuration configuration, String label, T value) {
        configuration.set(label, String.valueOf(value));
    }

    public static int getInt(Configuration configuration, String label) {
        int value = configuration.getInt(label, -1);
        assert (value >= 0) : "Couldn't find " + label;
        return value;
    }

    public static long getLong(Configuration configuration, String label) {
        long value = configuration.getLong(label, -1L);
        assert (value >= 0L) : "Couldn't find " + label;
        return value;
    }

    public static Class<? extends InputFormat> getStrategy(Configuration conf, DistCpOptions options) {
        String confLabel = "distcp." + options.getCopyStrategy().toLowerCase(Locale.getDefault()) + ".strategy.impl";
        return conf.getClass(confLabel, UniformSizeInputFormat.class, InputFormat.class);
    }

    public static String getRelativePath(Path sourceRootPath, Path childPath) {
        String childPathString = childPath.toUri().getPath();
        String sourceRootPathString = sourceRootPath.toUri().getPath();
        return sourceRootPathString.equals("/") ? childPathString : childPathString.substring(sourceRootPathString.length());
    }

    public static String packAttributes(EnumSet<DistCpOptions.FileAttribute> attributes) {
        StringBuffer buffer = new StringBuffer(5);
        int len = 0;
        for (DistCpOptions.FileAttribute attribute : attributes) {
            buffer.append(attribute.name().charAt(0));
            ++len;
        }
        return buffer.substring(0, len);
    }

    public static EnumSet<DistCpOptions.FileAttribute> unpackAttributes(String attributes) {
        EnumSet<DistCpOptions.FileAttribute> retValue = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        if (attributes != null) {
            for (int index = 0; index < attributes.length(); ++index) {
                retValue.add(DistCpOptions.FileAttribute.getAttribute(attributes.charAt(index)));
            }
        }
        return retValue;
    }

    public static void preserve(FileSystem targetFS, Path path, FileStatus srcFileStatus, EnumSet<DistCpOptions.FileAttribute> attributes) throws IOException {
        FileStatus targetFileStatus = targetFS.getFileStatus(path);
        String group = targetFileStatus.getGroup();
        String user = targetFileStatus.getOwner();
        boolean chown = false;
        if (attributes.contains((Object)DistCpOptions.FileAttribute.PERMISSION) && !srcFileStatus.getPermission().equals((Object)targetFileStatus.getPermission())) {
            targetFS.setPermission(path, srcFileStatus.getPermission());
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) && !targetFileStatus.isDirectory() && srcFileStatus.getReplication() != targetFileStatus.getReplication()) {
            targetFS.setReplication(path, srcFileStatus.getReplication());
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.GROUP) && !group.equals(srcFileStatus.getGroup())) {
            group = srcFileStatus.getGroup();
            chown = true;
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.USER) && !user.equals(srcFileStatus.getOwner())) {
            user = srcFileStatus.getOwner();
            chown = true;
        }
        if (chown) {
            targetFS.setOwner(path, user, group);
        }
    }

    public static Path sortListing(FileSystem fs, Configuration conf, Path sourceListing) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, Text.class, FileStatus.class, conf);
        Path output = new Path(sourceListing.toString() + "_sorted");
        if (fs.exists(output)) {
            fs.delete(output, false);
        }
        sorter.sort(sourceListing, output);
        return output;
    }

    public static DecimalFormat getFormatter() {
        return FORMATTER.get();
    }

    public static String getStringDescriptionFor(long nBytes) {
        double current;
        char[] units = new char[]{'B', 'K', 'M', 'G', 'T', 'P'};
        double prev = current = (double)nBytes;
        int index = 0;
        while (true) {
            double d;
            current /= 1024.0;
            if (!(d >= 1.0)) break;
            prev = current;
            ++index;
        }
        assert (index < units.length) : "Too large a number.";
        return DistCpUtils.getFormatter().format(prev) + units[index];
    }

    public static boolean checksumsAreEqual(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target) throws IOException {
        FileChecksum targetChecksum = null;
        try {
            sourceChecksum = sourceChecksum != null ? sourceChecksum : sourceFS.getFileChecksum(source);
            targetChecksum = targetFS.getFileChecksum(target);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to retrieve checksum for " + source + " or " + target), (Throwable)e);
        }
        return sourceChecksum == null || targetChecksum == null || sourceChecksum.equals((Object)targetChecksum);
    }

    public static boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) {
            return false;
        }
        if (!srcUri.getScheme().equals(dstUri.getScheme())) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            try {
                srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
            }
            catch (UnknownHostException ue) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Could not compare file-systems. Unknown host: ", (Throwable)ue);
                }
                return false;
            }
            if (!srcHost.equals(dstHost)) {
                return false;
            }
        } else {
            if (srcHost == null && dstHost != null) {
                return false;
            }
            if (srcHost != null) {
                return false;
            }
        }
        return srcUri.getPort() == dstUri.getPort();
    }
}

