/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.RetriableFileCopyCommand;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.RetriableCommand;
import org.apache.hadoop.tools.util.ThrottledInputStream;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
public class RetriableFileCopyCommand
extends RetriableCommand {
    private static Log LOG = LogFactory.getLog(RetriableFileCopyCommand.class);
    private static int BUFFER_SIZE = 8192;
    private boolean skipCrc = false;

    public RetriableFileCopyCommand(String description) {
        super(description);
    }

    public RetriableFileCopyCommand(boolean skipCrc, String description) {
        this(description);
        this.skipCrc = skipCrc;
    }

    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 4) : "Unexpected argument list.";
        FileStatus source = (FileStatus)arguments[0];
        assert (!source.isDirectory()) : "Unexpected file-status. Expected file.";
        Path target = (Path)arguments[1];
        Mapper.Context context = (Mapper.Context)arguments[2];
        EnumSet fileAttributes = (EnumSet)arguments[3];
        return this.doCopy(source, target, context, fileAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCopy(FileStatus sourceFileStatus, Path target, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        Path tmpTargetPath = this.getTmpFile(target, context);
        Configuration configuration = context.getConfiguration();
        FileSystem targetFS = target.getFileSystem(configuration);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copying " + sourceFileStatus.getPath() + " to " + target));
                LOG.debug((Object)("Tmp-file path: " + tmpTargetPath));
            }
            Path sourcePath = sourceFileStatus.getPath();
            FileSystem sourceFS = sourcePath.getFileSystem(configuration);
            FileChecksum sourceChecksum = fileAttributes.contains(DistCpOptions.FileAttribute.CHECKSUMTYPE) ? sourceFS.getFileChecksum(sourcePath) : null;
            long bytesRead = this.copyToTmpFile(tmpTargetPath, targetFS, sourceFileStatus, context, fileAttributes, sourceChecksum);
            this.compareFileLengths(sourceFileStatus, tmpTargetPath, configuration, bytesRead);
            if (bytesRead != 0L && !this.skipCrc) {
                this.compareCheckSums(sourceFS, sourceFileStatus.getPath(), sourceChecksum, targetFS, tmpTargetPath);
            }
            this.promoteTmpToTarget(tmpTargetPath, target, targetFS);
            long l = bytesRead;
            return l;
        }
        finally {
            if (targetFS.exists(tmpTargetPath)) {
                targetFS.delete(tmpTargetPath, false);
            }
        }
    }

    private Options.ChecksumOpt getChecksumOpt(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) {
        if (fileAttributes.contains(DistCpOptions.FileAttribute.CHECKSUMTYPE) && sourceChecksum != null) {
            return sourceChecksum.getChecksumOpt();
        }
        return null;
    }

    private long copyToTmpFile(Path tmpTargetPath, FileSystem targetFS, FileStatus sourceFileStatus, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) throws IOException {
        FsPermission permission = FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)targetFS.getConf()));
        BufferedOutputStream outStream = new BufferedOutputStream((OutputStream)targetFS.create(tmpTargetPath, permission, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), BUFFER_SIZE, RetriableFileCopyCommand.getReplicationFactor(fileAttributes, (FileStatus)sourceFileStatus, (FileSystem)targetFS, (Path)tmpTargetPath), RetriableFileCopyCommand.getBlockSize(fileAttributes, (FileStatus)sourceFileStatus, (FileSystem)targetFS, (Path)tmpTargetPath), (Progressable)context, this.getChecksumOpt(fileAttributes, sourceChecksum)));
        return this.copyBytes(sourceFileStatus, (OutputStream)outStream, BUFFER_SIZE, context);
    }

    private void compareFileLengths(FileStatus sourceFileStatus, Path target, Configuration configuration, long bytesRead) throws IOException {
        Path sourcePath = sourceFileStatus.getPath();
        FileSystem fs = sourcePath.getFileSystem(configuration);
        if (fs.getFileStatus(sourcePath).getLen() != bytesRead) {
            throw new IOException("Mismatch in length of source:" + sourcePath + " and target:" + target);
        }
    }

    private void compareCheckSums(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target) throws IOException {
        if (!DistCpUtils.checksumsAreEqual((FileSystem)sourceFS, (Path)source, (FileChecksum)sourceChecksum, (FileSystem)targetFS, (Path)target)) {
            StringBuilder errorMessage = new StringBuilder("Check-sum mismatch between ").append(source).append(" and ").append(target).append(".");
            if (sourceFS.getFileStatus(source).getBlockSize() != targetFS.getFileStatus(target).getBlockSize()) {
                errorMessage.append(" Source and target differ in block-size.").append(" Use -pb to preserve block-sizes during copy.").append(" Alternatively, skip checksum-checks altogether, using -skipCrc.").append(" (NOTE: By skipping checksums, one runs the risk of masking data-corruption during file-transfer.)");
            }
            throw new IOException(errorMessage.toString());
        }
    }

    private void promoteTmpToTarget(Path tmpTarget, Path target, FileSystem fs) throws IOException {
        if (fs.exists(target) && !fs.delete(target, false) || !fs.exists(target.getParent()) && !fs.mkdirs(target.getParent()) || !fs.rename(tmpTarget, target)) {
            throw new IOException("Failed to promote tmp-file:" + tmpTarget + " to: " + target);
        }
    }

    private Path getTmpFile(Path target, Mapper.Context context) {
        Path targetWorkPath = new Path(context.getConfiguration().get("distcp.target.work.path"));
        Path root = target.equals((Object)targetWorkPath) ? targetWorkPath.getParent() : targetWorkPath;
        LOG.info((Object)("Creating temp file: " + new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString())));
        return new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long copyBytes(FileStatus sourceFileStatus, OutputStream outStream, int bufferSize, Mapper.Context context) throws IOException {
        Path source = sourceFileStatus.getPath();
        byte[] buf = new byte[bufferSize];
        ThrottledInputStream inStream = null;
        long totalBytesRead = 0L;
        try {
            inStream = RetriableFileCopyCommand.getInputStream((Path)source, (Configuration)context.getConfiguration());
            int bytesRead = RetriableFileCopyCommand.readBytes((InputStream)inStream, (byte[])buf);
            while (bytesRead >= 0) {
                outStream.write(buf, 0, bytesRead);
                this.updateContextStatus(totalBytesRead += (long)bytesRead, context, sourceFileStatus);
                bytesRead = inStream.read(buf);
            }
            outStream.close();
            outStream = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{outStream, inStream});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{outStream, inStream});
        return totalBytesRead;
    }

    private void updateContextStatus(long totalBytesRead, Mapper.Context context, FileStatus sourceFileStatus) {
        StringBuilder message = new StringBuilder(DistCpUtils.getFormatter().format((float)totalBytesRead * 100.0f / (float)sourceFileStatus.getLen()));
        message.append("% ").append(this.description).append(" [").append(DistCpUtils.getStringDescriptionFor((long)totalBytesRead)).append('/').append(DistCpUtils.getStringDescriptionFor((long)sourceFileStatus.getLen())).append(']');
        context.setStatus(message.toString());
    }

    private static int readBytes(InputStream inStream, byte[] buf) throws IOException {
        try {
            return inStream.read(buf);
        }
        catch (IOException e) {
            throw new CopyReadException((Throwable)e);
        }
    }

    private static ThrottledInputStream getInputStream(Path path, Configuration conf) throws IOException {
        try {
            FileSystem fs = path.getFileSystem(conf);
            long bandwidthMB = conf.getInt("distcp.map.bandwidth.mb", 100);
            return new ThrottledInputStream((InputStream)new BufferedInputStream((InputStream)fs.open(path)), bandwidthMB * 1024L * 1024L);
        }
        catch (IOException e) {
            throw new CopyReadException((Throwable)e);
        }
    }

    private static short getReplicationFactor(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS, Path tmpTargetPath) {
        return fileAttributes.contains(DistCpOptions.FileAttribute.REPLICATION) ? sourceFile.getReplication() : targetFS.getDefaultReplication(tmpTargetPath);
    }

    private static long getBlockSize(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS, Path tmpTargetPath) {
        boolean preserve = fileAttributes.contains(DistCpOptions.FileAttribute.BLOCKSIZE) || fileAttributes.contains(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        return preserve ? sourceFile.getBlockSize() : targetFS.getDefaultBlockSize(tmpTargetPath);
    }
}

