/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.util.TestThrottledInputStream;
import org.apache.hadoop.tools.util.ThrottledInputStream;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestThrottledInputStream {
    private static final Log LOG = LogFactory.getLog(TestThrottledInputStream.class);
    private static final int BUFF_SIZE = 1024;

    @Test
    public void testRead() {
        try {
            File tmpFile = this.createFile(1024L);
            File outFile = this.createFile();
            tmpFile.deleteOnExit();
            outFile.deleteOnExit();
            long maxBandwidth = this.copyAndAssert(tmpFile, outFile, 0L, 1.0f, -1, CB.BUFFER);
            this.copyAndAssert(tmpFile, outFile, maxBandwidth, 20.0f, 0, CB.BUFFER);
            this.copyAndAssert(tmpFile, outFile, maxBandwidth, 20.0f, 0, CB.BUFF_OFFSET);
            this.copyAndAssert(tmpFile, outFile, maxBandwidth, 20.0f, 0, CB.ONE_C);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyAndAssert(File tmpFile, File outFile, long maxBandwidth, float factor, int sleepTime, CB flag) throws IOException {
        long bandwidth;
        long maxBPS = (long)((float)maxBandwidth / factor);
        ThrottledInputStream in = maxBandwidth == 0L ? new ThrottledInputStream((InputStream)new FileInputStream(tmpFile)) : new ThrottledInputStream((InputStream)new FileInputStream(tmpFile), maxBPS);
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            if (flag == CB.BUFFER) {
                TestThrottledInputStream.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
            } else if (flag == CB.BUFF_OFFSET) {
                TestThrottledInputStream.copyBytesWithOffset((InputStream)in, (OutputStream)out, (int)1024);
            } else {
                TestThrottledInputStream.copyByteByByte((InputStream)in, (OutputStream)out);
            }
            LOG.info((Object)in);
            bandwidth = in.getBytesPerSec();
            Assert.assertEquals((long)in.getTotalBytesRead(), (long)tmpFile.length());
            Assert.assertTrue(((double)in.getBytesPerSec() > (double)maxBandwidth / ((double)factor * 1.2) ? 1 : 0) != 0);
            Assert.assertTrue((in.getTotalSleepTime() > (long)sleepTime || in.getBytesPerSec() <= maxBPS ? 1 : 0) != 0);
        }
        finally {
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeStream((Closeable)out);
        }
        return bandwidth;
    }

    private static void copyBytesWithOffset(InputStream in, OutputStream out, int buffSize) throws IOException {
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf, 0, buffSize);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf);
        }
    }

    private static void copyByteByByte(InputStream in, OutputStream out) throws IOException {
        int ch = in.read();
        while (ch >= 0) {
            out.write(ch);
            ch = in.read();
        }
    }

    private static void copyBytes(InputStream in, OutputStream out, int buffSize) throws IOException {
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf);
        }
    }

    private File createFile(long sizeInKB) throws IOException {
        File tmpFile = this.createFile();
        this.writeToFile(tmpFile, sizeInKB);
        return tmpFile;
    }

    private File createFile() throws IOException {
        return File.createTempFile("tmp", "dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File tmpFile, long sizeInKB) throws IOException {
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            byte[] buffer = new byte[1024];
            for (long index = 0L; index < sizeInKB; ++index) {
                ((OutputStream)out).write(buffer);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }
}

