/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.tools.util.DistCpUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UniformSizeInputFormat
extends InputFormat<Text, FileStatus> {
    private static final Log LOG = LogFactory.getLog(UniformSizeInputFormat.class);

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        int numSplits = DistCpUtils.getInt((Configuration)configuration, (String)"mapreduce.job.maps");
        if (numSplits == 0) {
            return new ArrayList<InputSplit>();
        }
        return this.getSplits(configuration, numSplits, DistCpUtils.getLong((Configuration)configuration, (String)"mapred.total.bytes.expected"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InputSplit> getSplits(Configuration configuration, int numSplits, long totalSizeBytes) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numSplits);
        long nBytesPerSplit = (long)Math.ceil((double)totalSizeBytes * 1.0 / (double)numSplits);
        FileStatus srcFileStatus = new FileStatus();
        Text srcRelPath = new Text();
        long currentSplitSize = 0L;
        long lastSplitStart = 0L;
        long lastPosition = 0L;
        Path listingFilePath = UniformSizeInputFormat.getListingFilePath((Configuration)configuration);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Average bytes per map: " + nBytesPerSplit + ", Number of maps: " + numSplits + ", total size: " + totalSizeBytes));
        }
        SequenceFile.Reader reader = null;
        try {
            FileSplit split;
            reader = this.getListingFileReader(configuration);
            while (reader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                if (currentSplitSize + srcFileStatus.getLen() > nBytesPerSplit && lastPosition != 0L) {
                    split = new FileSplit(listingFilePath, lastSplitStart, lastPosition - lastSplitStart, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Creating split : " + split + ", bytes in split: " + currentSplitSize));
                    }
                    splits.add((InputSplit)split);
                    lastSplitStart = lastPosition;
                    currentSplitSize = 0L;
                }
                currentSplitSize += srcFileStatus.getLen();
                lastPosition = reader.getPosition();
            }
            if (lastPosition > lastSplitStart) {
                split = new FileSplit(listingFilePath, lastSplitStart, lastPosition - lastSplitStart, null);
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)("Creating split : " + split + ", bytes in split: " + currentSplitSize));
                }
                splits.add((InputSplit)split);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
        return splits;
    }

    private static Path getListingFilePath(Configuration configuration) {
        String listingFilePathString = configuration.get("distcp.listing.file.path", "");
        assert (!listingFilePathString.equals("")) : "Couldn't find listing file. Invalid input.";
        return new Path(listingFilePathString);
    }

    private SequenceFile.Reader getListingFileReader(Configuration configuration) {
        Path listingFilePath = UniformSizeInputFormat.getListingFilePath((Configuration)configuration);
        try {
            FileSystem fileSystem = listingFilePath.getFileSystem(configuration);
            if (!fileSystem.exists(listingFilePath)) {
                throw new IllegalArgumentException("Listing file doesn't exist at: " + listingFilePath);
            }
            return new SequenceFile.Reader(configuration, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)listingFilePath)});
        }
        catch (IOException exception) {
            LOG.error((Object)("Couldn't find listing file at: " + listingFilePath), (Throwable)exception);
            throw new IllegalArgumentException("Couldn't find listing-file at: " + listingFilePath, exception);
        }
    }

    public RecordReader<Text, FileStatus> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new SequenceFileRecordReader();
    }
}

