/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.utils.join;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;

public abstract class JobBase
implements Mapper,
Reducer {
    public static final Log LOG = LogFactory.getLog((String)"datajoin.job");
    private SortedMap<Object, Long> longCounters = null;
    private SortedMap<Object, Double> doubleCounters = null;

    protected void setLongValue(Object name, long value) {
        this.longCounters.put(name, value);
    }

    protected void setDoubleValue(Object name, double value) {
        this.doubleCounters.put(name, new Double(value));
    }

    protected Long getLongValue(Object name) {
        return (Long)this.longCounters.get(name);
    }

    protected Double getDoubleValue(Object name) {
        return (Double)this.doubleCounters.get(name);
    }

    protected Long addLongValue(Object name, long inc) {
        Long val = (Long)this.longCounters.get(name);
        Long retv = null;
        retv = val == null ? Long.valueOf(inc) : Long.valueOf(val + inc);
        this.longCounters.put(name, retv);
        return retv;
    }

    protected Double addDoubleValue(Object name, double inc) {
        Double val = (Double)this.doubleCounters.get(name);
        Double retv = null;
        retv = val == null ? new Double(inc) : new Double(val + inc);
        this.doubleCounters.put(name, retv);
        return retv;
    }

    protected void report() {
        LOG.info((Object)this.getReport());
    }

    protected String getReport() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : this.longCounters.entrySet()) {
            sb.append(e.getKey().toString()).append("\t").append(e.getValue()).append("\n");
        }
        for (Map.Entry e : this.doubleCounters.entrySet()) {
            sb.append(e.getKey().toString()).append("\t").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    public void configure(JobConf job) {
        this.longCounters = new TreeMap();
        this.doubleCounters = new TreeMap();
    }
}

