/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.rpcauth;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;

public final class KerberosAuthMethod
extends RpcAuthMethod {
    public static final Log LOG = LogFactory.getLog(KerberosAuthMethod.class);
    static final RpcAuthMethod INSTANCE = new KerberosAuthMethod();
    private static final String[] LOGIN_MODULES = new String[]{KerberosUtil.getKrb5LoginModuleName(), "com.sun.security.auth.module.Krb5LoginModule"};

    private KerberosAuthMethod() {
        super((byte)81, "kerberos", "GSSAPI", UserGroupInformation.AuthenticationMethod.KERBEROS);
    }

    @Override
    public String[] loginModules() {
        return LOGIN_MODULES;
    }

    @Override
    public UserGroupInformation getUser(UserGroupInformation ticket) {
        return ticket.getRealUser() != null ? ticket.getRealUser() : ticket;
    }

    @Override
    public void writeUGI(UserGroupInformation ugi, IpcConnectionContextProtos.UserInformationProto.Builder ugiProto) {
        ugiProto.setEffectiveUser(ugi.getUserName());
    }

    @Override
    public boolean isSasl() {
        return true;
    }

    @Override
    public boolean isNegotiable() {
        return true;
    }

    @Override
    public String getProtocol() throws IOException {
        String[] parts;
        String fullName = UserGroupInformation.getCurrentUser().getUserName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Kerberos principal name is " + fullName));
        }
        return (parts = fullName.split("[/@]", 3)).length > 1 ? parts[0] : "";
    }

    @Override
    public String getServerId() throws IOException {
        String[] parts;
        String fullName = UserGroupInformation.getCurrentUser().getUserName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Kerberos principal name is " + fullName));
        }
        return (parts = fullName.split("[/@]", 3)).length < 2 ? "" : parts[1];
    }

    @Override
    public SaslClient createSaslClient(Map<String, Object> saslProperties) throws IOException {
        String serverPrincipal = (String)saslProperties.get("org.apache.hadoop.auth.kerberos.principal");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating SASL " + this.mechanismName + " client. Server's Kerberos principal name is " + serverPrincipal));
        }
        if (serverPrincipal == null || serverPrincipal.length() == 0) {
            throw new IOException("Failed to specify server's Kerberos principal name");
        }
        String[] names = KerberosAuthMethod.splitKerberosName(serverPrincipal);
        if (names.length != 3) {
            throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
        }
        return Sasl.createSaslClient(new String[]{this.mechanismName}, null, names[0], names[1], saslProperties, null);
    }

    @Override
    public SaslServer createSaslServer(Server.Connection connection, final Map<String, Object> saslProperties) throws IOException, InterruptedException {
        String[] names;
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        String fullName = current.getUserName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Kerberos principal name is " + fullName));
        }
        if ((names = KerberosAuthMethod.splitKerberosName(fullName)).length != 3) {
            throw new AccessControlException("Kerberos principal name does NOT have the expected hostname part: " + fullName);
        }
        return current.doAs(new PrivilegedExceptionAction<SaslServer>(){

            @Override
            public SaslServer run() throws SaslException {
                return Sasl.createSaslServer(KerberosAuthMethod.this.mechanismName, names[0], names[1], saslProperties, new SaslGssCallbackHandler());
            }
        });
    }

    @Override
    public synchronized boolean shouldReLogin() throws IOException {
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = currentUser.getRealUser();
        return loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals(currentUser) || loginUser.equals(realUser));
    }

    @Override
    public void reLogin() throws IOException {
        if (UserGroupInformation.isLoginKeytabBased()) {
            UserGroupInformation.getLoginUser().reloginFromKeytab();
        } else if (UserGroupInformation.isLoginTicketBased()) {
            UserGroupInformation.getLoginUser().reloginFromTicketCache();
        }
    }

    public static String[] splitKerberosName(String fullName) {
        return fullName.split("[/@]");
    }

    public static class SaslGssCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (SaslRpcServer.LOG.isDebugEnabled()) {
                        SaslRpcServer.LOG.debug((Object)("SASL server GSSAPI callback: setting canonicalized client ID: " + authzid));
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

