/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.hadoop.fs.s3.Block;
import org.apache.hadoop.fs.s3.INode;

public class TestINode
extends TestCase {
    public void testSerializeFileWithSingleBlock() throws IOException {
        Block[] blocks = new Block[]{new Block(849282477840258181L, 128L)};
        INode inode = new INode(INode.FileType.FILE, blocks);
        TestINode.assertEquals((String)"Length", (long)21L, (long)inode.getSerializedLength());
        InputStream in = inode.serialize();
        INode deserialized = INode.deserialize((InputStream)in);
        TestINode.assertEquals((String)"FileType", (Object)inode.getFileType(), (Object)deserialized.getFileType());
        Block[] deserializedBlocks = deserialized.getBlocks();
        TestINode.assertEquals((String)"Length", (int)1, (int)deserializedBlocks.length);
        TestINode.assertEquals((String)"Id", (long)blocks[0].getId(), (long)deserializedBlocks[0].getId());
        TestINode.assertEquals((String)"Length", (long)blocks[0].getLength(), (long)deserializedBlocks[0].getLength());
    }

    public void testSerializeDirectory() throws IOException {
        INode inode = INode.DIRECTORY_INODE;
        TestINode.assertEquals((String)"Length", (long)1L, (long)inode.getSerializedLength());
        InputStream in = inode.serialize();
        INode deserialized = INode.deserialize((InputStream)in);
        TestINode.assertSame((Object)INode.DIRECTORY_INODE, (Object)deserialized);
    }

    public void testDeserializeNull() throws IOException {
        TestINode.assertNull((Object)INode.deserialize(null));
    }
}

