/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestIdentityProviders {
    @Test
    public void testPluggableIdentityProvider() {
        Configuration conf = new Configuration();
        conf.set("identity-provider.impl", "org.apache.hadoop.ipc.UserIdentityProvider");
        List providers = conf.getInstances("identity-provider.impl", IdentityProvider.class);
        Assert.assertTrue((providers.size() == 1 ? 1 : 0) != 0);
        IdentityProvider ip = (IdentityProvider)providers.get(0);
        Assert.assertNotNull((Object)ip);
        Assert.assertEquals(ip.getClass(), UserIdentityProvider.class);
    }

    @Test
    public void testUserIdentityProvider() throws IOException {
        UserIdentityProvider uip = new UserIdentityProvider();
        String identity = uip.makeIdentity((Schedulable)new FakeSchedulable());
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String username = ugi.getUserName();
        Assert.assertEquals((Object)username, (Object)identity);
    }

    public class FakeSchedulable
    implements Schedulable {
        public UserGroupInformation getUserGroupInformation() {
            try {
                return UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

